/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Revision;

public class CommitListBuilder {
    private static final int MAX_TIME_BETWEEN_CHANGES_MILLISECONDS = 300000;
    private final Iterator revisions;
    private final Map currentCommits = new HashMap();
    private List commits;

    public CommitListBuilder(SortedSet revisions) {
        this(revisions.iterator());
    }

    public CommitListBuilder(Iterator revisions) {
        this.revisions = revisions;
    }

    public List createCommitList() {
        if (this.commits != null) {
            return this.commits;
        }
        this.commits = new LinkedList();
        while (this.revisions.hasNext()) {
            this.processRevision((Revision)this.revisions.next());
        }
        return this.commits;
    }

    protected void processRevision(Revision rev) {
        if (rev.getAuthor() == null) {
            return;
        }
        Commit commit = (Commit)this.currentCommits.get(rev.getAuthor());
        if (commit == null || !CommitListBuilder.isSameCommit(commit, rev)) {
            this.addNewCommit(rev);
        } else {
            this.addRevToCommit(commit, rev);
        }
    }

    protected void addNewCommit(Revision rev) {
        Commit newCommit = new Commit(rev);
        this.currentCommits.put(rev.getAuthor(), newCommit);
        this.commits.add(newCommit);
    }

    protected void addRevToCommit(Commit commit, Revision rev) {
        commit.addRevision(rev);
    }

    public static boolean isSameCommit(Commit commit, Revision rev) {
        return commit.getAuthor().equals(rev.getAuthor()) && commit.getComment().equals(rev.getComment()) && CommitListBuilder.isInTimeFrame(commit, rev.getDate());
    }

    public static boolean isInTimeFrame(Commit commit, Date date) {
        return date.getTime() > commit.getDate().getTime() - 300000L && date.getTime() < commit.getDate().getTime() + 300000L;
    }
}

