/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.Filter;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.Relation;
import chrriis.udoc.ui.layout.LayoutHandler;
import chrriis.udoc.ui.toolbar.ClassesToolBarMenu;
import chrriis.udoc.ui.toolbar.FilterToolBarMenu;
import chrriis.udoc.ui.toolbar.HelpToolBarMenu;
import chrriis.udoc.ui.toolbar.WorkspaceToolBarMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class ClassPane
extends JPanel {
    protected static final Color SUPER_TYPE_FOCUSED_RELATION_COLOR = new Color(0, 12, 255);
    protected static final Color SUPER_TYPE_RELATION_COLOR = new Color(180, 184, 255);
    protected static final Color SUB_TYPE_FOCUSED_RELATION_COLOR = new Color(208, 79, 255);
    protected static final Color SUB_TYPE_RELATION_COLOR = new Color(236, 182, 255);
    protected static final Color COMPOSITION_FOCUSED_RELATION_COLOR = new Color(20, 147, 26);
    protected static final Color COMPOSITION_RELATION_COLOR = new Color(171, 217, 173);
    protected static final Color ASSOCIATION_FOCUSED_RELATION_COLOR = new Color(252, 116, 48);
    protected static final Color ASSOCIATION_RELATION_COLOR = new Color(253, 193, 162);
    protected static final Color SELECTION_COLOR = new Color(255, 0, 78);
    protected static final Color SELECTION_FILL_COLOR = new Color(SELECTION_COLOR.getRed(), SELECTION_COLOR.getGreen(), SELECTION_COLOR.getBlue(), 30);
    public static final int PUBLIC_VISIBILITY = 1;
    public static final int PROTECTED_VISIBILITY = 2;
    public static final int DEFAULT_VISIBILITY = 3;
    public static final int PRIVATE_VISIBILITY = 4;
    protected static final Border TOOL_BAR_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(167, 166, 174));
    protected MouseHandler mouseHandler = new MouseHandler();
    protected Rectangle selectionRectangle;
    protected JPanel contentPane;
    protected JPanel menuPane;
    protected JPanel classComponentPane;
    protected JScrollBar vScrollBar;
    protected JScrollBar hScrollBar;
    protected JComponent toolBarComponent;
    protected ClassProcessor lastClassProcessor;
    protected String lastClassNames;
    protected List relationList = new ArrayList();
    protected boolean isCrawling;
    protected HashMap classInfoToClassComponentMap = new HashMap();
    protected boolean isValueAdjusting;
    protected HashMap classNameToLocationMap = new HashMap();
    protected Rectangle bounds;
    protected boolean isOverlapping;
    protected Set selectedClassComponentSet = new HashSet();
    protected volatile boolean isAutoLoading;
    protected Set filterSet = new HashSet();
    protected JComponent toolTipComponent;
    protected int fieldVisibility = 2;
    protected int methodVisibility = 2;
    protected boolean isLocked;
    protected String title;

    public boolean isOptimizedDrawingEnabled() {
        return !this.menuPane.isVisible();
    }

    public ClassPane() {
        this.menuPane = new MenuPane();
        this.menuPane.setVisible(false);
        this.add(this.menuPane);
        this.contentPane = new JPanel(new BorderLayout(0, 0)){

            public void reshape(int x, int y, int w, int h) {
                Rectangle cpBounds = this.getBounds();
                if (cpBounds.x == x && cpBounds.y == y && cpBounds.width == w && cpBounds.height == h) {
                    return;
                }
                ClassPane.this.closeMenus();
                if (ClassPane.this.bounds != null) {
                    Dimension size = this.getSize();
                    int offsetX = 0;
                    if (w > size.width) {
                        offsetX = Math.max(0, Math.min(-ClassPane.this.hScrollBar.getMinimum(), w - size.width) - Math.max(0, ClassPane.this.bounds.x + ClassPane.this.bounds.width - w + (ClassPane.this.vScrollBar.isVisible() ? ClassPane.this.vScrollBar.getWidth() : 0)));
                    }
                    int offsetY = 0;
                    if (h > size.height) {
                        offsetY = Math.max(0, Math.min(-ClassPane.this.vScrollBar.getMinimum(), h - size.height) - Math.max(0, ClassPane.this.bounds.y + ClassPane.this.bounds.height - h + (ClassPane.this.hScrollBar.isVisible() ? ClassPane.this.hScrollBar.getHeight() : 0)));
                    }
                    ClassPane.this.moveClassComponents(offsetX, offsetY);
                }
                super.reshape(x, y, w, h);
                ClassPane.this.adjustBounds();
            }
        };
        this.classComponentPane = new JPanel(null){

            public Color getBackground() {
                if (this.getComponentCount() == 0) {
                    return new Color(230, 230, 240);
                }
                return super.getBackground();
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                String s = "Christopher Deckers - chrriis@nextencia.net";
                if (ClassPane.this.title != null) {
                    s = String.valueOf(ClassPane.this.title) + " - " + s;
                }
                Font font = this.getFont().deriveFont(10.0f);
                g.setFont(font);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                Rectangle2D bounds = fontMetrics.getStringBounds(s, g);
                Dimension size = ClassPane.this.contentPane.getSize();
                g.setColor(Color.gray);
                g.drawString(s, (int)Math.round((double)size.width - bounds.getWidth() - (double)ClassPane.this.vScrollBar.getPreferredSize().width) - 3, fontMetrics.getAscent());
                ClassPane.this.paintClassComponentPane(g, false);
            }

            public void paint(Graphics g) {
                super.paint(g);
                if (ClassPane.this.selectionRectangle != null) {
                    g.setColor(SELECTION_FILL_COLOR);
                    g.fillRect(ClassPane.this.selectionRectangle.x, ClassPane.this.selectionRectangle.y, ClassPane.this.selectionRectangle.width, ClassPane.this.selectionRectangle.height);
                    g.setColor(SELECTION_COLOR);
                    g.drawRect(ClassPane.this.selectionRectangle.x, ClassPane.this.selectionRectangle.y, ClassPane.this.selectionRectangle.width, ClassPane.this.selectionRectangle.height);
                }
            }

            public void print(Graphics g) {
                ClassPane.this.paintClassComponentPane(g, true);
                int i = this.getComponentCount() - 1;
                while (i >= 0) {
                    Component component = this.getComponent(i);
                    if (component.isVisible()) {
                        Point location = component.getLocation();
                        g.translate(location.x, location.y);
                        component.print(g);
                        g.translate(-location.x, -location.y);
                    }
                    --i;
                }
            }

            public boolean isOptimizedDrawingEnabled() {
                return !ClassPane.this.isOverlapping;
            }
        };
        this.classComponentPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                int amount = e.getScrollType() == 1 ? ClassPane.this.getScrollableBlockIncrement() * e.getScrollAmount() : e.getUnitsToScroll() * ClassPane.this.getScrollableUnitIncrement();
                ClassPane.this.moveClassComponents(0, -amount);
            }
        });
        this.classComponentPane.setBackground(Color.WHITE);
        this.contentPane.add((Component)this.classComponentPane, "Center");
        this.classComponentPane.setOpaque(true);
        this.classComponentPane.addMouseListener(this.mouseHandler);
        this.classComponentPane.addMouseMotionListener(this.mouseHandler);
        this.classComponentPane.setFocusable(true);
        this.classComponentPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isControlPressed = (e.getModifiers() & 2) != 0;
                boolean isShiftPressed = (e.getModifiers() & 1) != 0;
                switch (e.getKeyCode()) {
                    case 116: {
                        ClassComponent[] classComponents;
                        if (ClassPane.this.isLocked()) {
                            return;
                        }
                        if (isControlPressed && isShiftPressed) {
                            ClassPane.this.setCrawling(!ClassPane.this.isCrawling());
                        }
                        if ((classComponents = ClassPane.this.getSelectedClassComponents()).length == 0) {
                            classComponents = ClassPane.this.getClassComponents();
                        }
                        ClassComponent[] classComponents_ = classComponents;
                        new Thread(this, classComponents_){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ ClassComponent[] val$classComponents_;
                            {
                                this.this$1 = var1_1;
                                this.val$classComponents_ = classComponentArray;
                            }

                            public void run() {
                                int i = 0;
                                while (i < this.val$classComponents_.length) {
                                    ClassComponent classComponent = this.val$classComponents_[i];
                                    if (classComponent.isVisible()) {
                                        classComponent.reload();
                                        if (4.access$0(this.this$1).isCrawling()) {
                                            SwingUtilities.invokeLater(new Runnable(this, classComponent){
                                                final /* synthetic */ 5 this$2;
                                                private final /* synthetic */ ClassComponent val$classComponent;
                                                {
                                                    this.this$2 = var1_1;
                                                    this.val$classComponent = classComponent;
                                                }

                                                public void run() {
                                                    this.val$classComponent.setRelationsVisible(true, 1);
                                                    this.val$classComponent.setRelationsVisible(true, 2);
                                                    this.val$classComponent.setRelationsVisible(true, 3);
                                                    this.val$classComponent.setRelationsVisible(true, 4);
                                                }
                                            });
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }.start();
                        break;
                    }
                    case 127: {
                        if (ClassPane.this.isLocked()) {
                            return;
                        }
                        if (isShiftPressed) {
                            ClassPane.this.deleteClassComponents(ClassPane.this.getSelectedClassComponents());
                            break;
                        }
                        ClassPane.this.setClassComponentsFiltered(ClassPane.this.getSelectedClassComponents(), true);
                        break;
                    }
                    case 65: {
                        if (!isControlPressed) break;
                        ClassPane.this.selectAllClassComponents();
                        break;
                    }
                    case 38: {
                        if (ClassPane.this.selectedClassComponentSet.isEmpty()) {
                            ClassPane.this.moveClassComponents(0, isControlPressed ? -ClassPane.this.getScrollableBlockIncrement() : -ClassPane.this.getScrollableUnitIncrement());
                            break;
                        }
                        ClassPane.this.moveSelectedClassComponents(0, isControlPressed ? -ClassPane.this.getScrollableBlockIncrement() : -ClassPane.this.getScrollableUnitIncrement());
                        break;
                    }
                    case 40: {
                        if (ClassPane.this.selectedClassComponentSet.isEmpty()) {
                            ClassPane.this.moveClassComponents(0, isControlPressed ? ClassPane.this.getScrollableBlockIncrement() : ClassPane.this.getScrollableUnitIncrement());
                            break;
                        }
                        ClassPane.this.moveSelectedClassComponents(0, isControlPressed ? ClassPane.this.getScrollableBlockIncrement() : ClassPane.this.getScrollableUnitIncrement());
                        break;
                    }
                    case 37: {
                        if (ClassPane.this.selectedClassComponentSet.isEmpty()) {
                            ClassPane.this.moveClassComponents(isControlPressed ? -ClassPane.this.getScrollableBlockIncrement() : -ClassPane.this.getScrollableUnitIncrement(), 0);
                            break;
                        }
                        ClassPane.this.moveSelectedClassComponents(isControlPressed ? -ClassPane.this.getScrollableBlockIncrement() : -ClassPane.this.getScrollableUnitIncrement(), 0);
                        break;
                    }
                    case 39: {
                        if (ClassPane.this.selectedClassComponentSet.isEmpty()) {
                            ClassPane.this.moveClassComponents(isControlPressed ? ClassPane.this.getScrollableBlockIncrement() : ClassPane.this.getScrollableUnitIncrement(), 0);
                            break;
                        }
                        ClassPane.this.moveSelectedClassComponents(isControlPressed ? ClassPane.this.getScrollableBlockIncrement() : ClassPane.this.getScrollableUnitIncrement(), 0);
                        break;
                    }
                    case 76: {
                        if (!isControlPressed) break;
                        ClassPane.this.adjustLayout();
                    }
                }
            }

            static /* synthetic */ ClassPane access$0(4 var0) {
                return var0.ClassPane.this;
            }
        });
        this.vScrollBar = new JScrollBar(1);
        this.contentPane.add((Component)this.vScrollBar, "East");
        JPanel hScrollBarPanel = new JPanel(new BorderLayout(0, 0));
        this.hScrollBar = new JScrollBar(0);
        hScrollBarPanel.add((Component)this.hScrollBar, "Center");
        hScrollBarPanel.add((Component)new JPanel(null){

            public Dimension getPreferredSize() {
                return ClassPane.this.vScrollBar.isVisible() ? new Dimension(ClassPane.this.vScrollBar.getWidth(), 0) : new Dimension(0, 0);
            }
        }, "East");
        this.contentPane.add((Component)hScrollBarPanel, "South");
        this.adjustBounds();
        this.vScrollBar.addAdjustmentListener(new AdjustmentListener(){
            int diff;

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ClassPane.this.isValueAdjusting = e.getValueIsAdjusting();
                if (!ClassPane.this.isValueAdjusting) {
                    int value = this.diff - e.getValue();
                    this.diff = 0;
                    if (value != 0) {
                        ClassPane.this.moveClassComponents(0, value);
                    } else {
                        ClassPane.this.adjustBounds();
                        ClassPane.this.classComponentPane.repaint();
                    }
                } else {
                    if (this.diff != 0) {
                        ClassPane.this.moveClassComponents(0, this.diff);
                        this.diff = 0;
                    }
                    ClassPane.this.moveClassComponents(0, -e.getValue());
                    this.diff -= -e.getValue();
                }
                ClassPane.this.isValueAdjusting = false;
            }
        });
        this.hScrollBar.addAdjustmentListener(new AdjustmentListener(){
            int diff;

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ClassPane.this.isValueAdjusting = e.getValueIsAdjusting();
                if (!ClassPane.this.isValueAdjusting) {
                    int value = this.diff - e.getValue();
                    this.diff = 0;
                    if (value != 0) {
                        ClassPane.this.moveClassComponents(value, 0);
                    } else {
                        ClassPane.this.adjustBounds();
                        ClassPane.this.classComponentPane.repaint();
                    }
                } else {
                    if (this.diff != 0) {
                        ClassPane.this.moveClassComponents(this.diff, 0);
                        this.diff = 0;
                    }
                    ClassPane.this.moveClassComponents(-e.getValue(), 0);
                    this.diff -= -e.getValue();
                }
                ClassPane.this.isValueAdjusting = false;
            }
        });
        this.toolBarComponent = this.createToolBarComponent();
        this.contentPane.add((Component)this.toolBarComponent, "North");
        this.add(this.contentPane);
        this.setComponentZOrder(this.menuPane, 0);
        this.setLayout(this.createClassPaneLayout());
    }

    protected int getScrollableUnitIncrement() {
        return 10;
    }

    protected int getScrollableBlockIncrement() {
        return 50;
    }

    public void setContent(String classNames, ClassProcessor classProcessor) {
        this.classComponentPane.removeAll();
        this.relationList = new ArrayList();
        this.classInfoToClassComponentMap = new HashMap();
        final ClassComponent[] classComponents = this.addClasses(classNames, classProcessor);
        if (classComponents.length == 0) {
            return;
        }
        new Thread(){

            public void run() {
                int i = 0;
                while (i < classComponents.length) {
                    ClassComponent classComponent = classComponents[i];
                    if (classComponent != null) {
                        classComponent.load();
                        SwingUtilities.invokeLater(new Runnable(this, classComponent){
                            final /* synthetic */ 10 this$1;
                            private final /* synthetic */ ClassComponent val$classComponent;
                            {
                                this.this$1 = var1_1;
                                this.val$classComponent = classComponent;
                            }

                            public void run() {
                                this.val$classComponent.setExpanded(true);
                                this.val$classComponent.setRelationsVisible(true, 1);
                                this.val$classComponent.setRelationsVisible(true, 2);
                                this.val$classComponent.setRelationsVisible(true, 3);
                                this.val$classComponent.setRelationsVisible(true, 4);
                                10.access$0(this.this$1).clearSelectedClassComponents();
                            }
                        });
                    }
                    ++i;
                }
            }

            static /* synthetic */ ClassPane access$0(10 var0) {
                return var0.ClassPane.this;
            }
        }.start();
    }

    public ClassProcessor getLastClassProcessor() {
        return this.lastClassProcessor;
    }

    public void setLastClassProcessor(ClassProcessor lastClassProcessor) {
        this.lastClassProcessor = lastClassProcessor;
    }

    public String getLastClassNames() {
        return this.lastClassNames;
    }

    public void setLastClassNames(String lastClassNames) {
        this.lastClassNames = lastClassNames;
    }

    public ClassComponent[] addClasses(String classNames, ClassProcessor classProcessor) {
        if (classNames == null || classNames.length() == 0) {
            return new ClassComponent[0];
        }
        StringTokenizer st = new StringTokenizer(classNames, String.valueOf(Util.getPathSeparator()) + " ");
        int count = st.countTokens();
        if (count == 0) {
            return new ClassComponent[0];
        }
        boolean isComponentAdded = false;
        ClassComponent[] classComponents = new ClassComponent[count];
        this.lastClassNames = classNames;
        this.lastClassProcessor = classProcessor;
        ArrayList<ClassComponent> componentToPositionList = new ArrayList<ClassComponent>();
        int i = 0;
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            if (className.length() != 0) {
                ClassInfo classInfo = ClassInfoLoader.createClassInfo(className, classProcessor);
                boolean isClassComponentPresent = this.isClassComponentPresent(classInfo);
                ClassComponent classComponent = this.createClassComponent(classInfo);
                this.removeFilters(classInfo);
                if (!isClassComponentPresent) {
                    this.addClassComponent(classComponent);
                    isComponentAdded = true;
                    componentToPositionList.add(classComponent);
                }
                this.classComponentPane.setComponentZOrder(classComponent, 0);
                classComponents[i] = classComponent;
            }
            ++i;
        }
        if (isComponentAdded) {
            int componentCount = componentToPositionList.size();
            int width = 0;
            int SPACE = 50;
            int i2 = 0;
            while (i2 < componentCount) {
                Dimension cSize = ((Component)componentToPositionList.get(i2)).getSize();
                if (i2 > 0) {
                    width += SPACE;
                }
                width += cSize.width;
                ++i2;
            }
            Dimension size = this.classComponentPane.getSize();
            int start = (size.width - width) / 2;
            int i3 = 0;
            while (i3 < componentCount) {
                ClassComponent classComponent = (ClassComponent)componentToPositionList.get(i3);
                Dimension cSize = classComponent.getSize();
                Point location = new Point(start, (size.height - cSize.height) / 2);
                classComponent.setLocation(location);
                this.classNameToLocationMap.put(classComponent.getClassInfo().getClassName(), location);
                start += cSize.width;
                start += SPACE;
                ++i3;
            }
            this.adjustBounds();
        }
        return classComponents;
    }

    protected void setDevelopped(ClassComponent classComponent, boolean isDevelopped) {
        this.adjustBounds();
        this.classComponentPane.repaint();
    }

    protected void setRelationsVisible(ClassComponent classComponent, ClassInfo[] relatedClassInfos, boolean areRelationsVisible, int relationType) {
        ArrayList<Relation> relationList = new ArrayList<Relation>();
        HashSet<ClassComponent> componentSet = new HashSet<ClassComponent>();
        int i = 0;
        while (i < relatedClassInfos.length) {
            ClassComponent relatedClassComponent = this.createClassComponent(relatedClassInfos[i]);
            relationList.add(new Relation(relationType, classComponent, relatedClassComponent));
            componentSet.add(relatedClassComponent);
            ++i;
        }
        if (!areRelationsVisible) {
            this.relationList.removeAll(relationList);
            i = this.relationList.size() - 1;
            while (i >= 0) {
                Relation relation = (Relation)this.relationList.get(i);
                componentSet.remove(relation.getClassComponent1());
                componentSet.remove(relation.getClassComponent2());
                --i;
            }
            this.removeClassComponents(componentSet.toArray(new ClassComponent[0]));
            return;
        }
        this.relationList.addAll(relationList);
        Iterator it = componentSet.iterator();
        while (it.hasNext()) {
            ClassComponent newClassComponent = (ClassComponent)it.next();
            if (newClassComponent.getParent() == null) {
                this.addClassComponent(newClassComponent);
                continue;
            }
            it.remove();
        }
        this.adjustClassComponents(classComponent, componentSet.toArray(new ClassComponent[0]), relationType);
    }

    protected void adjustClassComponents(ClassComponent mainClassComponent, ClassComponent[] classComponents, final int relationType) {
        ClassComponent classComponent;
        if (classComponents.length == 0) {
            return;
        }
        this.clearSelectedClassComponents();
        ArrayList<ClassComponent> componentList = new ArrayList<ClassComponent>();
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent2 = classComponents[i];
            Point location = (Point)this.classNameToLocationMap.get(classComponent2.getClassInfo().getClassName());
            if (location != null) {
                classComponent2.setLocation(location);
                this.addSelectedClassComponent(classComponent2);
            } else {
                componentList.add(classComponent2);
            }
            ++i;
        }
        classComponents = componentList.toArray(new ClassComponent[0]);
        Arrays.sort(classComponents, new Comparator(){

            public int compare(Object o1, Object o2) {
                ClassInfo c1 = ((ClassComponent)o1).getClassInfo();
                ClassInfo c2 = ((ClassComponent)o2).getClassInfo();
                int m1 = c1.getModifiers();
                int m2 = c2.getModifiers();
                int result = 0;
                result = (m1 & 0x40) != 0 ? ((m2 & 0x100) != 0 ? 1 : c1.getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getName().toLowerCase(Locale.ENGLISH))) : ((m2 & 0x40) != 0 ? -1 : c1.getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getName().toLowerCase(Locale.ENGLISH)));
                if (relationType == 2 || relationType == 3) {
                    result = -result;
                }
                return result;
            }
        });
        double angle = 1.5707963267948966 / (double)(classComponents.length + 1);
        Rectangle bounds = mainClassComponent.getBounds();
        Point origin = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        int distance = 30 * classComponents.length + 40 + (int)Math.round(Math.sqrt(Math.pow(origin.x - bounds.x, 2.0) + Math.pow(origin.y - bounds.y, 2.0)));
        int i2 = 0;
        while (i2 < classComponents.length) {
            classComponent = classComponents[i2];
            Rectangle cBounds = classComponent.getBounds();
            AffineTransform at = new AffineTransform();
            double cAngle = angle * (double)(i2 + 1);
            switch (relationType) {
                case 1: {
                    cAngle -= 0.7853981633974483;
                    break;
                }
                case 2: {
                    cAngle += 2.356194490192345;
                    break;
                }
                case 3: {
                    cAngle -= 2.356194490192345;
                    break;
                }
                case 4: {
                    cAngle += 0.7853981633974483;
                }
            }
            at.setToRotation(cAngle, origin.x, origin.y);
            Point result = new Point();
            at.transform(new Point(origin.x, origin.y - distance), result);
            result.x -= cBounds.width / 2;
            result.y -= cBounds.height / 2;
            this.classNameToLocationMap.put(classComponent.getClassInfo().getClassName(), result);
            classComponent.setLocation(result);
            ++i2;
        }
        if (relationType == 2 || relationType == 3) {
            i2 = 0;
            while (i2 < classComponents.length) {
                classComponent = classComponents[i2];
                this.classComponentPane.setComponentZOrder(classComponent, 0);
                this.addSelectedClassComponent(classComponent);
                ++i2;
            }
        } else {
            i2 = classComponents.length - 1;
            while (i2 >= 0) {
                classComponent = classComponents[i2];
                this.classComponentPane.setComponentZOrder(classComponent, 0);
                this.addSelectedClassComponent(classComponent);
                --i2;
            }
        }
        this.classComponentPane.revalidate();
        this.classComponentPane.repaint();
        this.adjustBounds();
    }

    public boolean isCrawling() {
        return this.isCrawling;
    }

    public void setCrawling(boolean isCrawling) {
        this.isCrawling = isCrawling;
    }

    protected void addClassComponent(final ClassComponent classComponent) {
        ClassInfo classInfo = classComponent.getClassInfo();
        if (!this.classInfoToClassComponentMap.containsValue(classComponent)) {
            this.classInfoToClassComponentMap.put(classInfo, classComponent);
            this.classNameToLocationMap.put(classInfo.getClassName(), classComponent.getLocation());
        }
        this.classComponentPane.add(classComponent);
        if (this.isFiltered(classInfo)) {
            classComponent.setVisible(false);
        }
        this.classComponentPane.revalidate();
        this.classComponentPane.repaint();
        if (this.isCrawling) {
            new Thread(){

                public void run() {
                    classComponent.load();
                    SwingUtilities.invokeLater(new Runnable(this, classComponent){
                        final /* synthetic */ 13 this$1;
                        private final /* synthetic */ ClassComponent val$classComponent;
                        {
                            this.this$1 = var1_1;
                            this.val$classComponent = classComponent;
                        }

                        public void run() {
                            this.val$classComponent.setRelationsVisible(true, 1);
                            this.val$classComponent.setRelationsVisible(true, 2);
                            this.val$classComponent.setRelationsVisible(true, 3);
                            this.val$classComponent.setRelationsVisible(true, 4);
                        }
                    });
                }
            }.start();
        }
    }

    protected void removeClassComponents(ClassComponent[] classComponents) {
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent = classComponents[i];
            ClassInfo classInfo = classComponent.getClassInfo();
            this.classNameToLocationMap.remove(classInfo.getClassName());
            this.classInfoToClassComponentMap.remove(classInfo);
            this.classComponentPane.remove(classComponent);
            int j = this.relationList.size() - 1;
            while (j >= 0) {
                Relation relation = (Relation)this.relationList.get(j);
                if (relation.getClassComponent1() == classComponent || relation.getClassComponent2() == classComponent) {
                    this.relationList.remove(j);
                }
                --j;
            }
            ClassInfoLoader.destroyClassInfo(classInfo);
            ++i;
        }
        this.adjustBounds();
        this.classComponentPane.revalidate();
        this.classComponentPane.repaint();
    }

    protected boolean isClassComponentPresent(ClassInfo classInfo) {
        return this.classInfoToClassComponentMap.get(classInfo) != null;
    }

    protected ClassComponent createClassComponent(ClassInfo classInfo) {
        ClassComponent classComponent = (ClassComponent)this.classInfoToClassComponentMap.get(classInfo);
        if (classComponent == null) {
            classComponent = new ClassComponent(this, classInfo);
            this.classInfoToClassComponentMap.put(classInfo, classComponent);
        }
        return classComponent;
    }

    public ClassComponent getClassComponent(ClassInfo classInfo) {
        return (ClassComponent)this.classInfoToClassComponentMap.get(classInfo);
    }

    protected ClassComponent getClassComponent(String className) {
        Iterator it = this.classInfoToClassComponentMap.values().iterator();
        while (it.hasNext()) {
            ClassComponent classComponent = (ClassComponent)it.next();
            if (!className.equals(classComponent.getClassInfo().getClassName())) continue;
            return classComponent;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            Rectangle bounds = this.classComponentPane.getComponent(i).getBounds();
            size.width = Math.max(size.width, bounds.x + bounds.width);
            size.height = Math.max(size.height, bounds.y + bounds.height);
            --i;
        }
        return size;
    }

    protected Collection filterRelationList() {
        HashMap<Object, Relation> hashMap = new HashMap<Object, Relation>();
        int i = this.relationList.size() - 1;
        while (i >= 0) {
            Relation relation = (Relation)this.relationList.get(i);
            Object key = relation.getKey();
            Relation storedRelation = (Relation)hashMap.get(key);
            if (storedRelation != null) {
                if (storedRelation.getType() > relation.getType()) {
                    hashMap.put(key, relation);
                }
            } else {
                hashMap.put(key, relation);
            }
            --i;
        }
        if (hashMap.size() == this.relationList.size()) {
            return this.relationList;
        }
        return hashMap.values();
    }

    protected void paintClassComponentPane(Graphics g, boolean isPrinting) {
        Collection relationList = this.filterRelationList();
        Iterator it = relationList.iterator();
        while (it.hasNext()) {
            Point p2;
            Relation relation = (Relation)it.next();
            ClassComponent classComponent1 = relation.getClassComponent1();
            ClassComponent classComponent2 = relation.getClassComponent2();
            if (!classComponent1.isVisible() || !classComponent2.isVisible()) continue;
            Point center1 = classComponent1.getCenter();
            Point center2 = classComponent2.getCenter();
            Point p1 = classComponent1.getRelationPoint(center2);
            if (p1 == null || (p2 = classComponent2.getRelationPoint(center1)) == null) continue;
            switch (relation.getType()) {
                case 1: {
                    int length = (int)Math.round(Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0)));
                    int arrowLength = 12;
                    if (length <= arrowLength + 2) {
                        if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                            g.setColor(SUPER_TYPE_FOCUSED_RELATION_COLOR);
                        } else {
                            g.setColor(SUPER_TYPE_RELATION_COLOR);
                        }
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        break;
                    }
                    int arrowBase = 5;
                    int x = p1.x;
                    int y = p1.y;
                    Polygon polygon = new Polygon(new int[]{x, x, x - arrowBase, x, x + arrowBase, x}, new int[]{y, y - length + arrowLength, y - length + arrowLength, y - length, y - length + arrowLength, y - length + arrowLength}, 6);
                    double angle = Math.atan((double)(p2.x - p1.x) / (double)(p2.y - p1.y));
                    if (p1.y <= p2.y) {
                        angle += Math.PI;
                    }
                    AffineTransform at = AffineTransform.getRotateInstance(-angle, p1.x, p1.y);
                    g.setColor(Color.WHITE);
                    ((Graphics2D)g).fill(at.createTransformedShape(polygon));
                    if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                        g.setColor(SUPER_TYPE_FOCUSED_RELATION_COLOR);
                    } else {
                        g.setColor(SUPER_TYPE_RELATION_COLOR);
                    }
                    ((Graphics2D)g).draw(at.createTransformedShape(polygon));
                    break;
                }
                case 2: {
                    int length = (int)Math.round(Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0)));
                    int arrowLength = 12;
                    if (length <= arrowLength + 2) {
                        if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                            g.setColor(SUB_TYPE_FOCUSED_RELATION_COLOR);
                        } else {
                            g.setColor(SUB_TYPE_RELATION_COLOR);
                        }
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        break;
                    }
                    int arrowBase = 5;
                    int x = p2.x;
                    int y = p2.y;
                    Polygon polygon = new Polygon(new int[]{x, x, x - arrowBase, x, x + arrowBase, x}, new int[]{y, y - length + arrowLength, y - length + arrowLength, y - length, y - length + arrowLength, y - length + arrowLength}, 6);
                    double angle = Math.atan((double)(p1.x - p2.x) / (double)(p1.y - p2.y));
                    if (p2.y <= p1.y) {
                        angle += Math.PI;
                    }
                    AffineTransform at = AffineTransform.getRotateInstance(-angle, p2.x, p2.y);
                    g.setColor(Color.WHITE);
                    ((Graphics2D)g).fill(at.createTransformedShape(polygon));
                    if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                        g.setColor(SUB_TYPE_FOCUSED_RELATION_COLOR);
                    } else {
                        g.setColor(SUB_TYPE_RELATION_COLOR);
                    }
                    ((Graphics2D)g).draw(at.createTransformedShape(polygon));
                    break;
                }
                case 3: {
                    int length = (int)Math.round(Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0)));
                    int diamondArrowLength = 8;
                    if (length <= diamondArrowLength * 2 + 2) {
                        if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                            g.setColor(COMPOSITION_FOCUSED_RELATION_COLOR);
                        } else {
                            g.setColor(COMPOSITION_RELATION_COLOR);
                        }
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        break;
                    }
                    int arrowBase = 5;
                    int x = p2.x;
                    int y = p2.y;
                    Polygon polygon = new Polygon(new int[]{x, x, x - arrowBase, x, x + arrowBase, x}, new int[]{y, y - length + diamondArrowLength * 2, y - length + diamondArrowLength, y - length, y - length + diamondArrowLength, y - length + diamondArrowLength * 2}, 6);
                    double angle = Math.atan((double)(p1.x - p2.x) / (double)(p1.y - p2.y));
                    if (p2.y <= p1.y) {
                        angle += Math.PI;
                    }
                    AffineTransform at = AffineTransform.getRotateInstance(-angle, p2.x, p2.y);
                    g.setColor(Color.WHITE);
                    ((Graphics2D)g).fill(at.createTransformedShape(polygon));
                    if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                        g.setColor(COMPOSITION_FOCUSED_RELATION_COLOR);
                    } else {
                        g.setColor(COMPOSITION_RELATION_COLOR);
                    }
                    ((Graphics2D)g).draw(at.createTransformedShape(polygon));
                    break;
                }
                case 4: {
                    int length = (int)Math.round(Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0)));
                    int arrowLength = 8;
                    if (length <= arrowLength + 2) {
                        if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                            g.setColor(ASSOCIATION_FOCUSED_RELATION_COLOR);
                        } else {
                            g.setColor(ASSOCIATION_RELATION_COLOR);
                        }
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        break;
                    }
                    int arrowBase = 4;
                    int x = p1.x;
                    int y = p1.y;
                    Polygon polygon = new Polygon(new int[]{x, x, x - arrowBase, x, x + arrowBase, x}, new int[]{y, y - length, y - length + arrowLength, y - length, y - length + arrowLength, y - length}, 6);
                    double angle = Math.atan((double)(p2.x - p1.x) / (double)(p2.y - p1.y));
                    if (p1.y <= p2.y) {
                        angle += Math.PI;
                    }
                    AffineTransform at = AffineTransform.getRotateInstance(-angle, p1.x, p1.y);
                    g.setColor(Color.WHITE);
                    ((Graphics2D)g).fill(at.createTransformedShape(polygon));
                    if (isPrinting || this.isClassComponentSelected(classComponent1) || this.isClassComponentSelected(classComponent2)) {
                        g.setColor(ASSOCIATION_FOCUSED_RELATION_COLOR);
                    } else {
                        g.setColor(ASSOCIATION_RELATION_COLOR);
                    }
                    ((Graphics2D)g).draw(at.createTransformedShape(polygon));
                }
            }
        }
        if (this.classComponentPane.getComponentCount() == 0) {
            int x = 40;
            int y = 45;
            g.drawImage(IconManager.getImage("UDoc64x64.png"), x, y, this.classComponentPane);
            Font font = new Font("SansSerif", 0, 20);
            g.setFont(font);
            g.setColor(Color.BLUE.darker());
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int h = fm.getHeight();
            Object aaRenderingHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString("Welcome to UDoc!", x + 64 + 10, y + (64 + h) / 2);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaRenderingHint);
            y += 64;
            font = new Font("SansSerif", 0, 12);
            g.setFont(font);
            g.setColor(Color.BLUE);
            fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            h = fm.getHeight() + fm.getLeading();
            g.drawString("To start, use one of the following arrow menus:", x, (y += 20) + h);
            g.drawString("- \"Workspace\" to load an existing workspace", x += 20, (y += h) + h);
            g.drawString("- \"Classes\" to add some classes to this empty workspace", x, (y += h) + h);
        }
    }

    protected void moveClassComponents(int offsetX, int offsetY) {
        if (offsetX == 0 && offsetY == 0) {
            return;
        }
        this.closeMenus();
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            ClassComponent classComponent = (ClassComponent)this.classComponentPane.getComponent(i);
            Point location = classComponent.getLocation();
            location.x += offsetX;
            location.y += offsetY;
            this.classNameToLocationMap.put(classComponent.getClassInfo().getClassName(), location);
            classComponent.setLocation(location);
            --i;
        }
        this.adjustBounds();
        this.classComponentPane.repaint();
    }

    protected void moveSelectedClassComponents(int offsetX, int offsetY) {
        this.moveSelectedClassComponent(null, offsetX, offsetY);
    }

    protected void moveSelectedClassComponent(ClassComponent mainClassComponent, int offsetX, int offsetY) {
        if (mainClassComponent != null) {
            Point p = mainClassComponent.getLocation();
            p.x += offsetX;
            p.y += offsetY;
            this.classNameToLocationMap.put(mainClassComponent.getClassInfo().getClassName(), p);
            mainClassComponent.setLocation(p);
        }
        Iterator it = this.selectedClassComponentSet.iterator();
        while (it.hasNext()) {
            ClassComponent classComponent = (ClassComponent)it.next();
            if (classComponent == mainClassComponent) continue;
            Point location = classComponent.getLocation();
            location.x += offsetX;
            location.y += offsetY;
            this.classNameToLocationMap.put(classComponent.getClassInfo().getClassName(), location);
            classComponent.setLocation(location);
        }
        this.adjustBounds();
        this.classComponentPane.repaint();
    }

    protected String[] getLocatedClasses() {
        return this.classNameToLocationMap.keySet().toArray(new String[0]);
    }

    protected Point getClassLocation(String className) {
        return (Point)this.classNameToLocationMap.get(className);
    }

    protected void clearClassLocations() {
        this.classNameToLocationMap.clear();
    }

    protected void setClassLocations(String[] classNames, Point[] locations) {
        this.clearClassLocations();
        int i = 0;
        while (i < classNames.length) {
            this.classNameToLocationMap.put(classNames[i], locations[i]);
            ++i;
        }
    }

    public void adjustBounds() {
        if (this.isValueAdjusting) {
            return;
        }
        Dimension size = this.contentPane.getSize();
        Rectangle bounds = new Rectangle();
        this.isOverlapping = false;
        Rectangle visibleArea = new Rectangle(size);
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            Component classComponent = this.classComponentPane.getComponent(i);
            if (classComponent.isVisible()) {
                Rectangle cBounds = classComponent.getBounds();
                if (!this.isOverlapping && cBounds.intersects(visibleArea)) {
                    int j = i - 1;
                    while (j >= 0) {
                        Rectangle cBounds2 = this.classComponentPane.getComponent(j).getBounds();
                        if (cBounds2.intersects(visibleArea) && cBounds2.intersects(cBounds)) {
                            this.isOverlapping = true;
                            break;
                        }
                        --j;
                    }
                }
                if (cBounds.x < bounds.x) {
                    bounds.width += bounds.x - cBounds.x;
                    bounds.x = cBounds.x;
                }
                bounds.width = Math.max(bounds.width, cBounds.x + cBounds.width - bounds.x + 1);
                if (cBounds.y < bounds.y) {
                    bounds.height += bounds.y - cBounds.y;
                    bounds.y = cBounds.y;
                }
                int toolBarHeight = this.toolBarComponent.isVisible() ? this.toolBarComponent.getHeight() : 0;
                bounds.height = Math.max(bounds.height, cBounds.y + cBounds.height - bounds.y + toolBarHeight + 1);
            }
            --i;
        }
        if (this.bounds == bounds) {
            return;
        }
        this.bounds = bounds;
        this.hScrollBar.setVisible(false);
        this.vScrollBar.setVisible(false);
        if (bounds.y < 0 || size.height < bounds.height) {
            this.vScrollBar.setVisible(true);
            size.width -= this.vScrollBar.getWidth();
        }
        if (bounds.x < 0 || size.width < bounds.width) {
            this.hScrollBar.setVisible(true);
            size.height -= this.hScrollBar.getHeight();
        }
        if (size.height < bounds.height && !this.vScrollBar.isVisible()) {
            this.vScrollBar.setVisible(true);
            size.width -= this.vScrollBar.getWidth();
        }
        this.hScrollBar.setValues(0, size.width, bounds.x, Math.max(size.width, bounds.x + bounds.width - 1));
        this.vScrollBar.setValues(0, size.height, bounds.y, Math.max(size.height, bounds.y + bounds.height - 1));
    }

    public Rectangle getClassComponentAreaBounds() {
        return this.bounds;
    }

    protected boolean isClassComponentSelected(ClassComponent classComponent) {
        return this.selectedClassComponentSet.contains(classComponent);
    }

    public void addSelectedClassComponent(ClassComponent classComponent) {
        if (!classComponent.isVisible()) {
            return;
        }
        this.selectedClassComponentSet.add(classComponent);
        classComponent.setSelected(true);
        this.classComponentPane.repaint();
    }

    protected void removeSelectedClassComponent(ClassComponent classComponent) {
        this.selectedClassComponentSet.remove(classComponent);
        classComponent.setSelected(false);
        this.classComponentPane.repaint();
    }

    protected void setSelectedClassComponent(ClassComponent classComponent) {
        this.clearSelectedClassComponents();
        this.addSelectedClassComponent(classComponent);
    }

    protected void selectAllClassComponents() {
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            this.addSelectedClassComponent((ClassComponent)this.classComponentPane.getComponent(i));
            --i;
        }
    }

    public ClassComponent[] getSelectedClassComponents() {
        return this.selectedClassComponentSet.toArray(new ClassComponent[0]);
    }

    public void clearSelectedClassComponents() {
        Iterator it = this.selectedClassComponentSet.iterator();
        while (it.hasNext()) {
            ((ClassComponent)it.next()).setSelected(false);
        }
        this.selectedClassComponentSet.clear();
        this.classComponentPane.repaint();
    }

    public boolean isAutoLoading() {
        return this.isAutoLoading;
    }

    public void setAutoLoading(boolean isAutoLoading) {
        this.isAutoLoading = isAutoLoading;
        if (!isAutoLoading) {
            return;
        }
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            ((ClassComponent)this.classComponentPane.getComponent(i)).autoLoad();
            --i;
        }
    }

    public void setClassComponentsFiltered(ClassComponent[] classComponents, boolean areFiltered) {
        if (!areFiltered) {
            this.clearSelectedClassComponents();
        }
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent = classComponents[i];
            ClassInfo classInfo = classComponent.getClassInfo();
            if (areFiltered) {
                this.addFilter(new Filter(classInfo.getClassName()));
                this.removeSelectedClassComponent(classComponent);
            } else {
                this.removeFilters(classInfo);
                this.addSelectedClassComponent(classComponent);
            }
            ++i;
        }
        this.classComponentPane.repaint();
    }

    protected boolean isFiltered(ClassInfo classInfo) {
        Iterator it = this.filterSet.iterator();
        while (it.hasNext()) {
            Filter filter = (Filter)it.next();
            if (!filter.matches(classInfo)) continue;
            return true;
        }
        return false;
    }

    public Filter[] getFilters() {
        return this.filterSet.toArray(new Filter[0]);
    }

    public void setFilters(Filter[] filters) {
        this.filterSet.clear();
        int i = 0;
        while (i < filters.length) {
            this.addFilter(filters[i]);
            ++i;
        }
    }

    public void addFilter(Filter filter) {
        this.filterSet.add(filter);
        int i = this.classComponentPane.getComponentCount() - 1;
        while (i >= 0) {
            ClassComponent classComponent = (ClassComponent)this.classComponentPane.getComponent(i);
            if (filter.matches(classComponent.getClassInfo())) {
                classComponent.setVisible(false);
            }
            --i;
        }
        this.classComponentPane.repaint();
    }

    public void removeFilter(Filter filter) {
        if (!this.filterSet.remove(filter)) {
            return;
        }
        Component[] components = this.classComponentPane.getComponents();
        int i = 0;
        while (i < components.length) {
            ClassComponent classComponent = (ClassComponent)components[i];
            if (filter.matches(classComponent.getClassInfo())) {
                classComponent.setVisible(true);
            }
            ++i;
        }
        this.classComponentPane.repaint();
    }

    protected void removeFilters(ClassInfo classInfo) {
        ArrayList<Filter> nameFilterList = new ArrayList<Filter>();
        Component[] components = this.classComponentPane.getComponents();
        Iterator it = this.filterSet.iterator();
        while (it.hasNext()) {
            Filter filter = (Filter)it.next();
            if (!filter.matches(classInfo)) continue;
            it.remove();
            int i = 0;
            while (i < components.length) {
                ClassComponent classComponent = (ClassComponent)components[i];
                ClassInfo cClassInfo = classComponent.getClassInfo();
                if (cClassInfo.equals(classInfo)) {
                    classComponent.setVisible(true);
                } else if (filter.matches(cClassInfo)) {
                    nameFilterList.add(new Filter(cClassInfo.getClassName()));
                }
                ++i;
            }
        }
        int i = nameFilterList.size() - 1;
        while (i >= 0) {
            this.filterSet.add(nameFilterList.get(i));
            --i;
        }
        this.classComponentPane.repaint();
    }

    public void deleteClassComponents(ClassComponent[] classComponents) {
        if (!this.areClassComponentsDeletable(classComponents)) {
            return;
        }
        this.removeClassComponents(classComponents);
    }

    public boolean areClassComponentsReloadable(ClassComponent[] classComponents) {
        if (classComponents.length == 0) {
            return false;
        }
        int i = 0;
        while (i < classComponents.length) {
            if (!classComponents[i].isReloadable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean areClassComponentsDeletable(ClassComponent[] classComponents) {
        if (classComponents.length == 0) {
            return false;
        }
        HashSet<ClassComponent> hashSet = new HashSet<ClassComponent>();
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent = classComponents[i];
            hashSet.add(classComponent);
            ++i;
        }
        i = this.relationList.size() - 1;
        while (i >= 0) {
            Relation relation = (Relation)this.relationList.get(i);
            if (hashSet.contains(relation.getClassComponent1()) ? !hashSet.contains(relation.getClassComponent2()) : hashSet.contains(relation.getClassComponent2()) && !hashSet.contains(relation.getClassComponent1())) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected JComponent createToolBarComponent() {
        JPanel toolBarPanelComponent = new JPanel(new FlowLayout(0, 0, 0));
        toolBarPanelComponent.setBorder(TOOL_BAR_BORDER);
        toolBarPanelComponent.add(new WorkspaceToolBarMenu(this));
        toolBarPanelComponent.add(new ClassesToolBarMenu(this));
        toolBarPanelComponent.add(new FilterToolBarMenu(this));
        toolBarPanelComponent.add(new HelpToolBarMenu(this));
        return toolBarPanelComponent;
    }

    public ClassComponent[] getClassComponents() {
        Component[] components = this.classComponentPane.getComponents();
        ClassComponent[] classComponents = new ClassComponent[components.length];
        System.arraycopy(components, 0, classComponents, 0, components.length);
        return classComponents;
    }

    protected LayoutManager createClassPaneLayout() {
        return new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public void layoutContainer(Container parent) {
                Dimension size = parent.getSize();
                ClassPane.this.contentPane.setSize(size);
                ClassPane.this.menuPane.setSize(size);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return ClassPane.this.bounds.getSize();
            }

            public Dimension preferredLayoutSize(Container parent) {
                return ClassPane.this.bounds.getSize();
            }
        };
    }

    public JComponent getMenuPane() {
        return this.menuPane;
    }

    public void showTooltip(JComponent tooltip, JComponent invoker, int x, int y) {
        this.hideTooltip();
        Point p = SwingUtilities.convertPoint(invoker, x, y, this.menuPane);
        Dimension mSize = tooltip.getPreferredSize();
        Dimension size = this.getSize();
        if (p.x + mSize.width > size.width) {
            p.x = size.width - mSize.width;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y + mSize.height > size.height) {
            p.y = size.height - mSize.height;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        tooltip.setLocation(p.x, p.y);
        this.toolTipComponent = tooltip;
        this.menuPane.add(tooltip);
        this.menuPane.revalidate();
        this.menuPane.repaint();
        this.menuPane.setVisible(true);
        this.showMenu(tooltip);
    }

    protected void showMenu(JComponent menu) {
        Dimension size = menu.getPreferredSize();
        menu.setSize(new Dimension(size.width, 0));
        this.developMenu(menu, System.currentTimeMillis(), size);
    }

    protected void developMenu(final JComponent menuComponent, final long timeReference, final Dimension size) {
        Dimension d = new Dimension(size);
        float ratio = (float)(System.currentTimeMillis() - timeReference) / 100.0f;
        d.height = Math.round((float)d.height * ratio);
        menuComponent.setSize(Math.min(size.width, d.width), Math.min(size.height, d.height));
        menuComponent.revalidate();
        menuComponent.repaint();
        if (size.height > d.height) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassPane.this.developMenu(menuComponent, timeReference, size);
                }
            });
        }
    }

    public void hideTooltip() {
        if (this.toolTipComponent == null) {
            return;
        }
        this.menuPane.remove(this.toolTipComponent);
        this.menuPane.setVisible(this.menuPane.getComponentCount() > 0);
        this.menuPane.revalidate();
        this.menuPane.repaint();
        this.toolTipComponent = null;
    }

    public void showMenu(JComponent component, Component invoker, int x, int y) {
        Point p = SwingUtilities.convertPoint(invoker, x, y, this.menuPane);
        component.setLocation(p.x, p.y);
        this.menuPane.add(component);
        this.menuPane.revalidate();
        this.menuPane.repaint();
        this.menuPane.setVisible(true);
        this.showMenu(component);
        this.hideTooltip();
    }

    public void closeMenus() {
        int i = this.menuPane.getComponentCount() - 1;
        while (i >= 0) {
            Component c = this.menuPane.getComponent(i);
            if (c != this.toolTipComponent) {
                this.menuPane.remove(c);
            }
            --i;
        }
        this.menuPane.setVisible(this.toolTipComponent != null);
        this.menuPane.revalidate();
        this.menuPane.repaint();
    }

    public Rectangle getClassComponentPanePrintBounds() {
        Rectangle bounds = null;
        int componentCount = this.classComponentPane.getComponentCount();
        if (componentCount == 0) {
            return new Rectangle(30, 30, 400, 200);
        }
        int i = componentCount - 1;
        while (i >= 0) {
            Component classComponent = this.classComponentPane.getComponent(i);
            if (classComponent.isVisible()) {
                Rectangle cBounds = ((ClassComponent)classComponent).getBounds();
                if (bounds == null) {
                    bounds = cBounds;
                } else {
                    if (cBounds.x < bounds.x) {
                        bounds.width += bounds.x - cBounds.x;
                        bounds.x = cBounds.x;
                    }
                    bounds.width = Math.max(bounds.width, cBounds.x + cBounds.width - bounds.x);
                    if (cBounds.y < bounds.y) {
                        bounds.height += bounds.y - cBounds.y;
                        bounds.y = cBounds.y;
                    }
                    bounds.height = Math.max(bounds.height, cBounds.y + cBounds.height - bounds.y);
                }
            }
            --i;
        }
        return bounds;
    }

    public Container getClassComponentPane() {
        return this.classComponentPane;
    }

    public int getFieldVisibility() {
        return this.fieldVisibility;
    }

    public int getMethodVisibility() {
        return this.methodVisibility;
    }

    public void setFieldVisibility(int fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
        Component[] components = this.classComponentPane.getComponents();
        int i = 0;
        while (i < components.length) {
            ClassComponent classComponent = (ClassComponent)components[i];
            classComponent.updateFieldVisibility();
            ++i;
        }
    }

    public void setMethodVisibility(int methodVisibility) {
        this.methodVisibility = methodVisibility;
        Component[] components = this.classComponentPane.getComponents();
        int i = 0;
        while (i < components.length) {
            ClassComponent classComponent = (ClassComponent)components[i];
            classComponent.updateMethodVisibility();
            ++i;
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        if (this.isLocked == isLocked) {
            return;
        }
        this.isLocked = isLocked;
        this.toolBarComponent.setVisible(!isLocked);
        this.adjustBounds();
    }

    public void adjustLayout() {
        LayoutHandler.adjust(this);
    }

    public void setTitle(String title) {
        if ("".equals(title)) {
            title = null;
        }
        this.title = title;
    }

    class MouseHandler
    extends MouseInputAdapter {
        protected Point referenceLocation;
        protected boolean isControlPressed;
        protected boolean isShiftPressed;
        protected ClassComponent[] originalSelectedClassComponents;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            ClassPane.this.closeMenus();
            if (e.getButton() != 1) {
                return;
            }
            this.referenceLocation = e.getPoint();
            this.isControlPressed = (e.getModifiers() & 2) != 0;
            boolean bl = this.isShiftPressed = (e.getModifiers() & 1) != 0;
            if (!this.isControlPressed) {
                ClassPane.this.clearSelectedClassComponents();
            }
            this.originalSelectedClassComponents = ClassPane.this.selectedClassComponentSet.toArray(new ClassComponent[0]);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            ClassPane.this.selectionRectangle = null;
            this.referenceLocation = null;
            this.originalSelectedClassComponents = null;
            ClassPane.this.classComponentPane.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            int i;
            if (this.referenceLocation == null) {
                return;
            }
            Point location = e.getPoint();
            if (!this.isShiftPressed) {
                int offsetX = location.x - this.referenceLocation.x;
                int offsetY = location.y - this.referenceLocation.y;
                this.referenceLocation = location;
                ClassPane.this.moveClassComponents(offsetX, offsetY);
                return;
            }
            int x1 = Math.min(this.referenceLocation.x, location.x);
            int y1 = Math.min(this.referenceLocation.y, location.y);
            int x2 = Math.max(this.referenceLocation.x, location.x);
            int y2 = Math.max(this.referenceLocation.y, location.y);
            ClassPane.this.selectionRectangle = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            ClassPane.this.clearSelectedClassComponents();
            if (this.isControlPressed) {
                i = 0;
                while (i < this.originalSelectedClassComponents.length) {
                    ClassPane.this.addSelectedClassComponent(this.originalSelectedClassComponents[i]);
                    ++i;
                }
            }
            i = ClassPane.this.classComponentPane.getComponentCount() - 1;
            while (i >= 0) {
                ClassComponent classComponent = (ClassComponent)ClassPane.this.classComponentPane.getComponent(i);
                Rectangle cBounds = classComponent.getBounds();
                --cBounds.x;
                --cBounds.y;
                ++cBounds.width;
                ++cBounds.height;
                if (cBounds.intersects(ClassPane.this.selectionRectangle)) {
                    if (this.isControlPressed && ClassPane.this.isClassComponentSelected(classComponent)) {
                        ClassPane.this.removeSelectedClassComponent(classComponent);
                    } else {
                        ClassPane.this.addSelectedClassComponent(classComponent);
                    }
                }
                --i;
            }
        }
    }

    protected class MenuPane
    extends JPanel {
        public MenuPane() {
            super(null);
            this.setOpaque(false);
        }

        public void hide() {
            super.hide();
            int i = this.getComponentCount() - 1;
            while (i >= 0) {
                Component component = this.getComponent(i);
                this.remove(i);
                component.setVisible(false);
                --i;
            }
            if (ClassPane.this.classComponentPane != null) {
                ClassPane.this.classComponentPane.requestFocus();
            }
        }

        public boolean contains(int x, int y) {
            int i = this.getComponentCount() - 1;
            while (i >= 0) {
                Component component = this.getComponent(i);
                if (component.getBounds().contains(x, y)) {
                    return true;
                }
                --i;
            }
            return false;
        }

        public void remove(Component comp) {
            super.remove(comp);
            comp.setVisible(false);
        }

        public boolean isOptimizedDrawingEnabled() {
            return this.getComponentCount() <= 1;
        }
    }
}

