/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.PackageInfo;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import java.util.ArrayList;

public class ClassInfo {
    protected String className;
    protected ClassProcessor classProcessor;
    protected PackageInfo packageInfo;
    protected String declaration;
    protected String[] genericDeclarations;
    protected int modifiers;
    protected ClassInfo[] superTypes;
    protected ClassInfo[] subTypes;
    protected transient ClassInfo[] compositions;
    protected transient ClassInfo[] associations;
    protected FieldInfo[] enums;
    protected MethodInfo[] annotationMembers;
    protected FieldInfo[] fields;
    protected MethodInfo[] methods;
    protected MethodInfo[] constructors;
    public static final int NOT_LOADED_STATE = 0;
    public static final int LOADING_STATE = 1;
    public static final int LOADED_STATE = 2;
    public static final int LOADING_FAILED_STATE = 3;
    protected final Object LOADING_LOCK = new Object();
    protected int loadingState = 0;
    protected String prototype;

    protected ClassInfo(String className, ClassProcessor classProcessor) {
        this.className = className;
        this.classProcessor = classProcessor;
        int index = className.lastIndexOf(46);
        this.packageInfo = index == -1 ? new PackageInfo("", null) : new PackageInfo(className.substring(0, index), null);
    }

    public String getClassName() {
        return this.className;
    }

    public PackageInfo getPackage() {
        return this.packageInfo;
    }

    public String getName() {
        return Util.unescapeClassName(this.className.substring(this.className.lastIndexOf(46) + 1));
    }

    protected void setDeclaration(String declaration, String[] genericDeclarations) {
        this.declaration = declaration;
        this.genericDeclarations = genericDeclarations;
    }

    public String getDeclaration() {
        return this.declaration;
    }

    public String[] getGenericDeclarations() {
        return this.genericDeclarations;
    }

    protected void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    protected void setSuperTypes(ClassInfo[] superTypes) {
        this.superTypes = superTypes;
    }

    public ClassInfo[] getSuperTypes() {
        if (this.superTypes == null) {
            return new ClassInfo[0];
        }
        return this.superTypes;
    }

    protected void setSubTypes(ClassInfo[] subTypes) {
        this.subTypes = subTypes;
    }

    public ClassInfo[] getSubTypes() {
        if (this.subTypes == null) {
            return new ClassInfo[0];
        }
        return this.subTypes;
    }

    public ClassInfo[] getCompositions() {
        ClassInfo classInfo;
        if (this.compositions != null) {
            return this.compositions;
        }
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        ClassInfo[] classInfos = this.getClassInfos(this.getFields());
        int i = 0;
        while (i < classInfos.length) {
            classInfo = classInfos[i];
            if (!classInfo.equals(this)) {
                list.add(classInfo);
            }
            ++i;
        }
        classInfos = this.getClassInfos(this.getEnums());
        i = 0;
        while (i < classInfos.length) {
            classInfo = classInfos[i];
            if (!classInfo.equals(this)) {
                list.add(classInfo);
            }
            ++i;
        }
        this.compositions = list.toArray(new ClassInfo[0]);
        return this.compositions;
    }

    public ClassInfo[] getAssociations() {
        ClassInfo classInfo;
        int j;
        ClassInfo[] classInfos;
        MethodInfo methodInfo;
        if (this.associations != null) {
            return this.associations;
        }
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        MethodInfo[] methodInfos = this.getMethods();
        int i = 0;
        while (i < methodInfos.length) {
            methodInfo = methodInfos[i];
            classInfos = this.getClassInfos(methodInfo.getParameters());
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            classInfos = this.getClassInfos(methodInfo.getExceptionParameters());
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            classInfos = this.getClassInfos(new FieldInfo[]{methodInfo.getReturnedParameter()});
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            classInfos = methodInfo.getAnnotations();
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            ++i;
        }
        methodInfos = this.getConstructors();
        i = 0;
        while (i < methodInfos.length) {
            methodInfo = methodInfos[i];
            classInfos = this.getClassInfos(methodInfo.getParameters());
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            classInfos = this.getClassInfos(methodInfo.getExceptionParameters());
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            ++i;
        }
        methodInfos = this.getAnnotationMembers();
        i = 0;
        while (i < methodInfos.length) {
            methodInfo = methodInfos[i];
            classInfos = this.getClassInfos(new FieldInfo[]{methodInfo.getReturnedParameter()});
            j = 0;
            while (j < classInfos.length) {
                classInfo = classInfos[j];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++j;
            }
            ++i;
        }
        this.associations = list.toArray(new ClassInfo[0]);
        return this.associations;
    }

    protected ClassInfo[] getClassInfos(FieldInfo[] fieldInfos) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        int j = 0;
        while (j < fieldInfos.length) {
            FieldInfo fieldInfo = fieldInfos[j];
            ClassInfo[] classInfos = fieldInfo.getClassInfos();
            int k = 0;
            while (k < classInfos.length) {
                ClassInfo classInfo = classInfos[k];
                if (!classInfo.equals(this)) {
                    list.add(classInfo);
                }
                ++k;
            }
            ++j;
        }
        return list.toArray(new ClassInfo[0]);
    }

    protected void setEnums(FieldInfo[] enums) {
        this.enums = enums;
    }

    public FieldInfo[] getEnums() {
        if (this.enums == null) {
            return new FieldInfo[0];
        }
        return this.enums;
    }

    protected void setAnnotationMembers(MethodInfo[] annotationMembers) {
        this.annotationMembers = annotationMembers;
    }

    public MethodInfo[] getAnnotationMembers() {
        if (this.annotationMembers == null) {
            return new MethodInfo[0];
        }
        return this.annotationMembers;
    }

    protected void setFields(FieldInfo[] fields) {
        this.fields = fields;
    }

    public FieldInfo[] getFields() {
        if (this.fields == null) {
            return new FieldInfo[0];
        }
        return this.fields;
    }

    protected void setMethods(MethodInfo[] methods) {
        this.methods = methods;
    }

    public MethodInfo[] getMethods() {
        if (this.methods == null) {
            return new MethodInfo[0];
        }
        return this.methods;
    }

    protected void setConstructors(MethodInfo[] constructors) {
        this.constructors = constructors;
    }

    public MethodInfo[] getConstructors() {
        if (this.constructors == null) {
            return new MethodInfo[0];
        }
        return this.constructors;
    }

    public int getLoadingState() {
        return this.loadingState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        Object object = this.LOADING_LOCK;
        synchronized (object) {
            return this.loadingState == 2 || this.loadingState == 3;
        }
    }

    protected void setLoadingState(int loadingState) {
        this.loadingState = loadingState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(boolean isForced) {
        block13: {
            if (this.isLoaded() && !isForced) {
                return;
            }
            Object object = this.LOADING_LOCK;
            synchronized (object) {
                if (this.loadingState == 0 || this.loadingState == 3) {
                    this.loadingState = 1;
                    break block13;
                }
                while (true) {
                    if (this.loadingState != 1) {
                        return;
                    }
                    try {
                        this.LOADING_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        int index = this.className.lastIndexOf(46);
        if (index == -1) {
            index = this.className.length();
        }
        ClassInfoLoader.loadClassInfo(this, this.classProcessor);
        this.compositions = null;
        this.associations = null;
        Object object = this.LOADING_LOCK;
        synchronized (object) {
            this.loadingState = (this.getModifiers() & 0x100000) != 0 ? 3 : 2;
            this.LOADING_LOCK.notifyAll();
            return;
        }
    }

    protected int[] getClassNameIndices(String classDeclaration) {
        return ClassInfo.getClassNameIndices(classDeclaration, this.getGenericDeclarations());
    }

    protected static int[] getClassNameIndices(String classDeclaration, String[] genericDeclarations) {
        int i;
        int index = classDeclaration.indexOf(60);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (index >= 0) {
            int start;
            int count = 1;
            i = start = index + 1;
            while (count > 0 && i < classDeclaration.length()) {
                int j;
                int[] indices = null;
                switch (classDeclaration.charAt(i)) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        if (--count != 0) break;
                        indices = ClassInfo.getClassNameIndices(classDeclaration.substring(start, i), genericDeclarations);
                        j = 0;
                        while (j < indices.length) {
                            int n = j++;
                            indices[n] = indices[n] + start;
                        }
                        break;
                    }
                    case '&': {
                        if (count != 1) break;
                        indices = ClassInfo.getClassNameIndices(classDeclaration.substring(start, i - 1), genericDeclarations);
                        j = 0;
                        while (j < indices.length) {
                            int n = j++;
                            indices[n] = indices[n] + start;
                        }
                        start = ++i + 1;
                        break;
                    }
                    case ',': {
                        if (count != 1) break;
                        indices = ClassInfo.getClassNameIndices(classDeclaration.substring(start, i), genericDeclarations);
                        j = 0;
                        while (j < indices.length) {
                            int n = j++;
                            indices[n] = indices[n] + start;
                        }
                        start = i + 1;
                    }
                }
                if (indices != null) {
                    j = 0;
                    while (j < indices.length) {
                        indexList.add(new Integer(indices[j]));
                        ++j;
                    }
                    indices = null;
                }
                ++i;
            }
            classDeclaration = classDeclaration.substring(0, index);
        } else {
            index = classDeclaration.indexOf(91);
            if (index >= 0) {
                classDeclaration = classDeclaration.substring(0, index);
            }
        }
        int offset = classDeclaration.lastIndexOf(" ") + 1;
        classDeclaration = classDeclaration.substring(offset);
        if (classDeclaration.endsWith("...")) {
            classDeclaration = classDeclaration.substring(0, classDeclaration.length() - "...".length());
        }
        if (!("void".equals(classDeclaration) || "?".equals(classDeclaration) || "boolean".equals(classDeclaration) || "byte".equals(classDeclaration) || "char".equals(classDeclaration) || "short".equals(classDeclaration) || "int".equals(classDeclaration) || "long".equals(classDeclaration) || "float".equals(classDeclaration) || "double".equals(classDeclaration))) {
            boolean isGeneric = false;
            i = 0;
            while (i < genericDeclarations.length) {
                if (classDeclaration.equals(genericDeclarations[i])) {
                    isGeneric = true;
                    break;
                }
                ++i;
            }
            if (!isGeneric) {
                indexList.add(0, new Integer(offset));
                indexList.add(1, new Integer(offset + classDeclaration.length()));
            }
        }
        int[] indices = new int[indexList.size()];
        i = 0;
        while (i < indices.length) {
            indices[i] = (Integer)indexList.get(i);
            ++i;
        }
        return indices;
    }

    public ClassProcessor getClassProcessor() {
        return this.classProcessor;
    }

    protected void setPrototype(String prototype) {
        this.prototype = prototype;
    }

    public String getPrototype() {
        return this.prototype;
    }
}

