/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc;

import chrriis.udoc.model.URLConnectionEx;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.ClassProcessorRegistry;
import chrriis.udoc.model.processor.binary.BinaryClassProcessor;
import chrriis.udoc.model.processor.javadoc.JavadocClassProcessor;
import chrriis.udoc.model.processor.source.SourceClassProcessor;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.Workspace;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.InflaterInputStream;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class UDocApplet
extends JApplet {
    protected ClassPane classPane;

    static {
        ClassProcessorRegistry.register(new JavadocClassProcessor());
        ClassProcessorRegistry.register(new BinaryClassProcessor());
        ClassProcessorRegistry.register(new SourceClassProcessor());
    }

    protected String getURLString(String resource) {
        if (resource == null) {
            return null;
        }
        if (resource.indexOf(":/") == -1) {
            if (resource.startsWith("/")) {
                URL documentBase = this.getDocumentBase();
                resource = String.valueOf(documentBase.getProtocol()) + "://" + documentBase.getHost() + '/' + resource;
            } else {
                String directory = this.getDocumentBase().toExternalForm();
                resource = String.valueOf(directory.substring(0, directory.lastIndexOf(47) + 1)) + resource;
            }
        }
        return resource;
    }

    public void init() {
        this.classPane = new ClassPane();
        this.classPane.setTitle("UDoc");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.classPane, "Center");
        this.setSize(800, 600);
        contentPane.invalidate();
        this.doLayout();
        String workspace = this.getURLString(this.getParameter("workspace"));
        if (workspace != null) {
            this.classPane.setLocked(true);
            try {
                int count;
                BufferedInputStream in = new BufferedInputStream(new InflaterInputStream(URLConnectionEx.openConnection(new URL(workspace)).getInputStream()));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((count = ((InputStream)in).read(bytes)) >= 0) {
                    out.write(bytes, 0, count);
                }
                Workspace.setXMLDescription(this.classPane, new String(out.toByteArray(), "UTF-8"));
                ((InputStream)in).close();
            }
            catch (Exception ex) {
                try {
                    int count;
                    BufferedInputStream in = new BufferedInputStream(new URL(workspace).openConnection().getInputStream());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    while ((count = ((InputStream)in).read(bytes)) >= 0) {
                        out.write(bytes, 0, count);
                    }
                    Workspace.setXMLDescription(this.classPane, new String(out.toByteArray(), "UTF-8"));
                    ((InputStream)in).close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        } else {
            String processorID = this.getParameter("processorID");
            final String classNames = this.getParameter("classNames");
            Util.setPathSeparator(this.getParameter("pathSeparator"));
            final ClassProcessor classProcessor = ClassProcessorRegistry.getClassProcessor(processorID);
            if (classProcessor != null) {
                if (classProcessor instanceof JavadocClassProcessor) {
                    String documentation = this.getURLString(this.getParameter("documentationRoot"));
                    if (documentation != null) {
                        ((JavadocClassProcessor)classProcessor).setDocumentationRoot(documentation);
                    }
                } else if (classProcessor instanceof BinaryClassProcessor) {
                    String classpath = this.getURLString(this.getParameter("classPath"));
                    if (classpath != null) {
                        ((BinaryClassProcessor)classProcessor).setClassPath(classpath);
                    }
                } else if (classProcessor instanceof SourceClassProcessor) {
                    String sourcepath = this.getURLString(this.getParameter("sourcePath"));
                    String classpath = this.getURLString(this.getParameter("classPath"));
                    if (sourcepath != null && classpath != null) {
                        SourceClassProcessor sourceClassProcessor = (SourceClassProcessor)classProcessor;
                        sourceClassProcessor.setSourcePath(sourcepath);
                        sourceClassProcessor.setClassPath(classpath);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UDocApplet.this.classPane.setContent(classNames, classProcessor);
                    }
                });
            }
        }
    }

    public void requestFocus() {
        this.classPane.getClassComponentPane().requestFocus();
    }

    public void start() {
        this.transferFocus();
        this.requestFocus();
        if (this.isShowing()) {
            this.transferFocus();
            this.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UDocApplet.this.start();
                }
            });
        }
    }
}

