/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ArrowButton
extends JButton {
    private int direction;
    Color background;
    Color shadow;
    Color darkShadow;
    Color highlight;

    public ArrowButton(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.background = UIManager.getColor("ComboBox.buttonBackground");
        this.shadow = UIManager.getColor("ComboBox.buttonShadow");
        this.darkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
        this.highlight = UIManager.getColor("ComboBox.buttonHighlight");
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        switch (direction) {
            case 1: {
                int i = 0;
                while (i < size) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < size) {
                    g.drawLine(i, mid - i, i, mid + i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return new Dimension(16, 16);
        }
        return super.getPreferredSize();
    }
}

