/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.pages.DirectoryPageMaker;

public final class XML {
    private static final SimpleDateFormat OUTPUT_DATE_FORMAT = new SimpleDateFormat(Messages.getString("DATE_FORMAT"));
    private static final SimpleDateFormat OUTPUT_DATE_TIME_FORMAT = new SimpleDateFormat(Messages.getString("DATE_TIME_FORMAT"));

    public static String getLink(String link, String linkName) {
        return XML.getLink(link, linkName, "", "");
    }

    public static String getLink(String link, String linkName, String prefix, String suffix) {
        if (link == null) {
            return prefix + XML.escape(linkName) + suffix;
        }
        return "<a href=\"" + XML.escape(link) + "\">" + prefix + XML.escape(linkName) + suffix + "</a>";
    }

    public static String getAuthorLink(Author author) {
        return XML.escape(author.getName());
    }

    public static String getAuthorIdLink(Author author) {
        return XML.escape(author.getName());
    }

    public static String getDate(Date date) {
        return OUTPUT_DATE_FORMAT.format(date);
    }

    public static String getDateAndTime(Date date) {
        return OUTPUT_DATE_TIME_FORMAT.format(date);
    }

    public static String getDirectoryLink(Directory directory) {
        String caption = directory.isRoot() ? "/" : directory.getPath();
        return XML.escape(DirectoryPageMaker.getURL(directory)) + XML.escape(caption);
    }

    public static String getIcon(String iconFilename) {
        StringBuffer result = new StringBuffer("<img src=\"");
        result.append(XML.escape(iconFilename)).append("\" width=\"");
        result.append(15).append("\" height=\"");
        result.append(13).append("\" alt=\"\"/>");
        return result.toString();
    }

    public static String escapeAuthorName(String authorName) {
        return authorName.replaceAll("#", "_").replaceAll("\\\\", "_");
    }

    public static String escapeDirectoryName(String directoryName) {
        if (!directoryName.startsWith("/")) {
            directoryName = "/" + directoryName;
        }
        return directoryName.substring(0, directoryName.length() - 1).replaceAll("/", "_");
    }

    public static String escape(String text) {
        String result = text;
        return result;
    }

    private XML() {
    }
}

