/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.text.NumberFormat;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.reports.TopDevelopersTableReport;
import net.sf.statcvs.util.StringUtils;

public final class TwitterHelp {
    private TwitterHelp() {
    }

    public static String buildOverviewLink(TopDevelopersTableReport topDevelopers, Repository repository, ReportConfig config) {
        StringBuffer buf = new StringBuffer();
        TwitterHelp.startLink(buf);
        StringBuffer url = new StringBuffer();
        buf.append("http://twitter.com/home?status=Project");
        url.append(" ");
        url.append(config.getProjectName());
        url.append(" on ");
        url.append(HTML.OUTPUT_DATE_FORMAT.format(repository.getLastDate()));
        url.append(" has ");
        url.append(NumberFormat.getNumberInstance().format(repository.getCurrentLOC()));
        url.append(" Lines of Code and ");
        url.append(topDevelopers.getDeveloperCount());
        url.append(" Developers: stats by ");
        url.append(Messages.getString("PROJECT_SHORTNAME"));
        url.append(" ").append(Messages.getString("PROJECT_SMALL_URL"));
        buf.append(HTML.escapeUrl(url.toString()));
        TwitterHelp.endLinkAndIcon(buf, "tweet-this.png");
        return buf.toString();
    }

    private static void endLinkAndIcon(StringBuffer buf, String iconName) {
        buf.append("\"><img style=\"border:0px\" alt=\"Tweet this\" src=\"").append(iconName).append("\"/></a>");
    }

    private static void startLink(StringBuffer buf) {
        buf.append("<a href=\"");
    }

    public static String buildDeveloperLink(Author developer, String loc, Repository repository, ReportConfig config) {
        StringBuffer buf = new StringBuffer();
        TwitterHelp.startLink(buf);
        buf.append("http://twitter.com/home?status=");
        StringBuffer url = new StringBuffer();
        if (StringUtils.isNotEmpty(developer.getTwitterUserName())) {
            url.append("@").append(developer.getTwitterUserName());
        } else if (StringUtils.isNotEmpty(developer.getRealName())) {
            url.append(developer.getRealName());
        } else {
            url.append(developer.getName());
        }
        url.append(" contributed ");
        url.append(loc);
        url.append(" lines to ");
        url.append(config.getProjectName());
        url.append(" most recent commit ");
        url.append(HTML.OUTPUT_DATE_FORMAT.format(((Revision)developer.getRevisions().last()).getDate()));
        url.append(" stats by ");
        url.append(Messages.getString("PROJECT_SHORTNAME"));
        url.append(" ").append(Messages.getString("PROJECT_SMALL_URL"));
        System.out.println("Raw:" + url.toString());
        String escapeUrl = HTML.escapeUrl(url.toString());
        System.out.println("url:" + escapeUrl);
        buf.append(escapeUrl);
        TwitterHelp.endLinkAndIcon(buf, "tweet-this.png");
        return buf.toString();
    }

    public static String buildDeveloperOfMonthLink(Author developer, int loc, Repository repository, String month_year, ReportConfig config) {
        StringBuffer buf = new StringBuffer();
        TwitterHelp.startLink(buf);
        StringBuffer url = new StringBuffer();
        buf.append("http://twitter.com/home?status=");
        if (StringUtils.isNotEmpty(developer.getTwitterUserName())) {
            url.append("@").append(developer.getTwitterUserName());
        } else if (StringUtils.isNotEmpty(developer.getRealName())) {
            url.append(developer.getRealName());
        } else {
            url.append(developer.getName());
        }
        url.append(" is Developer of The Month for ");
        url.append(month_year);
        url.append(" for ");
        url.append(config.getProjectName());
        url.append(" with ");
        url.append(NumberFormat.getNumberInstance().format(loc));
        url.append(" lines. Stats by ");
        url.append(Messages.getString("PROJECT_SHORTNAME"));
        url.append(" ").append(Messages.getString("PROJECT_SMALL_URL"));
        buf.append(HTML.escapeUrl(url.toString()));
        TwitterHelp.endLinkAndIcon(buf, "tt-twitter-micro3.png");
        return buf.toString();
    }
}

