/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.LogPageMaker;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.PageGroup;

public class LogPageGroupMaker {
    private final ReportConfig config;
    private final Repository repository;

    public LogPageGroupMaker(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public PageGroup getPages() {
        PageGroup pages = new PageGroup("Commit Logs");
        if (this.repository.getCommits().isEmpty()) {
            return pages;
        }
        Date start = this.repository.getFirstDate();
        Date end = this.repository.getLastDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(end);
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(start);
        ArrayList<NavigationNode> results = new ArrayList<NavigationNode>();
        while (true) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            NavigationNode page = new LogPageMaker(this.config, year, month, this.repository.getCommits()).toFile();
            results.add(page);
            if (calendar.get(1) == startCal.get(1) && calendar.get(2) == startCal.get(2)) break;
            ((Calendar)calendar).add(2, -1);
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            pages.add((NavigationNode)it.next());
        }
        pages.setShowLinkToPreviousSibling(true);
        return pages;
    }
}

