/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.pages.DirectoryPageMaker;
import net.sf.statcvs.pages.HTML;

public class DirectoryTreeFormatter {
    private static final int SPACE_COUNT = 4;
    private final Directory directory;
    private final boolean withRootLinks;

    public DirectoryTreeFormatter(Directory directory, boolean withRootLinks) {
        this.directory = directory;
        this.withRootLinks = withRootLinks;
    }

    private String getRootLinks(Directory dir) {
        String result = this.getFormattedName(dir, false, true);
        while (!dir.isRoot()) {
            Directory parent = dir.getParent();
            result = this.getFormattedName(parent, true, false) + "/" + result;
            dir = parent;
        }
        return result;
    }

    public String getFormatted() {
        StringBuffer result = new StringBuffer("<p class=\"dirtree\">\n");
        Iterator it = this.directory.getSubdirectoriesRecursive().iterator();
        if (this.withRootLinks) {
            Directory current = (Directory)it.next();
            result.append(this.getRootLinks(current)).append("<br/>\n");
        }
        while (it.hasNext()) {
            Directory subdirectory = (Directory)it.next();
            this.format(subdirectory, 0, result);
        }
        result.append("</p>\n");
        return result.toString();
    }

    private void format(Directory dir, int currentDepth, StringBuffer s) {
        s.append(this.getSpaces(dir.getDepth() - currentDepth));
        if (dir.isEmpty()) {
            s.append(HTML.getIcon("folder-deleted.png", Messages.getString("DELETED_DIRECTORY_ICON")));
        } else {
            s.append(HTML.getIcon("folder.png", Messages.getString("DIRECTORY_ICON")));
        }
        s.append(" \n").append(this.getFormattedName(dir, true, false));
        s.append(" \n(").append(dir.getCurrentFileCount()).append(" ");
        s.append(Messages.getString("DIRECTORY_TREE_FILES")).append(", ");
        s.append(dir.getCurrentLOC()).append(" ");
        s.append(Messages.getString("DIRECTORY_TREE_LINES")).append(")<br />\n");
    }

    private String getFormattedName(Directory directory, boolean link, boolean bold) {
        String name;
        String string = name = directory.isRoot() ? Messages.getString("NAVIGATION_ROOT") : directory.getName();
        if (link) {
            String url = DirectoryPageMaker.getURL(directory);
            name = HTML.getLink(url, name);
        } else {
            name = HTML.escape(name);
        }
        if (bold) {
            return "<strong>" + name + "</strong>";
        }
        return name;
    }

    private String getSpaces(int count) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < count * 4; ++i) {
            result.append("&#160;");
        }
        return result.toString();
    }
}

