/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.DirectoryImpl;
import net.sf.statcvs.model.DirectoryRoot;
import net.sf.statcvs.model.VersionedFile;

public abstract class Directory
implements Comparable {
    private final SortedSet files = new TreeSet();
    private final SortedSet directories = new TreeSet();

    public static Directory createRoot() {
        return new DirectoryRoot();
    }

    public Directory createSubdirectory(String name) {
        DirectoryImpl result = new DirectoryImpl(this, name);
        this.directories.add(result);
        return result;
    }

    public abstract String getName();

    public abstract String getPath();

    public abstract Directory getParent();

    public abstract boolean isRoot();

    public abstract int getDepth();

    public SortedSet getFiles() {
        return this.files;
    }

    public SortedSet getRevisions() {
        TreeSet result = new TreeSet();
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            VersionedFile file = (VersionedFile)iterator.next();
            result.addAll(file.getRevisions());
        }
        return result;
    }

    public SortedSet getSubdirectories() {
        return this.directories;
    }

    public SortedSet getSubdirectoriesRecursive() {
        TreeSet<Directory> result = new TreeSet<Directory>();
        result.add(this);
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            result.addAll(dir.getSubdirectoriesRecursive());
        }
        return result;
    }

    public int getCurrentLOC() {
        int result = 0;
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            result += file.getCurrentLinesOfCode();
        }
        return result;
    }

    public int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    public boolean isEmpty() {
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            return false;
        }
        it = this.directories.iterator();
        while (it.hasNext()) {
            Directory subdir = (Directory)it.next();
            if (subdir.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        return this.getPath().compareTo(((Directory)o).getPath());
    }

    void addFile(VersionedFile file) {
        this.files.add(file);
    }
}

