/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.statcvs.input.CommitListBuilder;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.FileBuilder;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.FileUtils;
import net.sf.statcvs.util.StringUtils;

public class Builder
implements CvsLogBuilder {
    private static Logger logger = Logger.getLogger(Builder.class.getName());
    private final RepositoryFileManager repositoryFileManager;
    private final FilePatternMatcher includePattern;
    private final FilePatternMatcher excludePattern;
    private final Pattern tagsPattern;
    private final Map authors = new HashMap();
    private final Map directories = new HashMap();
    private final Map symbolicNames = new HashMap();
    private final List fileBuilders = new ArrayList();
    private final Set atticFileNames = new HashSet();
    private FileBuilder currentFileBuilder = null;
    private Date startDate = null;
    private String projectName = null;
    private int countRejectedByExclude = 0;
    private int countAcceptedByExclude = 0;
    private int countRejectedByInclude = 0;
    private int countAcceptedByInclude = 0;
    private boolean flagOutOfSync = false;
    private boolean flagHasLocalCVSMetadata = false;
    private int countFoundLocalFiles = 0;
    private int countNotFoundLocalFiles = 0;

    public Builder(RepositoryFileManager repositoryFileManager, FilePatternMatcher includePattern, FilePatternMatcher excludePattern, Pattern tagsPattern) {
        this.repositoryFileManager = repositoryFileManager;
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
        this.tagsPattern = tagsPattern;
        this.directories.put("", Directory.createRoot());
    }

    public void buildModule(String moduleName) {
        this.projectName = moduleName;
    }

    public void buildFile(String filename, boolean isBinary, boolean isInAttic, Map revBySymnames) {
        if (this.currentFileBuilder != null) {
            this.fileBuilders.add(this.currentFileBuilder);
        }
        this.currentFileBuilder = new FileBuilder(this, filename, isBinary, revBySymnames);
        if (isInAttic) {
            this.atticFileNames.add(filename);
        }
    }

    public void buildRevision(RevisionData data) {
        this.currentFileBuilder.addRevisionData(data);
        if (this.startDate == null || this.startDate.compareTo(data.getDate()) > 0) {
            this.startDate = data.getDate();
        }
    }

    public Repository createCvsContent() {
        if (this.currentFileBuilder != null) {
            this.fileBuilders.add(this.currentFileBuilder);
            this.currentFileBuilder = null;
        }
        Repository result = new Repository();
        Iterator it = this.fileBuilders.iterator();
        while (it.hasNext()) {
            FileBuilder fileBuilder = (FileBuilder)it.next();
            VersionedFile file = fileBuilder.createFile(this.startDate);
            if (file == null) continue;
            if (fileBuilder.hasUnexpectedLocalRevision()) {
                this.flagOutOfSync = true;
            }
            if (fileBuilder.hasLocalCVSMetadata()) {
                this.flagHasLocalCVSMetadata = true;
            }
            if (fileBuilder.hasLocalFileNotFound()) {
                ++this.countNotFoundLocalFiles;
                this.flagOutOfSync = true;
            } else if (file.getCurrentLinesOfCode() > 0) {
                ++this.countFoundLocalFiles;
            }
            result.addFile(file);
            logger.finer("adding " + file.getFilenameWithPath() + " (" + file.getRevisions().size() + " revisions)");
        }
        SortedSet revisions = result.getRevisions();
        List commits = new CommitListBuilder(revisions).createCommitList();
        result.setCommits(commits);
        result.setSymbolicNames(this.getMatchingSymbolicNames());
        return result;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Set getAtticFileNames() {
        return this.atticFileNames;
    }

    public boolean allRejectedByExcludePattern() {
        return this.countRejectedByExclude > 0 && this.countAcceptedByExclude == 0;
    }

    public boolean allRejectedByIncludePattern() {
        return this.countRejectedByInclude > 0 && this.countAcceptedByInclude == 0;
    }

    public boolean isLogAndLocalFilesOutOfSync() {
        return this.flagHasLocalCVSMetadata && this.flagOutOfSync;
    }

    public boolean isLocalFilesNotFound() {
        return this.countNotFoundLocalFiles > this.countFoundLocalFiles;
    }

    public boolean hasLocalCVSMetadata() {
        return this.flagHasLocalCVSMetadata;
    }

    public Author getAuthor(String name) {
        String nameForConfig = name.toLowerCase(Locale.getDefault());
        if (this.authors.containsKey(nameForConfig)) {
            return (Author)this.authors.get(nameForConfig);
        }
        Properties p = ConfigurationOptions.getConfigProperties();
        Author newAuthor = new Author(name);
        if (p != null) {
            String replacementUser = p.getProperty("user." + nameForConfig + ".replacedBy");
            if (StringUtils.isNotEmpty(replacementUser)) {
                if (this.authors.containsKey(replacementUser = replacementUser.toLowerCase())) {
                    return (Author)this.authors.get(replacementUser);
                }
                nameForConfig = replacementUser;
                newAuthor = new Author(nameForConfig);
            }
            newAuthor.setRealName(p.getProperty("user." + nameForConfig + ".realName"));
            newAuthor.setHomePageUrl(p.getProperty("user." + nameForConfig + ".url"));
            newAuthor.setImageUrl(p.getProperty("user." + nameForConfig + ".image"));
            newAuthor.setEmail(p.getProperty("user." + nameForConfig + ".email"));
            newAuthor.setTwitterUserName(p.getProperty("user." + nameForConfig + ".twitterUsername"));
            newAuthor.setTwitterUserId(p.getProperty("user." + nameForConfig + ".twitterUserId"));
            String val = p.getProperty("user." + nameForConfig + ".twitterIncludeFlash");
            if (StringUtils.isNotEmpty(val)) {
                newAuthor.setTwitterIncludeFlash(Boolean.valueOf(val));
            }
            if (StringUtils.isNotEmpty(val = p.getProperty("user." + nameForConfig + ".twitterIncludeHtml"))) {
                newAuthor.setTwitterIncludeHtml(Boolean.valueOf(val));
            }
        }
        this.authors.put(nameForConfig, newAuthor);
        return newAuthor;
    }

    public Directory getDirectory(String filename) {
        int lastSlash = filename.lastIndexOf(47);
        if (lastSlash == -1) {
            return this.getDirectoryForPath("");
        }
        return this.getDirectoryForPath(filename.substring(0, lastSlash + 1));
    }

    public SymbolicName getSymbolicName(String name) {
        SymbolicName sym = (SymbolicName)this.symbolicNames.get(name);
        if (sym != null) {
            return sym;
        }
        sym = new SymbolicName(name);
        this.symbolicNames.put(name, sym);
        return sym;
    }

    public int getLOC(String filename) throws NoLineCountException {
        if (this.repositoryFileManager == null) {
            throw new NoLineCountException("no RepositoryFileManager");
        }
        return this.repositoryFileManager.getLinesOfCode(filename);
    }

    public String getRevision(String filename) throws IOException {
        if (this.repositoryFileManager == null) {
            throw new IOException("no RepositoryFileManager");
        }
        return this.repositoryFileManager.getRevision(filename);
    }

    public boolean matchesPatterns(String filename) {
        if (this.excludePattern != null) {
            if (this.excludePattern.matches(filename)) {
                ++this.countRejectedByExclude;
                return false;
            }
            ++this.countAcceptedByExclude;
        }
        if (this.includePattern != null) {
            if (this.includePattern.matches(filename)) {
                ++this.countAcceptedByInclude;
            } else {
                ++this.countRejectedByInclude;
                return false;
            }
        }
        return true;
    }

    private Directory getDirectoryForPath(String path) {
        if (this.directories.containsKey(path)) {
            return (Directory)this.directories.get(path);
        }
        Directory parent = this.getDirectoryForPath(FileUtils.getParentDirectoryPath(path));
        Directory newDirectory = parent.createSubdirectory(FileUtils.getDirectoryName(path));
        this.directories.put(path, newDirectory);
        return newDirectory;
    }

    private SortedSet getMatchingSymbolicNames() {
        TreeSet<SymbolicName> result = new TreeSet<SymbolicName>();
        if (this.tagsPattern == null) {
            return result;
        }
        Iterator it = this.symbolicNames.values().iterator();
        while (it.hasNext()) {
            SymbolicName sn = (SymbolicName)it.next();
            if (sn.getDate() == null || !this.tagsPattern.matcher(sn.getName()).matches()) continue;
            result.add(sn);
        }
        return result;
    }
}

