/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartConfigUtil;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.SymbolicNameAnnotation;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.TimeLine;
import net.sf.statcvs.reportmodel.TimePoint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeLineChartMaker {
    private final ReportConfig config;
    private final TimeLine timeLine;
    private final String fileName;
    private final List annotations;
    private final String chartName;

    public TimeLineChartMaker(String chartName, ReportConfig config, TimeLine timeLine, String fileName, Collection symbolicNames) {
        this.chartName = chartName;
        this.config = config;
        this.timeLine = timeLine;
        this.fileName = fileName;
        this.annotations = SymbolicNameAnnotation.createAnnotations(symbolicNames);
    }

    public ChartImage toFile() {
        if (this.timeLine.isEmpty()) {
            return null;
        }
        TimeSeriesCollection collection = new TimeSeriesCollection();
        collection.addSeries(this.createTimeSeries(this.timeLine));
        String range = this.timeLine.getRangeLabel();
        String domain = Messages.getString("DOMAIN_TIME");
        TimeSeriesCollection data = collection;
        JFreeChart chart = ChartFactory.createTimeSeriesChart(this.config.getProjectName() + ": " + this.timeLine.getTitle(), domain, range, data, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.getRenderer().setSeriesPaint(0, Color.blue);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setVerticalTickLabels(true);
        plot.getRangeAxis().setLowerBound(0.0);
        plot.setRenderer(new XYStepRenderer());
        Iterator it = this.annotations.iterator();
        while (it.hasNext()) {
            plot.addAnnotation((XYAnnotation)it.next());
        }
        plot.setBackgroundPaint(ChartConfigUtil.getPlotColor(this.chartName));
        chart.setBackgroundPaint(ChartConfigUtil.getBackgroundColor(this.chartName));
        XYItemRenderer renderer = plot.getRenderer();
        ChartConfigUtil.configureStroke(this.chartName, renderer, data);
        ChartConfigUtil.configureShapes(this.chartName, renderer);
        ChartConfigUtil.configureCopyrightNotice(this.chartName, chart);
        ChartConfigUtil.configureChartBackgroungImage(this.chartName, chart);
        ChartConfigUtil.configurePlotImage(this.chartName, chart);
        Dimension dim = ChartConfigUtil.getDimension(this.chartName, this.config.getLargeChartSize());
        return this.config.createChartImage(this.fileName, this.timeLine.getTitle(), chart, dim);
    }

    private TimeSeries createTimeSeries(TimeLine timeLine) {
        TimeSeries result = new TimeSeries((Comparable)((Object)"!??!SERIES_LABEL!??!"), Millisecond.class);
        Iterator it = timeLine.getDataPoints().iterator();
        while (it.hasNext()) {
            TimePoint timePoint = (TimePoint)it.next();
            result.add((RegularTimePeriod)new Millisecond(timePoint.getDate()), timePoint.getValue());
        }
        return result;
    }
}

