/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartConfigUtil;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class ModifyAddChartMaker {
    private static final String CHART_NAME = "activity";
    private static final int MODIFYING = 0;
    private static final int ADDING = 1;
    private final ReportConfig config;
    private final Repository repository;
    private final int width;
    private double[][] categories;
    private final ArrayList categoryNames = new ArrayList();

    public ModifyAddChartMaker(ReportConfig config, int width) {
        this.config = config;
        this.repository = config.getRepository();
        this.width = width;
    }

    public ChartImage toFile() {
        SortedSet authors = this.repository.getAuthors();
        Iterator it = authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            if (!this.config.isDeveloper(author)) continue;
            this.categoryNames.add(author.getRealName());
        }
        Collections.sort(this.categoryNames);
        this.categories = new double[2][this.categoryNames.size()];
        for (int j = 0; j < this.categoryNames.size(); ++j) {
            this.categories[0][j] = 0.0;
            this.categories[1][j] = 0.0;
        }
        Iterator commitIt = this.repository.getCommits().iterator();
        while (commitIt.hasNext()) {
            int author;
            Commit commit = (Commit)commitIt.next();
            Set commitRevList = commit.getRevisions();
            Iterator commitRevIt = commitRevList.iterator();
            String authorName = commit.getAuthor().getRealName();
            if (authorName == null || (author = this.categoryNames.indexOf(authorName)) == -1) continue;
            int linesAdded = 0;
            int linesRemoved = 0;
            while (commitRevIt.hasNext()) {
                Revision revision = (Revision)commitRevIt.next();
                if (revision.getLinesDelta() > 0) {
                    linesAdded += revision.getLinesDelta() + revision.getReplacedLines();
                    linesRemoved += revision.getReplacedLines();
                    continue;
                }
                linesAdded += revision.getReplacedLines();
                linesRemoved += -revision.getLinesDelta() + revision.getReplacedLines();
            }
            if (linesAdded == linesRemoved) {
                double[] dArray = this.categories[0];
                int n = author;
                dArray[n] = dArray[n] + (double)linesAdded;
            }
            if (linesAdded < linesRemoved) {
                double[] dArray = this.categories[0];
                int n = author;
                dArray[n] = dArray[n] + (double)linesRemoved;
            }
            if (linesAdded <= linesRemoved) continue;
            double[] dArray = this.categories[1];
            int n = author;
            dArray[n] = dArray[n] + (double)(linesAdded - linesRemoved);
            double[] dArray2 = this.categories[0];
            int n2 = author;
            dArray2[n2] = dArray2[n2] + (double)linesRemoved;
        }
        for (int i = 0; i < this.categoryNames.size(); ++i) {
            double maxLines = this.categories[0][i] + this.categories[1][i];
            for (int k = 0; k < 2; ++k) {
                double[] dArray = this.categories[k];
                int n = i;
                dArray[n] = dArray[n] * (100.0 / maxLines);
            }
        }
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        for (int i = 0; i < this.categories[0].length; ++i) {
            data.addValue(this.categories[0][i], (Comparable)((Object)"modifying"), (Comparable)this.categoryNames.get(i));
        }
        for (int j = 0; j < this.categories[1].length; ++j) {
            data.addValue(this.categories[1][j], (Comparable)((Object)"adding"), (Comparable)this.categoryNames.get(j));
        }
        JFreeChart chart = ChartFactory.createStackedBarChart(this.config.getProjectName() + ": " + Messages.getString("AUTHOR_ACTIVITY_TITLE"), "", "%", data, PlotOrientation.HORIZONTAL, true, false, false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, Color.yellow);
        renderer.setSeriesPaint(1, Color.green);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickUnit(new NumberTickUnit(20.0, new DecimalFormat("0")));
        rangeAxis.setUpperBound(100.0);
        chart.getLegend().setPosition(RectangleEdge.TOP);
        plot.setBackgroundPaint(ChartConfigUtil.getPlotColor(CHART_NAME));
        chart.setBackgroundPaint(ChartConfigUtil.getBackgroundColor(CHART_NAME));
        ChartConfigUtil.configureCopyrightNotice(CHART_NAME, chart);
        ChartConfigUtil.configureChartBackgroungImage(CHART_NAME, chart);
        ChartConfigUtil.configurePlotImage(CHART_NAME, chart);
        Dimension dim = ChartConfigUtil.getDimension(CHART_NAME, new Dimension(this.config.getSmallChartSize().width, 19));
        int totalHeight = dim.height * this.categoryNames.size() + 110;
        return this.config.createChartImage("activity.png", Messages.getString("AUTHOR_ACTIVITY_TITLE"), chart, new Dimension(dim.width, totalHeight));
    }
}

