/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.YIntervalDataItem;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.util.ObjectUtilities;

public class YIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Serializable {
    private List data = new ArrayList();

    public void addSeries(YIntervalSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public YIntervalSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (YIntervalSeries)this.data.get(series);
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getX(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        YIntervalDataItem di = (YIntervalDataItem)s.getDataItem(item);
        return di.getX();
    }

    public Number getY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        YIntervalDataItem di = (YIntervalDataItem)s.getDataItem(item);
        return new Double(di.getYValue());
    }

    public Number getStartX(int series, int item) {
        return this.getX(series, item);
    }

    public Number getEndX(int series, int item) {
        return this.getX(series, item);
    }

    public Number getStartY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        YIntervalDataItem di = (YIntervalDataItem)s.getDataItem(item);
        return new Double(di.getYLowValue());
    }

    public Number getEndY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        YIntervalDataItem di = (YIntervalDataItem)s.getDataItem(item);
        return new Double(di.getYHighValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof YIntervalSeriesCollection)) {
            return false;
        }
        YIntervalSeriesCollection that = (YIntervalSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }
}

