/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;

public class LookaheadReader {
    private final BufferedReader reader;
    private String currentLine = null;
    private String nextLine = null;
    private boolean afterEnd = false;
    private int lineNumber = 0;

    public LookaheadReader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public String getCurrentLine() {
        if (this.currentLine == null) {
            throw new NoSuchElementException("Call to getCurrentLine() before nextLine() was called");
        }
        return this.currentLine;
    }

    public String nextLine() throws IOException {
        if (!this.hasNextLine()) {
            throw new NoSuchElementException("Call to nextLine() when hasNextLine() is false");
        }
        this.currentLine = this.nextLine;
        this.nextLine = null;
        ++this.lineNumber;
        return this.currentLine;
    }

    public boolean hasNextLine() throws IOException {
        if (this.afterEnd) {
            return false;
        }
        if (this.nextLine != null) {
            return true;
        }
        this.nextLine = this.reader.readLine();
        if (this.nextLine != null) {
            return true;
        }
        this.afterEnd = true;
        return false;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

