/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IntegerMap {
    private final Map map = new TreeMap();
    private final Comparator comparator = new SortByValueComparator(this.map);
    private int sum = 0;
    private int max = 0;

    public void put(Object key, int value) {
        this.max = Math.max(this.max, value);
        this.sum -= this.get(key);
        this.sum += value;
        this.map.put(key, new Integer(value));
    }

    public int get(Object key) {
        Integer result = (Integer)this.map.get(key);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public Integer getInteger(Object key) {
        return (Integer)this.map.get(key);
    }

    public double getPercent(Object key) {
        return (double)this.get(key) * 100.0 / (double)this.sum;
    }

    public double getPercentOfMaximum(Object key) {
        return this.get(key) * 100 / this.max;
    }

    public void addInt(Object key, int addValue) {
        this.put(key, addValue + this.get(key));
    }

    public void inc(Object key) {
        this.addInt(key, 1);
    }

    public void dec(Object key) {
        this.addInt(key, -1);
    }

    public void remove(Object key) {
        this.sum -= this.get(key);
        this.map.remove(key);
    }

    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Iterator iteratorSortedByKey() {
        return this.map.keySet().iterator();
    }

    public Iterator iteratorSortedByValue() {
        ArrayList keys = new ArrayList(this.map.keySet());
        Collections.sort(keys, this.comparator);
        return keys.iterator();
    }

    public Iterator iteratorSortedByValueReverse() {
        ArrayList keys = new ArrayList(this.map.keySet());
        Collections.sort(keys, this.comparator);
        Collections.reverse(keys);
        return keys.iterator();
    }

    public int sum() {
        return this.sum;
    }

    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    public int max() {
        return this.max;
    }

    private static class SortByValueComparator
    implements Comparator {
        private final Map mapToBeSorted;

        public SortByValueComparator(Map map) {
            this.mapToBeSorted = map;
        }

        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = (Integer)this.mapToBeSorted.get(o1);
            if (i1 < (i2 = ((Integer)this.mapToBeSorted.get(o2)).intValue())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    }
}

