/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.reportmodel.TimeLine;

public class AvgFileSizeTimeLineReport {
    private final TimeLine timeLine = new TimeLine(Messages.getString("AVERAGE_FILE_SIZE_TITLE"), Messages.getString("RANGE_LOC_PER_FILE"));

    public AvgFileSizeTimeLineReport(SortedSet files) {
        ArrayList revisions = new ArrayList();
        Iterator filesIt = files.iterator();
        while (filesIt.hasNext()) {
            VersionedFile file = (VersionedFile)filesIt.next();
            revisions.addAll(file.getRevisions());
        }
        Collections.sort(revisions);
        Iterator it = revisions.iterator();
        int loc = 0;
        int fileCount = 0;
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            int ratio = (fileCount += rev.getFileCountDelta()) == 0 ? 0 : (loc += rev.getLinesDelta()) / fileCount;
            this.timeLine.addTimePoint(rev.getDate(), ratio);
        }
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }
}

