/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.util.Iterator;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.renderer.HTMLTableCellRenderer;
import net.sf.statcvs.reportmodel.Column;
import net.sf.statcvs.reportmodel.Table;

public class TableRenderer {
    private final Table table;
    private final HTMLTableCellRenderer renderer = new HTMLTableCellRenderer();

    public TableRenderer(Table table, MarkupSyntax output) {
        this.table = table;
        this.renderer.setOutput(output);
    }

    public String getRenderedTable() {
        StringBuffer result = new StringBuffer("  <table ").append(this.renderer.getOutput().getTableFormat());
        result.append(" rules=\"groups\" summary=\"").append(HTML.escape(this.table.getSummary()));
        result.append("\">\n");
        result.append(this.getColumnDescriptions());
        result.append(this.getTableHead());
        if (this.table.showTotals()) {
            result.append(this.getTableTotals());
        }
        result.append(this.getTableBody());
        result.append("  </table>\n\n");
        return result.toString();
    }

    private String getColumnDescriptions() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            it.next();
            if (this.table.hasKeysInFirstColumn() && isFirstColumn) {
                result.append("    <colgroup align=\"left\"/>\n");
                isFirstColumn = false;
                continue;
            }
            result.append("    <colgroup align=\"right\"/>\n");
        }
        return result.toString();
    }

    private String getTableHead() {
        StringBuffer result = new StringBuffer("    <thead>\n      <tr>\n");
        Iterator it = this.table.getColumnIterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderHead(this.renderer);
            result.append("        ").append(this.renderer.getColumnHead()).append("\n");
        }
        result.append("      </tr>\n    </thead>\n");
        return result.toString();
    }

    private String getTableTotals() {
        StringBuffer result = new StringBuffer("    <tfoot>\n      <tr>\n");
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderTotal(this.renderer);
            if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                result.append("        ").append(this.renderer.getRowHead()).append("\n");
                isFirstColumn = false;
                continue;
            }
            result.append("        ").append(this.renderer.getTableCell()).append("\n");
        }
        result.append("      </tr>\n    </tfoot>\n");
        return result.toString();
    }

    private String getTableBody() {
        StringBuffer result = new StringBuffer("    <tbody>\n");
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            result.append(this.getTableRow(i));
        }
        result.append("    </tbody>\n");
        return result.toString();
    }

    private String getTableRow(int rowIndex) {
        StringBuffer result = new StringBuffer();
        if (rowIndex % 2 == 0) {
            result.append("      <tr ").append(this.renderer.getEvenRowFormat()).append(">\n");
        } else {
            result.append("      <tr ").append(this.renderer.getOddRowFormat()).append(">\n");
        }
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderCell(rowIndex, this.renderer);
            if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                result.append("        ").append(this.renderer.getRowHead()).append("\n");
                isFirstColumn = false;
                continue;
            }
            result.append("        ").append(this.renderer.getTableCell()).append("\n");
        }
        result.append("      </tr>\n");
        return result.toString();
    }
}

