/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.renderer.TableCellRenderer;

public class HTMLTableCellRenderer
implements TableCellRenderer {
    private String html = null;
    private MarkupSyntax output = null;

    public void renderCell(String content) {
        this.html = content;
    }

    public void renderEmptyCell() {
        this.html = null;
    }

    public void renderIntegerCell(int value) {
        this.html = Integer.toString(value);
    }

    public void renderIntegerCell(int value, int total) {
        this.html = Integer.toString(value) + " (" + this.getPercentage((double)value / (double)total) + ")";
    }

    public void renderPercentageCell(double ratio) {
        this.html = this.getPercentage(ratio);
    }

    public void renderAuthorCell(Author author) {
        this.html = HTML.getAuthorLink(author);
    }

    public void renderAuthorIdCell(Author author) {
        this.html = HTML.getAuthorIdLink(author);
    }

    public void renderDirectoryCell(Directory directory) {
        this.html = HTML.getDirectoryLink(directory);
    }

    public void renderFileCell(VersionedFile file, boolean withIcon, WebRepositoryIntegration webRepository) {
        this.html = webRepository == null ? file.getFilenameWithPath() : HTML.getLink(webRepository.getFileViewUrl(file), file.getFilenameWithPath());
        if (withIcon) {
            this.html = file.isDead() ? HTML.getIcon("file-deleted.png", Messages.getString("DELETED_FILE_ICON")) + " " + this.html : HTML.getIcon("file.png", Messages.getString("FILE_ICON")) + " " + this.html;
        }
    }

    public void renderLinkCell(String url, String label) {
        this.html = HTML.getLink(url, label);
    }

    public String getColumnHead() {
        return this.getHtml("th");
    }

    public String getRowHead() {
        return this.getHtml("th");
    }

    public String getTableCell() {
        return this.getHtml("td");
    }

    private String getPercentage(double ratio) {
        if (Double.isNaN(ratio)) {
            return "-";
        }
        int percentTimes10 = (int)Math.round(ratio * 1000.0);
        double percent = (double)percentTimes10 / 10.0;
        return Double.toString(percent) + "%";
    }

    private String getHtml(String tag) {
        if (this.html == null) {
            return "<" + tag + "></" + tag + ">";
        }
        return "<" + tag + ">" + this.html + "</" + tag + ">";
    }

    public MarkupSyntax getOutput() {
        return this.output;
    }

    public void setOutput(MarkupSyntax output) {
        this.output = output;
    }

    public String getOddRowFormat() {
        return " class=\"even\"";
    }

    public String getEvenRowFormat() {
        return " class=\"odd\"";
    }
}

