/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Main;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ChurnPageMaker;
import net.sf.statcvs.output.RepoMapPageMaker;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.AllDevelopersPageMaker;
import net.sf.statcvs.pages.DirectoryPageMaker;
import net.sf.statcvs.pages.DirectorySizesPageMaker;
import net.sf.statcvs.pages.FileSizesPageMaker;
import net.sf.statcvs.pages.IndexPageMaker;
import net.sf.statcvs.pages.LOCPageMaker;
import net.sf.statcvs.pages.LogPageGroupMaker;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.PageGroup;
import net.sf.statcvs.pages.xml.GenerateXml;

public class ReportSuiteMaker {
    public static final String WEB_FILE_PATH = "web-files/";
    public static final String DIRECTORY_ICON = "folder.png";
    public static final String BUG_ICON = "bug.png";
    public static final String DELETED_DIRECTORY_ICON = "folder-deleted.png";
    public static final String FILE_ICON = "file.png";
    public static final String DELETED_FILE_ICON = "file-deleted.png";
    public static final int ICON_WIDTH = 15;
    public static final int ICON_HEIGHT = 13;
    private final ReportConfig config;
    private final String notesHTML;
    private List extraPages = new ArrayList();

    public ReportSuiteMaker(ReportConfig config, String notesHTML) {
        this(config, notesHTML, Collections.EMPTY_LIST);
    }

    public ReportSuiteMaker(ReportConfig config, String notesHTML, List additionalPages) {
        this.config = config;
        this.notesHTML = notesHTML;
        this.extraPages = additionalPages;
    }

    public void toXml() {
        new GenerateXml(this.config).generate();
    }

    public Page toFile() throws IOException {
        this.config.getCssHandler().createOutputFiles();
        if (this.config.getRepository().isEmpty()) {
            return this.createEmptyRepositoryPage();
        }
        this.createIcon(BUG_ICON);
        this.createIcon(DIRECTORY_ICON);
        this.createIcon(DELETED_DIRECTORY_ICON);
        this.createIcon(FILE_ICON);
        this.createIcon(DELETED_FILE_ICON);
        PageGroup mainMenu = new PageGroup("Reports", false);
        mainMenu.add(new AllDevelopersPageMaker(this.config).toFile());
        mainMenu.add(new LogPageGroupMaker(this.config).getPages());
        mainMenu.add(new LOCPageMaker(this.config).toFile());
        mainMenu.add(new FileSizesPageMaker(this.config).toFile());
        mainMenu.add(new DirectorySizesPageMaker(this.config).toFile());
        mainMenu.add(new RepoMapPageMaker(this.config).toFile());
        mainMenu.add(new ChurnPageMaker(this.config).toFile());
        Iterator it = this.extraPages.iterator();
        while (it.hasNext()) {
            mainMenu.add((Page)it.next());
        }
        Page indexPage = new IndexPageMaker(this.config, this.notesHTML, mainMenu).toFile();
        PageGroup directoryPages = new PageGroup("Directories", false);
        it = this.config.getRepository().getDirectories().iterator();
        while (it.hasNext()) {
            directoryPages.add(new DirectoryPageMaker(this.config, (Directory)it.next()).toFile());
        }
        indexPage.addChild(directoryPages);
        return indexPage;
    }

    private void createIcon(String iconFilename) throws IOException {
        this.config.copyFileIntoReport(Main.class.getResource(WEB_FILE_PATH + iconFilename), iconFilename);
    }

    private Page createEmptyRepositoryPage() {
        String projectName = this.config.getProjectName();
        if (projectName == null) {
            projectName = "empty repository";
        }
        String title = "Development statistics for " + projectName;
        Page page = this.config.createPage("index", title, title);
        page.addAttribute("Generated", Calendar.getInstance().getTime());
        page.addRawContent("<p>No matching files in repository.</p>");
        return page;
    }
}

