/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;

public class MarkupXDoc
implements MarkupSyntax {
    private static final MarkupSyntax instance = new MarkupXDoc();

    public static MarkupSyntax getInstance() {
        return instance;
    }

    private MarkupXDoc() {
    }

    public String getEndOfPage() {
        return "</body>\n</document>";
    }

    public String getExtension() {
        return "xml";
    }

    public String getHeader(String pageName, String stylesheetURL, String charSet) {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<document xmlns:lxslt=\"http://xml.apache.org/xslt\">\n<properties><title>" + pageName + "</title></properties>\n" + "<head>\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; " + "charset=" + charSet + "\"/>\n" + "    <meta name=\"Generator\" content=\"StatCVS 0.4.1\"/>\n" + "    <link rel=\"stylesheet\" href=\"" + HTML.escape(stylesheetURL) + "\" type=\"text/css\"/>\n" + "  </head>\n\n" + "<body>";
    }

    public String startSection1(String title) {
        return "<section name=\"" + title + "\">\n";
    }

    public String endSection1() {
        return "</section>";
    }

    public String startSection2(String title) {
        return "\n<div class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String startSection2(String title, String id) {
        return "\n<div id=\"" + HTML.escape(id) + "\" class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String endSection2() {
        return "</subsection></div>";
    }

    public String getTableFormat() {
        return " class=\"statCvsTable\"";
    }

    public String toString() {
        return "XDoc";
    }
}

