/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.DirectoryPieChartMaker;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.DirectoriesTableReport;

public class DirectorySizesPageMaker {
    private final ReportConfig config;
    private final Repository repository;

    public DirectorySizesPageMaker(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public NavigationNode toFile() {
        ChartImage allDirLOCChart = new LOCChartMaker.AllDirectoriesLOCChartMaker(this.config, 6).toFile();
        ChartImage dirSizesChart = new DirectoryPieChartMaker.DirectorySizesChartMaker(this.config).toFile();
        DirectoriesTableReport table = new DirectoriesTableReport(this.repository);
        Page page = this.config.createPage("dir_sizes", "Directory Sizes", "Directory Sizes");
        page.addAttribute("Total Directories", this.repository.getDirectories().size());
        page.add(allDirLOCChart);
        page.addSection("Directory Statistics");
        page.add(table);
        page.add(dirSizesChart);
        return page;
    }
}

