/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.DirectoryPieChartMaker;
import net.sf.statcvs.charts.TimeBarChartMaker;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.CommitListFormatter;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.DirectoriesForAuthorTableReport;

public class DeveloperPageMaker {
    private static final int RECENT_COMMITS_LENGTH = 20;
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    private final ReportConfig config;
    private final Author developer;
    private final Repository repository;

    public static String getURL(Author developer) {
        return DeveloperPageMaker.getFilename(developer) + ".html";
    }

    private static String getFilename(Author developer) {
        return "user_" + HTML.escapeAuthorName(developer.getName());
    }

    public DeveloperPageMaker(ReportConfig config, Author developer) {
        this.config = config;
        this.developer = developer;
        this.repository = config.getRepository();
    }

    public Page toFile() {
        ChartImage hourChart = new TimeBarChartMaker.HourBarChartMaker(this.config, this.developer.getRevisions(), Messages.getString("ACTIVITY_TIME_FOR_AUTHOR_TITLE") + " " + this.developer.getRealName(), "activity_time_" + HTML.escapeAuthorName(this.developer.getName()) + ".png").toFile();
        ChartImage weekdayChart = new TimeBarChartMaker.WeekdayBarChartMaker(this.config, this.developer.getRevisions(), Messages.getString("ACTIVITY_DAY_FOR_AUTHOR_TITLE") + " " + this.developer.getRealName(), "activity_day_" + HTML.escapeAuthorName(this.developer.getName()) + ".png").toFile();
        ChartImage codeDistributionChart = new DirectoryPieChartMaker.CodeDistributionChartMaker(this.config, this.developer).toFile();
        String title = this.config.isDeveloper(this.developer) ? this.config.getProjectName() + " Developers: " + this.developer.getRealName() : "Non-developer Login: " + this.developer.getRealName();
        Page page = this.config.createPage(DeveloperPageMaker.getFilename(this.developer), this.developer.getRealName(), title);
        page.addAttribute("Login name", this.developer.getName());
        if (this.developer.getRealName() != null && !this.developer.getRealName().equals(this.developer.getName())) {
            page.addAttribute("Real name", this.developer.getRealName());
        }
        if (this.developer.getEmail() != null && this.developer.getEmail().length() > 0) {
            page.addRawAttribute("Email", "<a href=\"mailto:" + this.developer.getEmail() + "\">" + this.developer.getEmail() + "</a>");
        }
        if (this.developer.getHomePageUrl() != null && this.developer.getHomePageUrl().length() > 0) {
            page.addRawAttribute("Home Page", "<a href=\"" + this.developer.getHomePageUrl() + "\">" + this.developer.getHomePageUrl() + "</a>");
        }
        if (this.developer.getImageUrl() != null && this.developer.getImageUrl().length() > 0) {
            page.addRawAttribute("Image", "<img src=\"" + this.developer.getImageUrl() + "\" alt=\"" + this.developer.getRealName() + "\"/>");
        }
        page.addAttribute("Total Commits", this.getNumberAndPercentage(this.developer.getRevisions().size(), this.repository.getRevisions().size()));
        page.addAttribute("Lines of Code", this.getNumberAndPercentage(this.countContributedLines(this.developer.getRevisions()), this.countContributedLines(this.repository.getRevisions())));
        page.addAttribute("Most Recent Commit", ((Revision)this.developer.getRevisions().last()).getDate());
        page.addSection(Messages.getString("ACTIVITY_TITLE"));
        page.add(hourChart);
        page.add(weekdayChart);
        page.addSection("Activity in Directories");
        page.add(new DirectoriesForAuthorTableReport(this.config, this.developer));
        if (codeDistributionChart != null) {
            page.add(codeDistributionChart);
        }
        page.addSection(Messages.getString("MOST_RECENT_COMMITS"));
        page.addRawContent(new CommitListFormatter(this.config, this.getRecentCommits(), Collections.EMPTY_LIST, 20, false).render());
        return page;
    }

    private List getRecentCommits() {
        ArrayList<Commit> results = new ArrayList<Commit>();
        Iterator it = this.repository.getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            if (!this.developer.equals(commit.getAuthor())) continue;
            results.add(commit);
        }
        return results;
    }

    private int countContributedLines(Collection revisions) {
        int result = 0;
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision element = (Revision)it.next();
            result += element.getNewLines();
        }
        return result;
    }

    private String getNumberAndPercentage(int value, int total) {
        double factor = (double)value / (double)total;
        return value + " (" + PERCENT_FORMAT.format(factor) + ")";
    }

    static {
        PERCENT_FORMAT.setMinimumFractionDigits(1);
        PERCENT_FORMAT.setMaximumFractionDigits(1);
    }
}

