/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Revision;

public class Commit
implements Comparable {
    private final Set revisions = new HashSet();
    private final Revision aRevision;

    public Commit(Revision revision) {
        this.revisions.add(revision);
        this.aRevision = revision;
    }

    public void addRevision(Revision revision) {
        this.revisions.add(revision);
    }

    public Set getRevisions() {
        return this.revisions;
    }

    public Author getAuthor() {
        return this.aRevision.getAuthor();
    }

    public String getComment() {
        return this.aRevision.getComment();
    }

    public Date getDate() {
        return this.aRevision.getDate();
    }

    public Set getAffectedFiles() {
        HashSet<String> result = new HashSet<String>();
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            Revision element = (Revision)it.next();
            result.add(element.getFile().getFilenameWithPath());
        }
        return result;
    }

    public int compareTo(Object other) {
        Commit otherCommit = (Commit)other;
        return this.getDate().compareTo(otherCommit.getDate());
    }
}

