/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.util.LookaheadReader;

public class CvsRevisionParser {
    private static Logger logger = Logger.getLogger(CvsRevisionParser.class.getName());
    public static final String REVISION_DELIMITER = "----------------------------";
    public static final String FILE_DELIMITER = "=============================================================================";
    private static final String OLD_LOG_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss zzz";
    private static final String NEW_LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static SimpleDateFormat oldLogTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);
    private static SimpleDateFormat newLogTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", LOG_TIMESTAMP_LOCALE);
    private final LookaheadReader logReader;
    private final CvsLogBuilder builder;
    private boolean fileDone = false;
    private RevisionData revision;

    public CvsRevisionParser(LookaheadReader logReader, CvsLogBuilder builder) {
        this.logReader = logReader;
        this.builder = builder;
    }

    public void parse() throws LogSyntaxException, IOException {
        this.logReader.nextLine();
        do {
            this.revision = new RevisionData();
            this.parseRevision();
            this.builder.buildRevision(this.revision);
        } while (!this.fileDone);
    }

    private void parseRevision() throws IOException, LogSyntaxException {
        if (!this.isNewRevisionLine(this.logReader.getCurrentLine())) {
            throw new LogSyntaxException("expected 'revision' but found '" + this.logReader.getCurrentLine() + "' in line " + this.logReader.getLineNumber());
        }
        String revNo = this.logReader.getCurrentLine().substring("revision ".length());
        this.revision.setRevisionNumber(revNo);
        this.parseDateLine(this.logReader.nextLine());
        if (this.logReader.nextLine().startsWith("branches:")) {
            this.logReader.nextLine();
        }
        StringBuffer comment = new StringBuffer();
        while (true) {
            String line;
            if (REVISION_DELIMITER.equals(line = this.logReader.getCurrentLine())) {
                String next = this.logReader.nextLine();
                if (this.isNewRevisionLine(next)) {
                    this.revision.setComment(comment.toString());
                    return;
                }
            } else if (FILE_DELIMITER.equals(line)) {
                if (!this.logReader.hasNextLine() || "".equals(this.logReader.nextLine())) {
                    this.revision.setComment(comment.toString());
                    this.fileDone = true;
                    return;
                }
            } else {
                this.logReader.nextLine();
            }
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append(line);
        }
    }

    private void parseDateLine(String line) throws LogSyntaxException {
        int endOfDateIndex = line.indexOf(59, 6);
        String dateString = line.substring(6, endOfDateIndex) + " GMT";
        Date date = CvsRevisionParser.convertFromLogTime(dateString);
        if (date == null) {
            throw new LogSyntaxException("unexpected date format in line " + this.logReader.getLineNumber());
        }
        this.revision.setDate(date);
        int endOfAuthorIndex = line.indexOf(59, endOfDateIndex + 1);
        this.revision.setLoginName(line.substring(endOfDateIndex + 11, endOfAuthorIndex));
        String fileState = line.substring(endOfAuthorIndex + 10, line.indexOf(59, endOfAuthorIndex + 1));
        if (this.isDeadState(fileState)) {
            this.revision.setStateDead();
            return;
        }
        this.revision.setStateExp();
        int beginOfLinesIndex = line.indexOf("lines:", endOfAuthorIndex + 1);
        if (beginOfLinesIndex < 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line.substring(beginOfLinesIndex + 8));
        int linesAdded = Integer.parseInt(st.nextToken());
        String removed = st.nextToken();
        if (removed.indexOf(59) >= 0) {
            removed = removed.substring(0, removed.indexOf(59));
        }
        int linesRemoved = -Integer.parseInt(removed);
        this.revision.setLines(linesAdded, linesRemoved);
    }

    private boolean isNewRevisionLine(String line) {
        return line.startsWith("revision ");
    }

    private boolean isDeadState(String state) {
        if ("dead".equals(state)) {
            return true;
        }
        if ("Exp".equals(state) || "Stab".equals(state) || "Rel".equals(state)) {
            return false;
        }
        logger.warning("unknown file state '" + state + "' at line " + this.logReader.getLineNumber());
        return false;
    }

    private static Date convertFromLogTime(String modTime) {
        try {
            return oldLogTimeFormat.parse(modTime);
        }
        catch (ParseException e) {
            try {
                return newLogTimeFormat.parse(modTime);
            }
            catch (ParseException e2) {
                return null;
            }
        }
    }
}

