/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.SymbolicName;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class SymbolicNameAnnotation
implements XYAnnotation {
    public static final int STYLE_DEFAULT = 0;
    public static final int STYLE_NO_LABELS = 1;
    public static final float MIN_LABEL_X_SPACING = 7.0f;
    private final Color linePaint = Color.GRAY;
    private final Color textPaint = Color.DARK_GRAY;
    private final Font font = new Font("Dialog", 0, 9);
    private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.5f}, 0.0f);
    private final SymbolicName symbolicName;
    private final List allSymbolicNames;
    private final int style;

    public static List createAnnotations(Collection symbolicNames) {
        return SymbolicNameAnnotation.createAnnotations(symbolicNames, 0);
    }

    public static List createAnnotations(Collection symbolicNames, int style) {
        ArrayList<SymbolicNameAnnotation> annotations = new ArrayList<SymbolicNameAnnotation>();
        Iterator it = symbolicNames.iterator();
        while (it.hasNext()) {
            SymbolicName sn = (SymbolicName)it.next();
            annotations.add(new SymbolicNameAnnotation(sn, symbolicNames, style));
        }
        return annotations;
    }

    public SymbolicNameAnnotation(SymbolicName symbolicName, Collection all, int style) {
        this.symbolicName = symbolicName;
        this.allSymbolicNames = new ArrayList(all);
        Collections.sort(this.allSymbolicNames);
        this.style = style;
    }

    public void draw(Graphics2D g2d, XYPlot xyPlot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = xyPlot.getOrientation();
        if (domainAxis.getUpperBound() < (double)this.symbolicName.getDate().getTime() || domainAxis.getLowerBound() > (double)this.symbolicName.getDate().getTime()) {
            return;
        }
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(xyPlot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(xyPlot.getRangeAxisLocation(), orientation);
        float x = this.getNaturalX(this.symbolicName, dataArea, domainAxis, domainEdge);
        float y1 = (float)rangeAxis.valueToJava2D(rangeAxis.getUpperBound(), dataArea, rangeEdge);
        float y2 = (float)rangeAxis.valueToJava2D(rangeAxis.getLowerBound(), dataArea, rangeEdge);
        g2d.setPaint(this.linePaint);
        g2d.setStroke(STROKE);
        Line2D.Float line = new Line2D.Float(x, y1, x, y2);
        g2d.draw(line);
        if (this.style == 1) {
            return;
        }
        g2d.setFont(this.font);
        g2d.setPaint(this.textPaint);
        TextUtilities.drawRotatedString(this.symbolicName.getName(), g2d, this.getArrangedLabelX(this.symbolicName, dataArea, domainAxis, domainEdge), y1 + 2.0f, TextAnchor.BOTTOM_RIGHT, -1.5707963267948966, TextAnchor.BOTTOM_RIGHT);
    }

    private float getArrangedLabelX(SymbolicName tag, Rectangle2D dataArea, ValueAxis domainAxis, RectangleEdge domainEdge) {
        float naturalX = this.getNaturalX(tag, dataArea, domainAxis, domainEdge);
        int offset = this.allSymbolicNames.indexOf(tag);
        if (offset == this.allSymbolicNames.size() - 1) {
            return naturalX;
        }
        SymbolicName next = (SymbolicName)this.allSymbolicNames.get(offset + 1);
        float nextX = this.getArrangedLabelX(next, dataArea, domainAxis, domainEdge);
        if (nextX > naturalX + 7.0f) {
            return naturalX;
        }
        return nextX - 7.0f;
    }

    private float getNaturalX(SymbolicName tag, Rectangle2D dataArea, ValueAxis domainAxis, RectangleEdge domainEdge) {
        return (float)domainAxis.valueToJava2D(tag.getDate().getTime(), dataArea, domainEdge);
    }
}

