/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.ChartUtils;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.util.IntegerMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;

public abstract class DirectoryPieChartMaker {
    private static final int SLICE_MIN_PERCENT = 5;
    private final ReportConfig config;
    private final String title;
    private final String fileName;
    private List directories = new ArrayList();

    public DirectoryPieChartMaker(ReportConfig config, SortedSet directories, String title, String fileName) {
        this.config = config;
        this.title = title;
        this.fileName = fileName;
        this.directories = new ArrayList(directories);
    }

    public ChartImage toFile() {
        DefaultPieDataset data = new DefaultPieDataset();
        IntegerMap dirSizes = new IntegerMap();
        Collections.sort(this.directories);
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            dirSizes.addInt(dir, this.calculateValue(dir));
        }
        int otherSum = 0;
        HashMap<String, Color> colors = new HashMap<String, Color>();
        it = dirSizes.iteratorSortedByValue();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            if (dirSizes.getPercent(dir) >= 5.0) {
                String dirName = dir.isRoot() ? "/" : dir.getPath();
                data.setValue((Comparable)((Object)dirName), dirSizes.getInteger(dir));
                colors.put(dirName, ChartUtils.getStringColor(dirName));
                continue;
            }
            otherSum += dirSizes.get(dir);
        }
        data.setValue((Comparable)((Object)Messages.getString("PIE_MODSIZE_OTHER")), new Integer(otherSum));
        colors.put(Messages.getString("PIE_MODSIZE_OTHER"), Color.GRAY);
        JFreeChart chart = ChartFactory.createPieChart(this.config.getProjectName() + ": " + this.title, data, false, false, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setShadowPaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelOutlinePaint(Color.LIGHT_GRAY);
        plot.setForegroundAlpha(0.8f);
        plot.setSectionOutlinePaint(Color.BLACK);
        it = colors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            plot.setSectionPaint((Comparable)((Object)((String)entry.getKey())), (Paint)entry.getValue());
        }
        return this.config.createChartImage(this.fileName, this.title, chart, this.config.getLargeChartSize());
    }

    protected abstract int calculateValue(Directory var1);

    public static class CodeDistributionChartMaker
    extends DirectoryPieChartMaker {
        private final Author author;

        private static String getFileName(Author author) {
            return "directory_sizes_" + HTML.escapeAuthorName(author.getName()) + ".png";
        }

        public CodeDistributionChartMaker(ReportConfig config, Author author) {
            super(config, author.getDirectories(), Messages.getString("PIE_CODEDISTRIBUTION_SUBTITLE") + " " + author.getRealName(), CodeDistributionChartMaker.getFileName(author));
            this.author = author;
        }

        public ChartImage toFile() {
            Iterator it = this.author.getRevisions().iterator();
            int totalLinesOfCode = 0;
            while (it.hasNext()) {
                Revision rev = (Revision)it.next();
                totalLinesOfCode += rev.getNewLines();
            }
            if (totalLinesOfCode == 0) {
                return null;
            }
            return super.toFile();
        }

        protected int calculateValue(Directory directory) {
            int result = 0;
            Iterator it = directory.getRevisions().iterator();
            while (it.hasNext()) {
                Revision rev = (Revision)it.next();
                if (!this.author.equals(rev.getAuthor())) continue;
                result += rev.getNewLines();
            }
            return result;
        }
    }

    public static class DirectorySizesChartMaker
    extends DirectoryPieChartMaker {
        public DirectorySizesChartMaker(ReportConfig config) {
            super(config, config.getRepository().getDirectories(), Messages.getString("PIE_MODSIZE_SUBTITLE"), "directory_sizes.png");
        }

        protected int calculateValue(Directory directory) {
            int result = 0;
            Iterator fileIt = directory.getFiles().iterator();
            while (fileIt.hasNext()) {
                VersionedFile element = (VersionedFile)fileIt.next();
                result += element.getCurrentLinesOfCode();
            }
            return result;
        }
    }
}

