/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.toolbar;

import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.Filter;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.toolbar.ToolBarMenu;
import chrriis.udoc.ui.widgets.ArrowButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FilterToolBarMenu
extends ToolBarMenu {
    protected static final Color SELECTION_COLOR = new Color(218, 219, 255);
    protected ClassPane classPane;

    public FilterToolBarMenu(ClassPane classPane) {
        super(IconManager.getIcon("tool_bar_on.gif"), IconManager.getIcon("tool_bar_off.gif"), classPane);
        this.classPane = classPane;
    }

    protected String getContentTitle() {
        return "Filters";
    }

    protected Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    protected Component createPopupMenuContent() {
        final JList<Object> list = new JList<Object>(new DefaultListModel());
        list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (!(value instanceof Filter)) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                Filter filter = (Filter)value;
                DefaultListCellRenderer renderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, FilterToolBarMenu.getFilterDisplay(filter), index, isSelected, cellHasFocus);
                return renderer;
            }
        });
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 0));
        JPanel westPanel = new JPanel(new BorderLayout(0, 0));
        JPanel additionPanel = new JPanel();
        additionPanel.setBorder(BorderFactory.createTitledBorder("New Filter"));
        BoxLayout boxLayout = new BoxLayout(additionPanel, 1);
        additionPanel.setLayout(boxLayout);
        final JTextField expressionField = new JTextField(7);
        additionPanel.add(expressionField);
        final JCheckBox regularExpressionCheckBox = new JCheckBox("Regular Expression");
        additionPanel.add(regularExpressionCheckBox);
        final JCheckBox classCheckBox = new JCheckBox("Class");
        classCheckBox.setSelected(true);
        additionPanel.add(classCheckBox);
        final JCheckBox interfaceCheckBox = new JCheckBox("Interface");
        interfaceCheckBox.setSelected(true);
        additionPanel.add(interfaceCheckBox);
        final JCheckBox enumCheckBox = new JCheckBox("Enum");
        enumCheckBox.setSelected(true);
        additionPanel.add(enumCheckBox);
        final JCheckBox annotationCheckBox = new JCheckBox("Annotation");
        annotationCheckBox.setSelected(true);
        additionPanel.add(annotationCheckBox);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String pattern = expressionField.getText();
                if (pattern.length() == 0) {
                    return;
                }
                boolean isClass = classCheckBox.isSelected();
                boolean isInterface = interfaceCheckBox.isSelected();
                boolean isEnum = enumCheckBox.isSelected();
                boolean isAnnotation = annotationCheckBox.isSelected();
                int modifiers = 0;
                if (isClass != isInterface || isClass != isEnum || isClass != isAnnotation) {
                    if (isClass) {
                        modifiers |= 0x100;
                    }
                    if (isInterface) {
                        modifiers |= 0x40;
                    }
                    if (isEnum) {
                        modifiers |= 0x20;
                    }
                    if (isAnnotation) {
                        modifiers |= 0x10;
                    }
                }
                boolean isRegularExpression = regularExpressionCheckBox.isSelected();
                try {
                    Filter filter = new Filter(pattern, isRegularExpression, modifiers);
                    expressionField.setText("");
                    FilterToolBarMenu.this.classPane.addFilter(filter);
                    FilterToolBarMenu.this.updateListModel(list);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        expressionField.addActionListener(actionListener);
        westPanel.add((Component)additionPanel, "West");
        GridBagLayout gridBag = new GridBagLayout();
        JPanel centerPanel = new JPanel(gridBag);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(2, 2, 2, 2);
        final ArrowButton rightButton = new ArrowButton(3);
        gridBag.setConstraints(rightButton, cons);
        centerPanel.add(rightButton);
        rightButton.setEnabled(false);
        rightButton.addActionListener(actionListener);
        expressionField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                rightButton.setEnabled(expressionField.getText().length() > 0);
            }

            public void insertUpdate(DocumentEvent e) {
                rightButton.setEnabled(expressionField.getText().length() > 0);
            }

            public void removeUpdate(DocumentEvent e) {
                rightButton.setEnabled(expressionField.getText().length() > 0);
            }
        });
        ++cons.gridy;
        final ArrowButton leftButton = new ArrowButton(7);
        gridBag.setConstraints(leftButton, cons);
        centerPanel.add(leftButton);
        leftButton.setEnabled(false);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                leftButton.setEnabled(list.getSelectedIndices().length > 0);
            }
        });
        leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = list.getLeadSelectionIndex();
                Filter filter = null;
                if (index != -1) {
                    filter = (Filter)list.getModel().getElementAt(index);
                }
                Object[] values = list.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    FilterToolBarMenu.this.classPane.removeFilter((Filter)values[i]);
                    ++i;
                }
                FilterToolBarMenu.this.updateListModel(list);
                if (filter != null) {
                    expressionField.setText(filter.getNamePattern());
                    regularExpressionCheckBox.setSelected(filter.isRegularExpression());
                    int modifiers = filter.getModifiers();
                    classCheckBox.setSelected((modifiers & 0x100) != 0);
                    interfaceCheckBox.setSelected((modifiers & 0x40) != 0);
                    enumCheckBox.setSelected((modifiers & 0x20) != 0);
                    annotationCheckBox.setSelected((modifiers & 0x10) != 0);
                }
            }
        });
        JPanel filterPane = new JPanel(new BorderLayout(0, 0)){

            public void requestFocus() {
                expressionField.requestFocus();
            }
        };
        JPanel listPanel = new JPanel(new BorderLayout(0, 0));
        listPanel.add((Component)scrollPane, "Center");
        listPanel.setBorder(BorderFactory.createTitledBorder("Current Filters"));
        filterPane.add((Component)listPanel, "East");
        filterPane.add((Component)centerPanel, "Center");
        filterPane.add((Component)westPanel, "West");
        gridBag = new GridBagLayout();
        cons = new GridBagConstraints();
        JPanel visibilityPanel = new JPanel(gridBag);
        visibilityPanel.setBorder(BorderFactory.createTitledBorder("Least Visible Access"));
        cons.insets = new Insets(2, 2, 2, 2);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 2;
        JLabel fieldVisibilityLabel = new JLabel("Fields: ");
        gridBag.setConstraints(fieldVisibilityLabel, cons);
        visibilityPanel.add(fieldVisibilityLabel);
        ++cons.gridy;
        JLabel methodVisibilityLabel = new JLabel("Methods: ");
        gridBag.setConstraints(methodVisibilityLabel, cons);
        visibilityPanel.add(methodVisibilityLabel);
        ++cons.gridx;
        cons.gridy = 0;
        DefaultListCellRenderer visibilityRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Integer) {
                    switch ((Integer)value) {
                        case 1: {
                            value = "Public";
                            break;
                        }
                        case 2: {
                            value = "Protected";
                            break;
                        }
                        case 3: {
                            value = "Default";
                            break;
                        }
                        case 4: {
                            value = "Private";
                        }
                    }
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
        JComboBox<Integer> fieldVisibilityCombo = new JComboBox<Integer>(new Integer[]{new Integer(4), new Integer(3), new Integer(2), new Integer(1)});
        fieldVisibilityCombo.setSelectedItem(new Integer(this.classPane.getFieldVisibility()));
        fieldVisibilityCombo.setRenderer(visibilityRenderer);
        gridBag.setConstraints(fieldVisibilityCombo, cons);
        visibilityPanel.add(fieldVisibilityCombo);
        fieldVisibilityCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FilterToolBarMenu.this.classPane.setFieldVisibility((Integer)e.getItem());
                }
            }
        });
        ++cons.gridy;
        JComboBox<Integer> methodVisibilityCombo = new JComboBox<Integer>(new Integer[]{new Integer(4), new Integer(3), new Integer(2), new Integer(1)});
        methodVisibilityCombo.setSelectedItem(new Integer(this.classPane.getMethodVisibility()));
        methodVisibilityCombo.setRenderer(visibilityRenderer);
        gridBag.setConstraints(methodVisibilityCombo, cons);
        visibilityPanel.add(methodVisibilityCombo);
        methodVisibilityCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FilterToolBarMenu.this.classPane.setMethodVisibility((Integer)e.getItem());
                }
            }
        });
        filterPane.add((Component)visibilityPanel, "South");
        this.updateListModel(list);
        return filterPane;
    }

    protected void updateListModel(JList list) {
        Filter[] filters = this.classPane.getFilters();
        Arrays.sort(filters, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FilterToolBarMenu.getFilterDisplay((Filter)o2).toLowerCase(Locale.ENGLISH).compareTo(FilterToolBarMenu.getFilterDisplay((Filter)o1).toLowerCase(Locale.ENGLISH));
            }
        });
        Object[] values = list.getSelectedValues();
        DefaultListModel<Filter> model = new DefaultListModel<Filter>();
        list.setModel(model);
        int i = filters.length - 1;
        while (i >= 0) {
            model.addElement(filters[i]);
            --i;
        }
        i = 0;
        while (i < values.length) {
            int index = model.indexOf(values[i]);
            if (index >= 0) {
                list.addSelectionInterval(index, index);
            }
            ++i;
        }
    }

    protected static String getFilterDisplay(Filter filter) {
        boolean isInterface;
        int modifiers = filter.getModifiers();
        StringBuffer sb = new StringBuffer();
        sb.append(filter.getNamePattern());
        boolean isClass = (modifiers & 0x100) != 0;
        boolean bl = isInterface = (modifiers & 0x40) != 0;
        if (isInterface != isClass) {
            sb.append(" - ");
            if (isClass) {
                sb.append("classes");
            } else {
                sb.append("interfaces");
            }
        }
        return sb.toString();
    }
}

