/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.print;

import chrriis.udoc.ui.ClassPane;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;

public class PrintProcessing {
    public static final int SCALE = 1;
    public static final int PAGE_FIT = 4;
    public static final int HORIZONTAL_PAGE_FIT = 2;
    public static final int VERTICAL_PAGE_FIT = 3;
    protected static final int SHORT_EDGE_SIZE = 595;
    protected static final int LONG_EDGE_SIZE = 842;
    protected static String scalePercentage = "100";
    protected static String horizontalPageFit = "1";
    protected static String verticalPageFit = "1";
    protected static String pageFit = "1";
    protected static boolean isPortrait = true;
    protected static int fitType = 1;
    protected static final int MAX_WIDTH = 2000;
    protected static final int MAX_HEIGHT = 2000;
    static /* synthetic */ Class class$0;

    public static int getFitType() {
        return fitType;
    }

    public static void setFitType(int fitType) {
        PrintProcessing.fitType = fitType;
    }

    public static String getScalePercentageString() {
        return scalePercentage;
    }

    public static float getScalePercentage() {
        return PrintProcessing.getValidScalePercentage(scalePercentage);
    }

    public static void setScalePercentageString(String scalePercentage) {
        PrintProcessing.scalePercentage = scalePercentage;
    }

    public static String getHorizontalPageFitString() {
        return horizontalPageFit;
    }

    public static float getHorizontalPageFit() {
        return PrintProcessing.getValidHorizontalPageFit(horizontalPageFit);
    }

    public static void setHorizontalPageFit(String horizontalPageFit) {
        PrintProcessing.horizontalPageFit = horizontalPageFit;
    }

    public static String getVerticalPageFitString() {
        return verticalPageFit;
    }

    public static float getVerticalPageFit() {
        return PrintProcessing.getValidVerticalPageFit(verticalPageFit);
    }

    public static void setVerticalPageFit(String verticalPageFit) {
        PrintProcessing.verticalPageFit = verticalPageFit;
    }

    public static String getPageFitString() {
        return pageFit;
    }

    public static float getPageFit() {
        return PrintProcessing.getValidPageFit(pageFit);
    }

    public static void setPageFit(String pageFit) {
        PrintProcessing.pageFit = pageFit;
    }

    public static void setPortrait(boolean isPortrait) {
        PrintProcessing.isPortrait = isPortrait;
    }

    public static boolean isPortrait() {
        return isPortrait;
    }

    public static float getValidScalePercentage(String scalePercentage) {
        return PrintProcessing.getValidFloatValue(scalePercentage, 20.0f, 100.0f, 500.0f);
    }

    public static float getValidHorizontalPageFit(String horizontalPageFit) {
        return PrintProcessing.getValidFloatValue(horizontalPageFit, 0.4f, 1.0f, 10.0f);
    }

    public static float getValidVerticalPageFit(String verticalPageFit) {
        return PrintProcessing.getValidFloatValue(verticalPageFit, 0.4f, 1.0f, 10.0f);
    }

    public static float getValidPageFit(String pageFit) {
        return PrintProcessing.getValidFloatValue(pageFit, 0.4f, 1.0f, 10.0f);
    }

    protected static float getValidFloatValue(String value, float min, float defaultValue, float max) {
        try {
            float f = Float.parseFloat(value);
            if (f > max) {
                return max;
            }
            if (f < min) {
                return min;
            }
            return f;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Point getEdges(ClassPane classPane, boolean isPortrait) {
        int hEdge;
        int wEdge;
        if (isPortrait) {
            wEdge = 595;
            hEdge = 842;
        } else {
            wEdge = 842;
            hEdge = 595;
        }
        return new Point(wEdge, hEdge);
    }

    protected static float computeRatio(Point edges, Rectangle printBounds, PrintingAttributes printingAttributes) {
        int w = printBounds.width;
        int h = printBounds.height;
        switch (printingAttributes.fitType) {
            case 4: {
                return Math.min(printingAttributes.pageFit * (float)edges.x / (float)w, printingAttributes.pageFit * (float)edges.y / (float)h);
            }
            case 2: {
                return printingAttributes.horizontalPageFit * (float)edges.x / (float)w;
            }
            case 3: {
                return printingAttributes.verticalPageFit * (float)edges.y / (float)h;
            }
        }
        return printingAttributes.scalePercentage / 100.0f;
    }

    public static Point getPageCount(ClassPane classPane, PrintingAttributes printingAttributes) {
        Point edges = PrintProcessing.getEdges(classPane, printingAttributes.isPortrait);
        Rectangle printBounds = classPane.getClassComponentPanePrintBounds();
        float ratio = PrintProcessing.computeRatio(edges, printBounds, printingAttributes);
        int w = printBounds.width;
        int h = printBounds.height;
        float scaledW = (float)w * ratio;
        float scaledH = (float)h * ratio;
        return new Point(Math.max(0, Math.round(scaledW) - 1) / edges.x + 1, Math.max(0, Math.round(scaledH) - 1) / edges.y + 1);
    }

    public static float getRatio(ClassPane classPane, PrintingAttributes printingAttributes) {
        Point edges = PrintProcessing.getEdges(classPane, printingAttributes.isPortrait);
        Rectangle printBounds = classPane.getClassComponentPanePrintBounds();
        return PrintProcessing.computeRatio(edges, printBounds, printingAttributes);
    }

    protected static Rectangle getClassPaneImageArea(ClassPane classPane, int x, int y, PrintingAttributes printingAttributes) {
        Point edges = PrintProcessing.getEdges(classPane, printingAttributes.isPortrait);
        float ratio = PrintProcessing.getRatio(classPane, printingAttributes);
        edges.x = Math.round((float)edges.x / ratio);
        edges.y = Math.round((float)edges.y / ratio);
        int pageWidth = edges.x;
        int pageHeight = edges.y;
        return new Rectangle(x * edges.x, y * edges.y, pageWidth, pageHeight);
    }

    public static void printPage(ClassPane classPane, Graphics g, Rectangle outputBounds, int x, int y, PrintingAttributes printingAttributes, int scalingMethod) {
        Rectangle classPaneImageArea = PrintProcessing.getClassPaneImageArea(classPane, x, y, printingAttributes);
        Rectangle printBounds = classPane.getClassComponentPanePrintBounds();
        if (printBounds == null) {
            return;
        }
        int imageWidth = classPaneImageArea.width;
        int imageHeight = classPaneImageArea.height;
        int expectedHeight = Math.round((float)outputBounds.width * (float)imageHeight / (float)imageWidth);
        x = outputBounds.x;
        y = outputBounds.y;
        float ratio = expectedHeight <= outputBounds.height ? (float)imageWidth / (float)outputBounds.width : (float)imageWidth / (float)Math.round((float)outputBounds.height * (float)imageWidth / (float)imageHeight);
        int divisionX = (classPaneImageArea.width - 1) / 2000 + 1;
        int divisionY = (classPaneImageArea.height - 1) / 2000 + 1;
        int offsetY = 0;
        int tx = Math.round((classPaneImageArea.width - (printBounds.width - 1) % classPaneImageArea.width + 1) / 2);
        int ty = Math.round((classPaneImageArea.height - (printBounds.height - 1) % classPaneImageArea.height + 1) / 2);
        int j = 0;
        while (j < divisionY) {
            int tileHeight = j == divisionY - 1 ? classPaneImageArea.height % 2000 : 2000;
            int offsetX = 0;
            int i = 0;
            while (i < divisionX) {
                int tileWidth = i == divisionX - 1 ? classPaneImageArea.width % 2000 : 2000;
                BufferedImage image = new BufferedImage(tileWidth, tileHeight, 2);
                Graphics ig = ((Image)image).getGraphics();
                ig.setClip(0, 0, tileWidth, tileHeight);
                ig.translate(tx - printBounds.x - classPaneImageArea.x - 2000 * i, ty - printBounds.y - classPaneImageArea.y - 2000 * j);
                classPane.getClassComponentPane().print(ig);
                ig.dispose();
                if (scalingMethod > 0) {
                    g.drawImage(image.getScaledInstance(Math.round((float)tileWidth / ratio), Math.round((float)tileHeight / ratio), 4), x + offsetX, y + offsetY, null);
                } else {
                    g.drawImage(image, x + offsetX, y + offsetY, Math.round((float)tileWidth / ratio), Math.round((float)tileHeight / ratio), null);
                }
                image.flush();
                offsetX += Math.round((float)tileWidth / ratio);
                ++i;
            }
            offsetY += Math.round((float)tileHeight / ratio);
            ++j;
        }
    }

    public static void print(final ClassPane classPane) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat documentPageFormat = new PageFormat();
        documentPageFormat.setOrientation(0);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet(new PrintRequestAttribute[]{isPortrait ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE, new MediaPrintableArea(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 25400), new JobName("UDoc printing", Locale.ENGLISH)});
        Pageable pageable = new Pageable(){
            Point pageCount;

            public int getNumberOfPages() {
                if (this.pageCount == null) {
                    boolean isPortrait = PrintProcessing.isPortrait();
                    int fitType = PrintProcessing.getFitType();
                    float scalePercentage = PrintProcessing.getScalePercentage();
                    float horizontalPageFit = PrintProcessing.getHorizontalPageFit();
                    float verticalPageFit = PrintProcessing.getVerticalPageFit();
                    float pageFit = PrintProcessing.getPageFit();
                    this.pageCount = PrintProcessing.getPageCount(classPane, new PrintingAttributes(isPortrait, fitType, scalePercentage, pageFit, horizontalPageFit, verticalPageFit));
                }
                return this.pageCount.x * this.pageCount.y;
            }

            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                Paper paper = new Paper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                PageFormat pageFormat = new PageFormat();
                pageFormat.setPaper(paper);
                pageFormat.setOrientation(PrintProcessing.isPortrait() ? 1 : 0);
                return pageFormat;
            }

            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return new Printable(this, classPane){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ClassPane val$classPane;
                    {
                        this.this$1 = var1_1;
                        this.val$classPane = classPane;
                    }

                    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                        int x = pageIndex % this.this$1.pageCount.x;
                        int y = pageIndex / this.this$1.pageCount.x;
                        PrintProcessing.printPage(this.val$classPane, graphics, new Rectangle((int)Math.round(pageFormat.getImageableX()), (int)Math.round(pageFormat.getImageableY()), (int)Math.round(pageFormat.getImageableWidth()), (int)Math.round(pageFormat.getImageableHeight())), x, y, new PrintingAttributes(PrintProcessing.isPortrait(), PrintProcessing.getFitType(), PrintProcessing.getScalePercentage(), PrintProcessing.getPageFit(), PrintProcessing.getHorizontalPageFit(), PrintProcessing.getVerticalPageFit()), 0);
                        return 0;
                    }
                };
            }
        };
        printerJob.setPageable(pageable);
        if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.print.attribute.standard.OrientationRequested");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PrintProcessing.setPortrait((OrientationRequested)hashPrintRequestAttributeSet.get(clazz) == OrientationRequested.PORTRAIT);
            try {
                printerJob.print(hashPrintRequestAttributeSet);
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public static class PrintingAttributes {
        boolean isPortrait;
        int fitType;
        float scalePercentage;
        float pageFit;
        float horizontalPageFit;
        float verticalPageFit;

        public PrintingAttributes(boolean isPortrait, int fitType, float scalePercentage, float pageFit, float horizontalPageFit, float verticalPageFit) {
            this.isPortrait = isPortrait;
            this.fitType = fitType;
            this.scalePercentage = scalePercentage;
            this.pageFit = pageFit;
            this.horizontalPageFit = horizontalPageFit;
            this.verticalPageFit = verticalPageFit;
        }
    }
}

