/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.PackageInfo;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.widgets.ClassLink;
import chrriis.udoc.ui.widgets.ClassTooltip;
import chrriis.udoc.ui.widgets.FieldDeclarationComponent;
import chrriis.udoc.ui.widgets.FieldLink;
import chrriis.udoc.ui.widgets.FieldTooltip;
import chrriis.udoc.ui.widgets.MethodDeclarationComponent;
import chrriis.udoc.ui.widgets.MethodLink;
import chrriis.udoc.ui.widgets.MethodTooltip;
import chrriis.udoc.ui.widgets.PackageLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ClassComponent
extends JPanel {
    protected static final Color OUTER_BORDER_COLOR = new Color(167, 166, 174);
    protected static final Color OUTER_BACKGROUND_COLOR = new Color(239, 238, 254);
    protected static final Color OUTER_BACKGROUND_SELECTION_COLOR = new Color(255, 230, 245);
    protected static final Color CLASS_BORDER_COLOR = OUTER_BORDER_COLOR;
    protected static final Color CLASS_BACKGROUND_COLOR = new Color(218, 219, 255);
    protected static final Font PACKAGE_FONT = new Font("sans-serif", 0, 10);
    protected static final Font TITLE_FONT = new Font("sans-serif", 1, 12);
    protected ClassPane classPane;
    protected ClassInfo classInfo;
    protected JPanel packageComponent;
    protected JPanel centerPanel;
    protected MouseHandler moveMouseHandler = new MouseHandler();
    protected MouseHandler staticMouseHandler = new MouseHandler();
    protected InnerPanel innerPanel;
    protected JLabel showSuperTypesLabel;
    protected JLabel showSubTypesLabel;
    protected JLabel showCompositionsLabel;
    protected JLabel showAssociationsLabel;
    protected JPanel resizingPanel;
    protected Dimension expandedPreferredSize;
    protected Dimension collapsedPreferredSize;
    protected boolean isSelected;
    protected boolean areSuperTypesVisible;
    protected boolean areSubTypesVisible;
    protected boolean areCompositionsVisible;
    protected boolean areAssociationsVisible;
    protected volatile boolean isClassLoaded;

    public Dimension getExpandedPreferredSize() {
        return this.expandedPreferredSize;
    }

    public void setExpandedPreferredSize(Dimension expandedPreferredSize) {
        this.expandedPreferredSize = expandedPreferredSize;
    }

    public ClassComponent(ClassPane classPane, ClassInfo classInfo) {
        super(new BorderLayout(0, 0));
        this.classPane = classPane;
        this.classInfo = classInfo;
        this.setOpaque(false);
        JPanel northPanel = new JPanel(new FlowLayout(3, 0, 0));
        northPanel.setOpaque(false);
        this.packageComponent = new JPanel(new FlowLayout(3, 0, 0));
        this.packageComponent.add(new JLabel(IconManager.getIcon("package.gif")));
        PackageInfo packageInfo = classInfo.getPackage();
        PackageLink packageNameLabel = new PackageLink(this, packageInfo.getName(), packageInfo);
        packageNameLabel.setFont(PACKAGE_FONT);
        this.packageComponent.setBackground(OUTER_BACKGROUND_COLOR);
        this.packageComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, OUTER_BORDER_COLOR));
        this.packageComponent.add(packageNameLabel);
        northPanel.add(this.packageComponent);
        this.add((Component)northPanel, "North");
        GridBagLayout gridBag = new GridBagLayout();
        this.centerPanel = new JPanel(gridBag);
        this.centerPanel.setBackground(OUTER_BACKGROUND_COLOR);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 1;
        cons.gridy = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.fill = 1;
        this.centerPanel.setBorder(BorderFactory.createLineBorder(OUTER_BORDER_COLOR));
        this.innerPanel = new InnerPanel(classInfo);
        gridBag.setConstraints(this.innerPanel, cons);
        this.centerPanel.add(this.innerPanel);
        this.showSuperTypesLabel = new JLabel(){

            public Cursor getCursor() {
                if (ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return Cursor.getDefaultCursor();
                }
                return super.getCursor();
            }
        };
        this.showSuperTypesLabel.addMouseListener(this.staticMouseHandler);
        this.showSuperTypesLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.showSuperTypesLabel.setToolTipText("Super Types");
        this.showSuperTypesLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1 || ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return;
                }
                if (!ClassComponent.this.isClassLoaded || ClassComponent.this.classInfo.getSuperTypes().length != 0) {
                    ClassComponent.this.setRelationsVisible(!ClassComponent.this.areSuperTypesVisible, 1);
                }
            }
        });
        this.setSuperTypesIndication(false);
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        gridBag.setConstraints(this.showSuperTypesLabel, cons);
        this.centerPanel.add(this.showSuperTypesLabel);
        this.showSubTypesLabel = new JLabel(){

            public Cursor getCursor() {
                if (ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return Cursor.getDefaultCursor();
                }
                return super.getCursor();
            }
        };
        this.showSubTypesLabel.addMouseListener(this.staticMouseHandler);
        this.showSubTypesLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.showSubTypesLabel.setToolTipText("Sub Types");
        this.showSubTypesLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1 || ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return;
                }
                if (!ClassComponent.this.isClassLoaded || ClassComponent.this.classInfo.getSubTypes().length != 0) {
                    ClassComponent.this.setRelationsVisible(!ClassComponent.this.areSubTypesVisible, 2);
                }
            }
        });
        this.setSubTypesIndication(false);
        cons.gridy = 2;
        gridBag.setConstraints(this.showSubTypesLabel, cons);
        this.centerPanel.add(this.showSubTypesLabel);
        cons.gridy = 1;
        cons.gridx = 0;
        this.showCompositionsLabel = new JLabel(){

            public Cursor getCursor() {
                if (ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return Cursor.getDefaultCursor();
                }
                return super.getCursor();
            }
        };
        this.showCompositionsLabel.addMouseListener(this.staticMouseHandler);
        this.showCompositionsLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.showCompositionsLabel.setToolTipText("Compositions");
        this.showCompositionsLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1 || ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return;
                }
                if (!ClassComponent.this.isClassLoaded || ClassComponent.this.classInfo.getCompositions().length != 0) {
                    ClassComponent.this.setRelationsVisible(!ClassComponent.this.areCompositionsVisible, 3);
                }
            }
        });
        this.setCompositionsIndication(false);
        gridBag.setConstraints(this.showCompositionsLabel, cons);
        this.centerPanel.add(this.showCompositionsLabel);
        cons.gridx = 2;
        this.showAssociationsLabel = new JLabel(){

            public Cursor getCursor() {
                if (ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return Cursor.getDefaultCursor();
                }
                return super.getCursor();
            }
        };
        this.showAssociationsLabel.addMouseListener(this.staticMouseHandler);
        this.showAssociationsLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.showAssociationsLabel.setToolTipText("Associations");
        this.showAssociationsLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1 || ClassComponent.this.classPane.isLocked() && !ClassComponent.this.classInfo.isLoaded()) {
                    return;
                }
                if (!ClassComponent.this.isClassLoaded || ClassComponent.this.classInfo.getAssociations().length != 0) {
                    ClassComponent.this.setRelationsVisible(!ClassComponent.this.areAssociationsVisible, 4);
                }
            }
        });
        this.setAssociationsIndication(false);
        gridBag.setConstraints(this.showAssociationsLabel, cons);
        this.centerPanel.add(this.showAssociationsLabel);
        ++cons.gridy;
        cons.fill = 1;
        this.resizingPanel = new JPanel(null){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension size = this.getSize();
                int max = Math.max(size.width, size.height);
                g.setColor(OUTER_BORDER_COLOR);
                int i = 0;
                while (i < max) {
                    g.drawLine(max, i, i, max);
                    i += 2;
                }
            }
        };
        this.resizingPanel.setOpaque(false);
        this.resizingPanel.setVisible(false);
        this.resizingPanel.setCursor(Cursor.getPredefinedCursor(5));
        MouseInputAdapter resizingMouseEvent = new MouseInputAdapter(){
            protected Point location;

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Dimension size;
                    ClassComponent.this.expandedPreferredSize = size = ClassComponent.this.getPreferredSize();
                    ClassComponent.this.setSize(size);
                    ClassComponent.this.revalidate();
                    ClassComponent.this.classPane.adjustBounds();
                    ClassComponent.this.classPane.getClassComponentPane().repaint();
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                ClassComponent.this.processMousePressed(e);
                Point p = new Point(e.getPoint());
                this.location = SwingUtilities.convertPoint(ClassComponent.this.resizingPanel, p, ClassComponent.this.classPane);
            }

            public void mouseDragged(MouseEvent e) {
                if (this.location == null) {
                    return;
                }
                Dimension size = ClassComponent.this.getSize();
                Point p = new Point(e.getPoint());
                p = SwingUtilities.convertPoint(ClassComponent.this.resizingPanel, p, ClassComponent.this.classPane);
                size.width += p.x - this.location.x;
                size.height += p.y - this.location.y;
                if (size.width < ClassComponent.this.collapsedPreferredSize.width) {
                    p.x -= size.width - ClassComponent.this.collapsedPreferredSize.width;
                    size.width = ClassComponent.this.collapsedPreferredSize.width;
                }
                if (size.height < ClassComponent.this.collapsedPreferredSize.height) {
                    p.y -= size.height - ClassComponent.this.collapsedPreferredSize.height;
                    size.height = ClassComponent.this.collapsedPreferredSize.height;
                }
                this.location = p;
                ClassComponent.this.expandedPreferredSize = size;
                ClassComponent.this.setSize(size);
                ClassComponent.this.revalidate();
                ClassComponent.this.classPane.adjustBounds();
                ClassComponent.this.classPane.getClassComponentPane().repaint();
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                this.location = null;
            }
        };
        this.resizingPanel.addMouseMotionListener(resizingMouseEvent);
        this.resizingPanel.addMouseListener(resizingMouseEvent);
        gridBag.setConstraints(this.resizingPanel, cons);
        this.centerPanel.add(this.resizingPanel);
        this.add((Component)this.centerPanel, "Center");
        this.addMouseListener(this.moveMouseHandler);
        this.addMouseMotionListener(this.moveMouseHandler);
        this.collapsedPreferredSize = this.getPreferredSize();
        this.setSize(this.collapsedPreferredSize);
        if (classInfo.isLoaded()) {
            this.setClassLoaded();
        } else {
            this.autoLoad();
        }
    }

    protected void autoLoad() {
        if (this.classPane.isAutoLoading()) {
            new Thread(){

                public void run() {
                    if (!ClassComponent.this.classPane.isAutoLoading()) {
                        return;
                    }
                    ClassComponent.this.load();
                }
            }.start();
        }
    }

    protected void reload() {
        if (this.isReloadable()) {
            ClassInfo classInfo = this.getClassInfo();
            this.innerPanel.setClassLoading();
            classInfo.load(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassComponent.this.setClassLoaded();
                }
            });
        }
    }

    protected boolean isReloadable() {
        ClassInfo classInfo = this.getClassInfo();
        return classInfo.getLoadingState() != 2;
    }

    protected void load() {
        ClassInfo classInfo = this.getClassInfo();
        if (!classInfo.isLoaded()) {
            this.innerPanel.setClassLoading();
            classInfo.load(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassComponent.this.setClassLoaded();
                }
            });
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (isSelected) {
            this.packageComponent.setBackground(OUTER_BACKGROUND_SELECTION_COLOR);
            this.centerPanel.setBackground(OUTER_BACKGROUND_SELECTION_COLOR);
        } else {
            this.packageComponent.setBackground(OUTER_BACKGROUND_COLOR);
            this.centerPanel.setBackground(OUTER_BACKGROUND_COLOR);
        }
    }

    public void print(Graphics g) {
        boolean isSelected = this.isSelected();
        this.setSelected(false);
        boolean isResizingPanelVisible = this.resizingPanel.isVisible();
        this.resizingPanel.setVisible(false);
        super.print(g);
        this.setSelected(isSelected);
        this.resizingPanel.setVisible(isResizingPanelVisible);
    }

    protected boolean areSuperTypesVisible() {
        return this.areSuperTypesVisible;
    }

    protected void setSuperTypesIndication(boolean areSuperTypesVisible) {
        this.areSuperTypesVisible = areSuperTypesVisible;
        if (!this.isClassLoaded || this.classInfo.getSuperTypes().length != 0) {
            this.showSuperTypesLabel.setIcon(IconManager.getIcon(areSuperTypesVisible ? "super_types_on.gif" : "super_types_off.gif"));
        }
    }

    protected boolean areSubTypesVisible() {
        return this.areSubTypesVisible;
    }

    protected void setSubTypesIndication(boolean areSubTypesVisible) {
        this.areSubTypesVisible = areSubTypesVisible;
        this.showSubTypesLabel.setIcon(IconManager.getIcon(areSubTypesVisible ? "sub_types_on.gif" : "sub_types_off.gif"));
    }

    protected boolean areCompositionsVisible() {
        return this.areCompositionsVisible;
    }

    protected void setCompositionsIndication(boolean areCompositionsVisible) {
        this.areCompositionsVisible = areCompositionsVisible;
        this.showCompositionsLabel.setIcon(IconManager.getIcon(areCompositionsVisible ? "compositions_on.gif" : "compositions_off.gif"));
    }

    protected boolean areAssociationsVisible() {
        return this.areAssociationsVisible;
    }

    protected void setAssociationsIndication(boolean areAssociationsVisible) {
        this.areAssociationsVisible = areAssociationsVisible;
        this.showAssociationsLabel.setIcon(IconManager.getIcon(areAssociationsVisible ? "associations_on.gif" : "associations_off.gif"));
    }

    protected void setClassLoaded() {
        if (this.isClassLoaded) {
            return;
        }
        this.innerPanel.setClassLoaded();
        if (this.classInfo.getLoadingState() == 3) {
            return;
        }
        this.isClassLoaded = true;
        if (this.classInfo.getSuperTypes().length == 0) {
            this.showSuperTypesLabel.setIcon(IconManager.getIcon("super_types_none.gif"));
            this.showSuperTypesLabel.removeMouseListener(this.staticMouseHandler);
            this.showSuperTypesLabel.addMouseListener(this.moveMouseHandler);
            this.showSuperTypesLabel.addMouseMotionListener(this.moveMouseHandler);
            this.showSuperTypesLabel.setCursor(null);
            this.showSuperTypesLabel.setToolTipText(null);
        }
        if (this.classInfo.getSubTypes().length == 0) {
            this.showSubTypesLabel.setIcon(IconManager.getIcon("sub_types_none.gif"));
            this.showSubTypesLabel.removeMouseListener(this.staticMouseHandler);
            this.showSubTypesLabel.addMouseListener(this.moveMouseHandler);
            this.showSubTypesLabel.addMouseMotionListener(this.moveMouseHandler);
            this.showSubTypesLabel.setCursor(null);
            this.showSubTypesLabel.setToolTipText(null);
        }
        if (this.classInfo.getCompositions().length == 0) {
            this.showCompositionsLabel.setIcon(IconManager.getIcon("compositions_none.gif"));
            this.showCompositionsLabel.removeMouseListener(this.staticMouseHandler);
            this.showCompositionsLabel.addMouseListener(this.moveMouseHandler);
            this.showCompositionsLabel.addMouseMotionListener(this.moveMouseHandler);
            this.showCompositionsLabel.setCursor(null);
            this.showCompositionsLabel.setToolTipText(null);
        }
        if (this.classInfo.getAssociations().length == 0) {
            this.showAssociationsLabel.setIcon(IconManager.getIcon("associations_none.gif"));
            this.showAssociationsLabel.removeMouseListener(this.staticMouseHandler);
            this.showAssociationsLabel.addMouseListener(this.moveMouseHandler);
            this.showAssociationsLabel.addMouseMotionListener(this.moveMouseHandler);
            this.showAssociationsLabel.setCursor(null);
            this.showAssociationsLabel.setToolTipText(null);
        }
        this.resizingPanel.setVisible(this.innerPanel.isExpanded);
        this.collapsedPreferredSize = this.getPreferredSize();
        this.classPane.repaint();
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setExpanded(boolean isExpanded) {
        this.resizingPanel.setVisible(isExpanded && this.isClassLoaded && this.hasClassContent());
        this.innerPanel.setExpanded(isExpanded);
        this.innerPanel.setSize(this.innerPanel.getPreferredSize());
        this.setSize(this.expandedPreferredSize != null && isExpanded ? this.expandedPreferredSize : this.getPreferredSize());
        this.revalidate();
        this.repaint();
    }

    public boolean isExpanded() {
        return this.innerPanel.isExpanded();
    }

    public void updateFieldVisibility() {
        this.innerPanel.updateMembersPanel();
    }

    public void updateMethodVisibility() {
        this.innerPanel.updateMembersPanel();
    }

    public boolean contains(int x, int y) {
        if (this.packageComponent.contains(x, y)) {
            return true;
        }
        Point location = this.centerPanel.getLocation();
        return this.centerPanel.contains(x - location.x, y - location.y);
    }

    protected void processMousePressed(MouseEvent e) {
        this.classPane.closeMenus();
        ClassComponent classComponent = this;
        Container parent = classComponent.getParent();
        parent.setComponentZOrder(classComponent, 0);
        if ((e.getModifiers() & 2) != 0) {
            if (this.classPane.isClassComponentSelected(classComponent)) {
                this.classPane.removeSelectedClassComponent(classComponent);
            } else {
                this.classPane.addSelectedClassComponent(classComponent);
            }
        } else if (!this.classPane.isClassComponentSelected(classComponent)) {
            this.classPane.setSelectedClassComponent(classComponent);
        }
        this.classPane.repaint();
    }

    protected boolean hasClassContent() {
        return this.classInfo.getEnums().length != 0 || this.classInfo.getAnnotationMembers().length != 0 || this.classInfo.getFields().length != 0 || this.classInfo.getConstructors().length != 0 || this.classInfo.getMethods().length != 0;
    }

    public Point getCenter() {
        Rectangle bounds = this.innerPanel.getBounds();
        bounds = SwingUtilities.convertRectangle(this.innerPanel.getParent(), bounds, this.getParent());
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public Point getRelationPoint(Point p2) {
        Rectangle cBounds = this.centerPanel.getBounds();
        cBounds = SwingUtilities.convertRectangle(this.centerPanel.getParent(), cBounds, this.getParent());
        --cBounds.x;
        --cBounds.y;
        ++cBounds.width;
        ++cBounds.height;
        Point p1 = new Point(cBounds.x + cBounds.width / 2, cBounds.y + cBounds.height / 2);
        Rectangle pBounds = this.packageComponent.getBounds();
        pBounds = SwingUtilities.convertRectangle(this.packageComponent.getParent(), pBounds, this.getParent());
        --pBounds.x;
        --pBounds.y;
        ++pBounds.width;
        Point q1 = new Point(pBounds.x, pBounds.y);
        Point q2 = new Point(pBounds.x + pBounds.width, pBounds.y);
        Point q3 = new Point(pBounds.x + pBounds.width, pBounds.y + pBounds.height);
        Point q4 = new Point(pBounds.x + cBounds.width, pBounds.y + pBounds.height);
        Point q5 = new Point(pBounds.x + cBounds.width, cBounds.y + cBounds.height);
        Point q6 = new Point(pBounds.x, cBounds.y + cBounds.height);
        Point intersection = null;
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q1, q2);
        }
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q2, q3);
        }
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q3, q4);
        }
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q4, q5);
        }
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q5, q6);
        }
        if (intersection == null) {
            intersection = this.getIntersection(p1, p2, q6, q1);
        }
        return intersection;
    }

    protected Point getIntersection(Point p1, Point p2, Point p3, Point p4) {
        float uan = (p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x);
        if (uan == 0.0f) {
            return null;
        }
        float uad = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
        if (uad == 0.0f) {
            return null;
        }
        float ua = uan / uad;
        Point p = new Point(Math.round((float)p1.x + ua * (float)(p2.x - p1.x)), Math.round((float)p1.y + ua * (float)(p2.y - p1.y)));
        if (p.x < p1.x && p.x < p2.x || p.x < p3.x && p.x < p4.x || p.x > p1.x && p.x > p2.x || p.x > p3.x && p.x > p4.x || p.y < p1.y && p.y < p2.y || p.y < p3.y && p.y < p4.y || p.y > p1.y && p.y > p2.y || p.y > p3.y && p.y > p4.y) {
            return null;
        }
        return p;
    }

    protected void setRelationsVisible(boolean areRelationsVisible, final int relationType) {
        ClassInfo classInfo = this.getClassInfo();
        ClassInfo[] relatedClassInfos = null;
        switch (relationType) {
            case 1: {
                relatedClassInfos = classInfo.getSuperTypes();
                break;
            }
            case 2: {
                relatedClassInfos = classInfo.getSubTypes();
                break;
            }
            case 3: {
                relatedClassInfos = classInfo.getCompositions();
                break;
            }
            case 4: {
                relatedClassInfos = classInfo.getAssociations();
            }
        }
        if (classInfo.isLoaded() && relatedClassInfos.length == 0) {
            return;
        }
        switch (relationType) {
            case 1: {
                this.setSuperTypesIndication(areRelationsVisible);
                break;
            }
            case 2: {
                this.setSubTypesIndication(areRelationsVisible);
                break;
            }
            case 3: {
                this.setCompositionsIndication(areRelationsVisible);
                break;
            }
            case 4: {
                this.setAssociationsIndication(areRelationsVisible);
            }
        }
        if (!classInfo.isLoaded()) {
            if (!areRelationsVisible) {
                return;
            }
            new Thread(){

                public void run() {
                    ClassComponent.this.load();
                    SwingUtilities.invokeLater(new Runnable(this, relationType){
                        final /* synthetic */ 23 this$1;
                        private final /* synthetic */ int val$relationType;
                        {
                            this.this$1 = var1_1;
                            this.val$relationType = n;
                        }

                        public void run() {
                            switch (this.val$relationType) {
                                case 1: {
                                    if (!23.access$0(this.this$1).areSuperTypesVisible()) break;
                                    23.access$0(this.this$1).setRelationsVisible(true, this.val$relationType);
                                    break;
                                }
                                case 2: {
                                    if (!23.access$0(this.this$1).areSubTypesVisible()) break;
                                    23.access$0(this.this$1).setRelationsVisible(true, this.val$relationType);
                                    break;
                                }
                                case 3: {
                                    if (!23.access$0(this.this$1).areCompositionsVisible()) break;
                                    23.access$0(this.this$1).setRelationsVisible(true, this.val$relationType);
                                    break;
                                }
                                case 4: {
                                    if (!23.access$0(this.this$1).areAssociationsVisible()) break;
                                    23.access$0(this.this$1).setRelationsVisible(true, this.val$relationType);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ ClassComponent access$0(23 var0) {
                    return var0.ClassComponent.this;
                }
            }.start();
            return;
        }
        if (this.classPane.isClassComponentPresent(classInfo)) {
            this.classPane.setRelationsVisible(this, relatedClassInfos, areRelationsVisible, relationType);
        }
    }

    public void openPackage(PackageInfo packageInfo) {
        try {
            this.classInfo.getClassProcessor().openPackage(packageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openClass(ClassInfo classInfo) {
        try {
            classInfo.getClassProcessor().openClass(classInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openMethod(MethodInfo methodInfo) {
        try {
            this.classInfo.getClassProcessor().openMethod(methodInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openField(FieldInfo fieldInfo) {
        try {
            this.classInfo.getClassProcessor().openField(fieldInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        protected Point referenceLocation;

        MouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.referenceLocation == null) {
                return;
            }
            ClassComponent.this.classPane.moveSelectedClassComponent(ClassComponent.this, e.getX() - this.referenceLocation.x, e.getY() - this.referenceLocation.y);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.referenceLocation = e.getPoint();
            ClassComponent.this.processMousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.referenceLocation = null;
            if ((e.getModifiers() & 0xC) != 0) {
                return;
            }
            this.showTooltip(e, true);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (ClassComponent.this.isSelected && (e.getModifiers() & 2) == 0) {
                ClassComponent.this.classPane.setSelectedClassComponent(ClassComponent.this);
            }
            this.showTooltip(e, false);
        }

        public void mouseExited(MouseEvent e) {
            ClassComponent.this.classPane.hideTooltip();
        }

        protected void showTooltip(MouseEvent e, boolean isForced) {
            if (!isForced && (e.getModifiers() & 0x1C) != 0) {
                return;
            }
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ClassComponent.this);
            Component component = ClassComponent.this.findComponentAt(p);
            if (component != null && component != ClassComponent.this) {
                FieldLink fieldLink;
                FieldInfo fieldInfo;
                String prototype;
                if (component instanceof ClassLink) {
                    String prototype2;
                    ClassLink classLink = (ClassLink)component;
                    ClassInfo classInfo = classLink.getClassInfo();
                    if (classInfo.isLoaded() && (prototype2 = classInfo.getPrototype()) != null) {
                        ClassTooltip tooltip = new ClassTooltip(classInfo);
                        ClassComponent.this.classPane.showTooltip(tooltip, classLink, (classLink.getWidth() - tooltip.getPreferredSize().width) / 2, classLink.getHeight() + 20);
                    }
                } else if (component instanceof MethodLink) {
                    MethodLink methodLink = (MethodLink)component;
                    MethodInfo methodInfo = methodLink.getMethodInfo();
                    String prototype3 = methodInfo.getPrototype();
                    if (prototype3 != null) {
                        MethodTooltip tooltip = new MethodTooltip(methodInfo);
                        ClassComponent.this.classPane.showTooltip(tooltip, methodLink, (methodLink.getWidth() - tooltip.getPreferredSize().width) / 2, methodLink.getHeight() + 20);
                    }
                } else if (component instanceof FieldLink && (prototype = (fieldInfo = (fieldLink = (FieldLink)component).getFieldInfo()).getPrototype()) != null) {
                    FieldTooltip tooltip = new FieldTooltip(fieldInfo);
                    ClassComponent.this.classPane.showTooltip(tooltip, fieldLink, (fieldLink.getWidth() - tooltip.getPreferredSize().width) / 2, fieldLink.getHeight() + 20);
                }
            }
        }
    }

    class InnerPanel
    extends JPanel {
        protected ClassInfo classInfo;
        protected JLabel titleLabel;
        protected JLabel expandLabel;
        protected JPanel centerPanel;
        protected JPanel membersPanel;
        protected boolean isExpanded;

        public InnerPanel(ClassInfo classInfo) {
            super(new BorderLayout(0, 0));
            this.classInfo = classInfo;
            this.setOpaque(true);
            this.setBackground(CLASS_BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createLineBorder(CLASS_BORDER_COLOR));
            JPanel northPanel = new JPanel(new BorderLayout(0, 0));
            northPanel.setBackground(CLASS_BACKGROUND_COLOR);
            JPanel titlePanel = new JPanel(new FlowLayout(1, 0, 0));
            titlePanel.setBackground(CLASS_BACKGROUND_COLOR);
            this.expandLabel = new JLabel(this, IconManager.getIcon("expand.gif")){
                final /* synthetic */ InnerPanel this$1;
                {
                    this.this$1 = innerPanel;
                }

                public boolean isVisible() {
                    if (InnerPanel.access$0((InnerPanel)this.this$1).classPane.isLocked() && !this.this$1.classInfo.isLoaded()) {
                        return false;
                    }
                    return super.isVisible();
                }
            };
            this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.expandLabel.addMouseListener(ClassComponent.this.staticMouseHandler);
            this.expandLabel.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ InnerPanel this$1;
                {
                    this.this$1 = innerPanel;
                }

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1 || InnerPanel.access$0((InnerPanel)this.this$1).classPane.isLocked() && !this.this$1.classInfo.isLoaded()) {
                        return;
                    }
                    InnerPanel.access$0(this.this$1).setExpanded(!this.this$1.isExpanded);
                }
            });
            northPanel.add((Component)this.expandLabel, "West");
            this.titleLabel = new JLabel(IconManager.getIcon(0x40000 | classInfo.getModifiers()));
            this.titleLabel.setFont(TITLE_FONT);
            titlePanel.add(this.titleLabel);
            titlePanel.add(new ClassLink(ClassComponent.this, classInfo.getName(), classInfo));
            northPanel.add((Component)titlePanel, "Center");
            this.add((Component)northPanel, "North");
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            if (!ClassComponent.this.hasClassContent() && (ClassComponent.this.isClassLoaded || (this.classInfo.getModifiers() & 0x100000) != 0)) {
                isExpanded = false;
            }
            this.expandLabel.setIcon(isExpanded ? IconManager.getIcon("collapse.gif") : IconManager.getIcon("expand.gif"));
            if (this.isExpanded == isExpanded) {
                return;
            }
            if (this.centerPanel != null) {
                this.isExpanded = isExpanded;
                this.centerPanel.setVisible(isExpanded);
                ClassComponent.this.classPane.setDevelopped(ClassComponent.this, isExpanded);
                return;
            }
            if (!isExpanded) {
                this.isExpanded = isExpanded;
                ClassComponent.this.classPane.setDevelopped(ClassComponent.this, isExpanded);
                return;
            }
            this.isExpanded = isExpanded;
            if (!this.classInfo.isLoaded()) {
                new Thread(this){
                    final /* synthetic */ InnerPanel this$1;
                    {
                        this.this$1 = innerPanel;
                    }

                    public void run() {
                        InnerPanel.access$0(this.this$1).load();
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                if (3.access$0(this.this$2).isExpanded) {
                                    3.access$0(this.this$2).isExpanded = false;
                                    InnerPanel.access$0(3.access$0(this.this$2)).setExpanded(true);
                                }
                            }
                        });
                    }

                    static /* synthetic */ InnerPanel access$0(3 var0) {
                        return var0.this$1;
                    }
                }.start();
                return;
            }
            this.centerPanel = new JPanel(new BorderLayout(0, 0));
            this.centerPanel.setBackground(CLASS_BACKGROUND_COLOR);
            this.updateMembersPanel();
            JScrollPane scrollPane = new JScrollPane(this, this.membersPanel){
                final /* synthetic */ InnerPanel this$1;
                {
                    this.this$1 = innerPanel;
                }

                public Dimension getPreferredSize() {
                    Dimension size = this.getViewport().getView().getPreferredSize();
                    ++size.height;
                    Dimension preferredSize = new Dimension(Math.min(200, size.width), Math.min(200, size.height));
                    if (size.height < 200 && size.width > 200) {
                        preferredSize.height += this.getHorizontalScrollBar().getPreferredSize().height;
                    }
                    if (size.width < 200 && size.height > 200) {
                        preferredSize.width += this.getVerticalScrollBar().getPreferredSize().width;
                    }
                    return preferredSize;
                }
            };
            JViewport viewport = scrollPane.getViewport();
            viewport.addMouseListener(ClassComponent.this.moveMouseHandler);
            viewport.addMouseMotionListener(ClassComponent.this.moveMouseHandler);
            scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, CLASS_BORDER_COLOR));
            this.centerPanel.add((Component)scrollPane, "Center");
            this.add((Component)this.centerPanel, "Center");
            ClassComponent.this.classPane.setDevelopped(ClassComponent.this, isExpanded);
        }

        protected FieldInfo[] filterFieldInfos(FieldInfo[] fieldInfos, int visibility) {
            if (visibility == 4) {
                return fieldInfos;
            }
            ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>(fieldInfos.length);
            int i = 0;
            while (i < fieldInfos.length) {
                FieldInfo fieldInfo = fieldInfos[i];
                int modifiers = fieldInfo.getModifiers();
                switch (visibility) {
                    case 1: {
                        if ((modifiers & 1) == 0) break;
                        fieldInfoList.add(fieldInfo);
                        break;
                    }
                    case 2: {
                        if ((modifiers & 3) == 0) break;
                        fieldInfoList.add(fieldInfo);
                        break;
                    }
                    case 3: {
                        if ((modifiers & 7) == 0) break;
                        fieldInfoList.add(fieldInfo);
                    }
                }
                ++i;
            }
            return fieldInfoList.toArray(new FieldInfo[0]);
        }

        protected MethodInfo[] filterMethodInfos(MethodInfo[] methodInfos, int visibility) {
            if (visibility == 4) {
                return methodInfos;
            }
            ArrayList<MethodInfo> methodInfoList = new ArrayList<MethodInfo>(methodInfos.length);
            int i = 0;
            while (i < methodInfos.length) {
                MethodInfo methodInfo = methodInfos[i];
                int modifiers = methodInfo.getModifiers();
                switch (visibility) {
                    case 1: {
                        if ((modifiers & 1) == 0) break;
                        methodInfoList.add(methodInfo);
                        break;
                    }
                    case 2: {
                        if ((modifiers & 3) == 0) break;
                        methodInfoList.add(methodInfo);
                        break;
                    }
                    case 3: {
                        if ((modifiers & 7) == 0) break;
                        methodInfoList.add(methodInfo);
                    }
                }
                ++i;
            }
            return methodInfoList.toArray(new MethodInfo[0]);
        }

        public void updateMembersPanel() {
            int fieldVisibility = ClassComponent.this.classPane.getFieldVisibility();
            FieldInfo[] enums = this.filterFieldInfos(this.classInfo.getEnums(), fieldVisibility);
            FieldInfo[] fields = this.filterFieldInfos(this.classInfo.getFields(), fieldVisibility);
            int methodVisibility = ClassComponent.this.classPane.getMethodVisibility();
            MethodInfo[] constructors = this.filterMethodInfos(this.classInfo.getConstructors(), methodVisibility);
            MethodInfo[] methods = this.filterMethodInfos(this.classInfo.getMethods(), methodVisibility);
            MethodInfo[] annotationMembers = this.filterMethodInfos(this.classInfo.getAnnotationMembers(), methodVisibility);
            if (this.membersPanel == null) {
                class MembersPanel
                extends JPanel
                implements Scrollable {
                    final /* synthetic */ InnerPanel this$1;

                    MembersPanel(InnerPanel innerPanel) {
                        this.this$1 = innerPanel;
                    }

                    public Dimension getPreferredScrollableViewportSize() {
                        Dimension preferredSize = this.getPreferredSize();
                        if (this.getComponentCount() > 0) {
                            preferredSize.height = this.getComponent((int)0).getPreferredSize().height * 3;
                        }
                        return preferredSize;
                    }

                    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                        if (this.getComponentCount() > 0) {
                            return this.getComponent((int)0).getSize().height;
                        }
                        return 0;
                    }

                    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                        if (this.getComponentCount() > 0) {
                            return this.getComponent((int)0).getSize().height * 3;
                        }
                        return 0;
                    }

                    public boolean getScrollableTracksViewportWidth() {
                        return this.getPreferredSize().width < this.getParent().getWidth();
                    }

                    public boolean getScrollableTracksViewportHeight() {
                        return this.getPreferredSize().height < this.getParent().getHeight();
                    }
                }
                this.membersPanel = new MembersPanel(this);
                BoxLayout boxLayout = new BoxLayout(this.membersPanel, 1);
                this.membersPanel.setLayout(boxLayout);
            } else {
                this.membersPanel.removeAll();
            }
            this.membersPanel.setBackground(CLASS_BACKGROUND_COLOR);
            boolean hasAdded = false;
            int i = 0;
            while (i < enums.length) {
                this.membersPanel.add(new FieldDeclarationComponent(ClassComponent.this, this.classInfo, enums[i]));
                hasAdded = true;
                ++i;
            }
            if (fields.length > 0) {
                if (hasAdded) {
                    this.membersPanel.add(new JSeparator(this, 0){
                        final /* synthetic */ InnerPanel this$1;
                        {
                            this.this$1 = innerPanel;
                        }

                        public Dimension getMaximumSize() {
                            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
                        }
                    });
                    hasAdded = false;
                }
                i = 0;
                while (i < fields.length) {
                    this.membersPanel.add(new FieldDeclarationComponent(ClassComponent.this, this.classInfo, fields[i]));
                    hasAdded = true;
                    ++i;
                }
            }
            if (constructors.length > 0) {
                if (hasAdded) {
                    this.membersPanel.add(new JSeparator(this, 0){
                        final /* synthetic */ InnerPanel this$1;
                        {
                            this.this$1 = innerPanel;
                        }

                        public Dimension getMaximumSize() {
                            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
                        }
                    });
                    hasAdded = false;
                }
                i = 0;
                while (i < constructors.length) {
                    this.membersPanel.add(new MethodDeclarationComponent(ClassComponent.this, this.classInfo, constructors[i]));
                    hasAdded = true;
                    ++i;
                }
            }
            if (methods.length > 0) {
                if (hasAdded) {
                    this.membersPanel.add(new JSeparator(this, 0){
                        final /* synthetic */ InnerPanel this$1;
                        {
                            this.this$1 = innerPanel;
                        }

                        public Dimension getMaximumSize() {
                            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
                        }
                    });
                    hasAdded = false;
                }
                i = 0;
                while (i < methods.length) {
                    this.membersPanel.add(new MethodDeclarationComponent(ClassComponent.this, this.classInfo, methods[i]));
                    hasAdded = true;
                    ++i;
                }
            }
            if (annotationMembers.length > 0) {
                if (hasAdded) {
                    this.membersPanel.add(new JSeparator(this, 0){
                        final /* synthetic */ InnerPanel this$1;
                        {
                            this.this$1 = innerPanel;
                        }

                        public Dimension getMaximumSize() {
                            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
                        }
                    });
                    hasAdded = false;
                }
                i = 0;
                while (i < annotationMembers.length) {
                    this.membersPanel.add(new MethodDeclarationComponent(ClassComponent.this, this.classInfo, annotationMembers[i]));
                    hasAdded = true;
                    ++i;
                }
            }
            this.membersPanel.add(Box.createVerticalGlue());
            this.membersPanel.revalidate();
            this.membersPanel.repaint();
        }

        public void setClassLoaded() {
            boolean hasFailed;
            int modifiers = 0;
            boolean bl = hasFailed = this.classInfo.getLoadingState() == 3;
            if (hasFailed) {
                modifiers |= 0x100000;
            }
            this.titleLabel.setIcon(IconManager.getIcon(modifiers | this.classInfo.getModifiers()));
            if (!hasFailed && !ClassComponent.this.hasClassContent()) {
                ClassComponent.this.setExpanded(false);
                this.expandLabel.setVisible(false);
            }
        }

        public void setClassLoading() {
            this.titleLabel.setIcon(IconManager.getIcon(0x80000 | this.classInfo.getModifiers() & 0xFFEFFFFF));
        }

        static /* synthetic */ ClassComponent access$0(InnerPanel innerPanel) {
            return innerPanel.ClassComponent.this;
        }
    }
}

