/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.util.Vector;
import yoyo.CompoundSymbol;
import yoyo.Ilist;
import yoyo.Symbol;
import yoyo.Tokenizer;

public class Reader {
    public static Object[] read(String string) {
        Tokenizer tokenizer = new Tokenizer(string);
        Vector vector = tokenizer.tokenize();
        return Reader.readUntil(vector, "");
    }

    public static Object[] readUntil(Vector vector, String string) {
        Vector<Object> vector2 = new Vector<Object>();
        while (!vector.isEmpty()) {
            if (Reader.peek(vector).equals(string)) {
                Reader.skip(vector);
                break;
            }
            vector2.addElement(Reader.readTokenOrCompound(vector));
        }
        Object[] objectArray = new Object[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public static Object readTokenOrCompound(Vector vector) {
        Object object = Reader.readToken(vector);
        if (Reader.peek(vector).equals(".")) {
            return Reader.gatherParts(vector, object);
        }
        return object;
    }

    public static Object readToken(Vector vector) {
        if (Reader.peek(vector).equals("[")) {
            Reader.skip(vector);
            return Reader.readUntil(vector, "]");
        }
        if (Reader.peek(vector).equals("(")) {
            Reader.skip(vector);
            return new Ilist(Reader.readUntil(vector, ")"));
        }
        return Reader.readString(Reader.next(vector));
    }

    public static CompoundSymbol gatherParts(Vector vector, Object object) {
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(object);
        while (Reader.peek(vector).equals(".")) {
            Reader.skip(vector);
            vector2.addElement(Reader.readToken(vector));
        }
        return new CompoundSymbol(vector2);
    }

    public static Object readString(String string) {
        if (string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        if (string.charAt(0) == '-' && string.length() == 1) {
            return Symbol.lookup("-");
        }
        try {
            if (string.charAt(0) == '$' && string.length() > 1) {
                return new Integer(Integer.parseInt(string.substring(1, string.length()), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Reader.possibleNumberp(string)) {
            try {
                return new Integer(string);
            }
            catch (Exception exception) {
                try {
                    return new Double(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return Symbol.lookup(string);
    }

    public static boolean possibleNumberp(String string) {
        int n = 0;
        while (n < string.length()) {
            if ("eE.+-0123456789".indexOf(string.charAt(n)) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String next(Vector vector) {
        if (vector.isEmpty()) {
            return "";
        }
        Object e = vector.firstElement();
        vector.removeElementAt(0);
        return (String)e;
    }

    public static String peek(Vector vector) {
        if (vector.isEmpty()) {
            return "";
        }
        Object e = vector.firstElement();
        return (String)e;
    }

    public static void skip(Vector vector) {
        vector.removeElementAt(0);
    }
}

