/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.util.Random;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.Primitive;
import yoyo.Reader;
import yoyo.Symbol;
import yoyo.YoYo;
import yoyo.YoYoMethods;

public class PrimMath
implements YoYoMethods {
    static Random random = new Random();

    public String[] methodList() {
        String[] stringArray = new String[]{"sum", "prim_sum", "rem", "prim_rem", "difference", "prim_sub", "product", "prim_mul", "quotient", "prim_div", "power", "prim_power", "greater?", "prim_greater", "less?", "prim_less", "minus", "prim_sub", "rsh", "prim_rsh", "lsh", "prim_lsh", "bitneg", "prim_bitneg", "min", "prim_min", "max", "prim_max", "random", "prim_random", "sin", "prim_sin", "cos", "prim_cos", "tan", "prim_tan", "atan", "prim_atan", "acos", "prim_acos", "asin", "prim_asin", "exp", "prim_exp", "ln", "prim_ln", "int", "prim_int", "round", "prim_round", "abs", "prim_abs", "number?", "prim_numberp", "sqrt", "prim_sqrt", "string-to-number", "prim_ston", "not", "prim_not", "string-is-number?", "prim_stnum"};
        return stringArray;
    }

    public String[] infixList() {
        String[] stringArray = new String[]{"+", "prim_sum", "-3", "*", "prim_mul", "-4", "-", "prim_sub", "-3", "/", "prim_div", "-4", "<=", "prim_lessequal", "-2", ">=", "prim_greaterequal", "-2", ">", "prim_greater", "-2", "<", "prim_less", "-2", "^", "prim_power", "-5", "mod", "prim_mod", "-4", "bitand", "prim_bitand", "-6", "bitor", "prim_bitor", "-6", "bitxor", "prim_bitxor", "-6", "=", "prim_equal", "-2", "!=", "prim_notequal", "-2", "and", "prim_and", "-1", "or", "prim_or", "-1"};
        return stringArray;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static Object prim_sum(Object object, Object object2, Context context) {
        return new Double(YoYo.aDouble(context, object) + YoYo.aDouble(context, object2));
    }

    public static Object prim_sub(Object object, Object object2, Context context) {
        return new Double(YoYo.aDouble(context, object) - YoYo.aDouble(context, object2));
    }

    public static Object prim_mul(Object object, Object object2, Context context) {
        return new Double(YoYo.aDouble(context, object) * YoYo.aDouble(context, object2));
    }

    public static Object prim_div(Object object, Object object2, Context context) {
        return new Double(YoYo.aDouble(context, object) / YoYo.aDouble(context, object2));
    }

    public static Object prim_mod(Object object, Object object2, Context context) {
        double d = YoYo.aDouble(context, object2);
        double d2 = YoYo.aDouble(context, object) % d;
        if (d2 < 0.0) {
            return new Double(d2 + d);
        }
        return new Double(d2);
    }

    public static Object prim_power(Object object, Object object2, Context context) {
        return new Double(Math.pow(YoYo.aDouble(context, object), YoYo.aDouble(context, object2)));
    }

    public static Object prim_less(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) < YoYo.aDouble(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_greater(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) > YoYo.aDouble(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_lessequal(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) <= YoYo.aDouble(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_greaterequal(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) >= YoYo.aDouble(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_rsh(Object object, Object object2, Context context) {
        return new Integer(YoYo.aInteger(context, object) >> YoYo.aInteger(context, object2));
    }

    public static Object prim_lsh(Object object, Object object2, Context context) {
        return new Integer(YoYo.aInteger(context, object) << YoYo.aInteger(context, object2));
    }

    public static Object prim_bitand(Object object, Object object2, Context context) {
        return new Integer(YoYo.aInteger(context, object) & YoYo.aInteger(context, object2));
    }

    public static Object prim_bitor(Object object, Object object2, Context context) {
        return new Integer(YoYo.aInteger(context, object) | YoYo.aInteger(context, object2));
    }

    public static Object prim_bitxor(Object object, Object object2, Context context) {
        return new Integer(YoYo.aInteger(context, object) ^ YoYo.aInteger(context, object2));
    }

    public static Object prim_bitneg(Object object, Context context) {
        return new Integer(~YoYo.aInteger(context, object));
    }

    public static Object prim_min(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) < YoYo.aDouble(context, object2)) {
            return object;
        }
        return object2;
    }

    public static Object prim_max(Object object, Object object2, Context context) {
        if (YoYo.aDouble(context, object) > YoYo.aDouble(context, object2)) {
            return object;
        }
        return object2;
    }

    public static Object prim_random(Object object, Context context) {
        return new Integer((int)Math.floor(random.nextDouble() * (double)YoYo.aInteger(context, object)));
    }

    public static double deg2Rad(double d) {
        return d % 360.0 / 180.0 * Math.PI;
    }

    public static double rad2Deg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static Object prim_sin(Object object, Context context) {
        return new Double(Math.sin(PrimMath.deg2Rad(YoYo.aDouble(context, object))));
    }

    public static Object prim_cos(Object object, Context context) {
        return new Double(Math.cos(PrimMath.deg2Rad(YoYo.aDouble(context, object))));
    }

    public static Object prim_tan(Object object, Context context) {
        return new Double(Math.tan(PrimMath.deg2Rad(YoYo.aDouble(context, object))));
    }

    public static Object prim_atan(Object object, Object object2, Context context) {
        return new Double(PrimMath.rad2Deg(Math.atan(YoYo.aDouble(context, object) / YoYo.aDouble(context, object2))));
    }

    public static Object prim_asin(Object object, Context context) {
        return new Double(PrimMath.rad2Deg(Math.asin(YoYo.aDouble(context, object))));
    }

    public static Object prim_acos(Object object, Context context) {
        return new Double(PrimMath.rad2Deg(Math.acos(YoYo.aDouble(context, object))));
    }

    public static Object prim_exp(Object object, Context context) {
        return new Double(Math.exp(YoYo.aDouble(context, object)));
    }

    public static Object prim_ln(Object object, Context context) {
        return new Double(Math.log(YoYo.aDouble(context, object)));
    }

    public static Object prim_int(Object object, Context context) {
        return new Double(YoYo.aInteger(context, object));
    }

    public static Object prim_round(Object object, Context context) {
        return new Double(Math.round(YoYo.aDouble(context, object)));
    }

    public static Object prim_abs(Object object, Context context) {
        double d = YoYo.aDouble(context, object);
        if (d < 0.0) {
            return new Double(-d);
        }
        return object;
    }

    public static Object prim_numberp(Object object, Context context) {
        if (object instanceof Number) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_equal(Object object, Object object2, Context context) {
        return YoYo.equal(object, object2);
    }

    public static Object prim_notequal(Object object, Object object2, Context context) {
        return YoYo.equal(object, object2) == YoYo.symtrue ? YoYo.symfalse : YoYo.symtrue;
    }

    public static Symbol truefalse(boolean bl) {
        return bl ? YoYo.symtrue : YoYo.symfalse;
    }

    public static Object prim_and(Object object, Object object2, Context context) {
        if (YoYo.aBoolean(context, object) && YoYo.aBoolean(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_or(Object object, Object object2, Context context) {
        if (YoYo.aBoolean(context, object) || YoYo.aBoolean(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_xor(Object object, Object object2, Context context) {
        if (YoYo.aBoolean(context, object) ^ YoYo.aBoolean(context, object2)) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_sqrt(Object object, Context context) {
        return new Double(Math.sqrt(YoYo.aDouble(context, object)));
    }

    public static Object prim_ston(Object object, Context context) {
        String string = YoYo.aString(context, object);
        Object[] objectArray = Reader.read(string);
        if (objectArray.length > 0 && objectArray[0] instanceof Number) {
            return objectArray[0];
        }
        LogoError.error(string + " is not a number", context);
        return null;
    }

    public static Object prim_stnum(Object object, Context context) {
        String string = YoYo.aString(context, object);
        Object[] objectArray = Reader.read(string);
        if (objectArray.length > 0 && objectArray[0] instanceof Number) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }
}

