/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import yoyo.CompoundSymbol;
import yoyo.Context;
import yoyo.Ilist;
import yoyo.LocalRef;
import yoyo.LogoError;
import yoyo.Primitive;
import yoyo.Reader;
import yoyo.Symbol;
import yoyo.Ufun;
import yoyo.YoYo;
import yoyo.YoYoMethods;
import yoyo.YoYoObject;

public class PrimFile
implements YoYoMethods {
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    static Symbol letsym = Symbol.lookup("let");
    static Symbol dolist = Symbol.lookup("dolist");
    static Symbol dotimes = Symbol.lookup("dotimes");
    static Symbol set = Symbol.lookup("set");
    static Symbol lambda = Symbol.lookup("lambda");
    static Symbol repeat = Symbol.lookup("repeat");

    public String[] methodList() {
        String[] stringArray = new String[]{"load-yoyo", "prim_load", "load-yoyo-verbose", "prim_load_verbose", "load-yoyo-from-string", "prim_load_from_string", "load-yoyo-from-string-verbose", "prim_load_from_string_verbose", "launch-process", "prim_launch_process", "read-file-to-string", "prim_filetostring", "write-string-to-file", "prim_stringtofile", "read-url-to-string", "prim_urltostring", "home-directory", "prim_home_dir", "list-files", "prim_ls", "file?", "prim_filep", "directory?", "prim_dirp", "file-date", "prim_filedate", "file-readable?", "prim_filereadp", "file-writeable?", "prim_filewritep", "file-rename", "prim_rename", "make-directory", "prim_mkdir", "url?", "prim_urlp", "file-canonical-path", "prim_canonpath", "make-resource-url", "prim_makeresourceurl"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static Object prim_canonpath(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                if (!file.exists()) {
                    LogoError.error(YoYo.printToString(object) + " does not exist", context);
                }
                try {
                    return new URL("file", "/" + file.getCanonicalPath(), "");
                }
                catch (IOException iOException) {
                    LogoError.error("Could not determine canonical path for " + YoYo.printToString(object), context);
                }
            } else {
                LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_urlp(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            return YoYo.symtrue;
        }
        catch (MalformedURLException malformedURLException) {
            return YoYo.symfalse;
        }
    }

    public static Object prim_rename(Object object, Object object2, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            URL uRL2 = new URL(YoYo.aString(context, object2));
            if (uRL.getProtocol().equals("file") && uRL2.getProtocol().equals("file")) {
                boolean bl;
                String string = uRL.getFile();
                String string2 = uRL.getFile();
                File file = new File(string);
                File file2 = new File(string2);
                if (!file.exists()) {
                    LogoError.error(YoYo.printToString(object) + " does not exist", context);
                }
                if (!(bl = file.renameTo(file2))) {
                    LogoError.error("could not rename file " + YoYo.printToString(object), context);
                }
                return null;
            }
            LogoError.error(YoYo.printToString(object) + " and " + YoYo.printToString(object2) + " must both be file URLs", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("Either " + YoYo.printToString(object) + " or " + YoYo.printToString(object2) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_mkdir(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                boolean bl;
                String string = uRL.getFile();
                File file = new File(string);
                if (file.exists()) {
                    LogoError.error(YoYo.printToString(object) + " already exists", context);
                }
                if (!(bl = file.mkdirs())) {
                    LogoError.error("could not create directory " + YoYo.printToString(object), context);
                }
                return null;
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_file_writep(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                return file.canWrite() ? YoYo.symtrue : YoYo.symfalse;
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_file_readp(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                return file.canRead() ? YoYo.symtrue : YoYo.symfalse;
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static void prim_launch_process(Object object, Context context) {
        if (YoYo.applet != null) {
            return;
        }
        Object[] objectArray = YoYo.aList(context, object);
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = YoYo.printToString(objectArray[n]);
            ++n;
        }
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("Couldn't launch the process: " + YoYo.printToString(object), context);
        }
    }

    public static Object prim_filedate(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                return sdf.format(new Date(file.lastModified()));
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_dirp(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                return file.isDirectory() ? YoYo.symtrue : YoYo.symfalse;
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_filep(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                return file.isFile() ? YoYo.symtrue : YoYo.symfalse;
            }
            LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_ls(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                if (file.isDirectory()) {
                    String[] stringArray = file.list();
                    return stringArray;
                }
                LogoError.error(YoYo.printToString(object) + " must be a directory", context);
            } else {
                LogoError.error(YoYo.printToString(object) + " must be a file URL", context);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error(YoYo.printToString(object) + " is a bad URL", context);
        }
        return null;
    }

    public static Object prim_home_dir(Context context) {
        return context.base.toString();
    }

    public static Object prim_stringtofile(Object object, Object object2, Context context) {
        try {
            if (YoYo.applet != null) {
                LogoError.error("Sorry, can't write to a file from an applet", context);
            }
            String string = YoYo.aString(context, object);
            String string2 = YoYo.aString(context, object2);
            File file = new File(string2);
            if (!file.canWrite()) {
                LogoError.error("Sorry, you can't write to this file", context);
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            LogoError.error("Problem writing file", context);
        }
        return null;
    }

    public static Object prim_filetostring(Object object, Context context) {
        if (YoYo.applet == null) {
            String string = YoYo.aString(context, object);
            Object var3_4 = null;
            Object var4_6 = null;
            try {
                File file = new File(string);
                if (!file.canRead()) {
                    LogoError.error(YoYo.printToString(object) + " is not readable");
                }
                FileReader fileReader = new FileReader(file);
                return PrimFile.readStream(fileReader, (int)file.length(), context);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogoError.error(fileNotFoundException.getMessage(), context);
                return null;
            }
        }
        String string = "./" + YoYo.aString(context, object);
        try {
            return PrimFile.prim_urltostring(new URL(context.base, string), context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("url does not exist", context);
            return null;
        }
    }

    public static Object prim_filetobytes(Object object, Context context) {
        if (YoYo.applet == null) {
            String string = YoYo.aString(context, object);
            Object var3_4 = null;
            Object var4_6 = null;
            try {
                File file = new File(string);
                if (!file.canRead()) {
                    LogoError.error(YoYo.printToString(object) + " is not readable");
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                return PrimFile.readStream(fileInputStream, (int)file.length(), context);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogoError.error(fileNotFoundException.getMessage(), context);
                return null;
            }
        }
        String string = "./" + YoYo.aString(context, object);
        try {
            return PrimFile.prim_urltobytes(new URL(context.base, string), context);
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("url does not exist", context);
            return null;
        }
    }

    public static Object prim_makeresourceurl(Object object, Object object2, Context context) {
        try {
            URL uRL = Class.forName(YoYo.aString(context, object)).getResource(YoYo.aString(context, object2));
            if (uRL == null) {
                LogoError.error("File " + object + "." + object2 + " could not be found.");
            }
            return uRL;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogoError.error("Class " + object + " cannot be found. Check your classpath.");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_urltostring(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            Object var3_4 = null;
            Object var4_5 = null;
            try {
                String string;
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = uRL.openStream();
                        string = PrimFile.readStream(new InputStreamReader(inputStream), -1, context);
                        Object var7_9 = null;
                        if (inputStream == null) return string;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogoError.error(exception.getMessage(), context);
                        Object var7_10 = null;
                        if (inputStream == null) return null;
                        inputStream.close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return string;
            }
            catch (IOException iOException) {
                LogoError.error("error reading url: " + uRL.toString(), context);
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("url does not exist: " + YoYo.printToString(object), context);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_urltobytes(Object object, Context context) {
        try {
            URL uRL = new URL(YoYo.aString(context, object));
            Object var3_4 = null;
            Object var4_5 = null;
            try {
                byte[] byArray;
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = uRL.openStream();
                        byArray = PrimFile.readStream(inputStream, -1, context);
                        Object var7_9 = null;
                        if (inputStream == null) return byArray;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogoError.error(exception.getMessage(), context);
                        Object var7_10 = null;
                        if (inputStream == null) return null;
                        inputStream.close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                LogoError.error("error reading url: " + uRL.toString(), context);
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("url does not exist: " + YoYo.printToString(object), context);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStream(java.io.Reader var0, int var1_1, Context var2_2) {
        var3_3 = null;
        if (var1_1 < 0) {
            var1_1 = 4096;
        }
        try {
            try {
                var3_3 = new BufferedReader(var0, var1_1);
                var8_4 = new StringBuffer(var1_1);
                var9_6 = new char[var1_1];
                while (true) {
                    var10_7 = 0;
                    while ((var10_7 = var3_3.read(var9_6, 0, var1_1)) == 0) {
                    }
                    if (var10_7 < 0) {
                        var6_8 = var8_4.toString();
                        var5_9 = null;
                        if (var3_3 == null) return var6_8;
                        break;
                    }
                    var8_4.append(var9_6, 0, var10_7);
                }
            }
            catch (IOException var8_5) {
                LogoError.error(var8_5.getMessage(), var2_2);
                var5_10 = null;
                if (var3_3 == null) return null;
                try {
                    var3_3.close();
                    return null;
                }
                catch (IOException var7_13) {
                    return null;
                }
            }
        }
        catch (Throwable var4_15) {
            var5_11 = null;
            if (var3_3 == null) throw var4_15;
            ** try [egrp 2[TRYBLOCK] [2 : 119->126)] { 
lbl37:
            // 1 sources

            var3_3.close();
            throw var4_15;
lbl39:
            // 1 sources

            catch (IOException var7_14) {
                // empty catch block
            }
            throw var4_15;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 119->126)] { 
lbl44:
        // 1 sources

        var3_3.close();
        return var6_8;
lbl46:
        // 1 sources

        catch (IOException var7_12) {
            // empty catch block
        }
        return var6_8;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readStream(InputStream var0, int var1_1, Context var2_2) {
        var3_3 = null;
        if (var1_1 < 0) {
            var1_1 = 4096;
        }
        try {
            try {
                var3_3 = new BufferedInputStream(var0, var1_1);
                var8_4 = new byte[var1_1];
                var9_6 = 0;
                var10_7 = new byte[var1_1];
                while (true) {
                    var11_8 = 0;
                    while ((var11_8 = var3_3.read(var10_7, 0, var1_1)) == 0) {
                    }
                    if (var11_8 < 0) {
                        var11_9 = new byte[var9_6];
                        System.arraycopy(var8_4, 0, var11_9, 0, var9_6);
                        var6_11 = var8_4;
                        var5_12 = null;
                        if (var3_3 == null) return var6_11;
                        break;
                    }
                    System.arraycopy(var10_7, 0, var8_4, var9_6, var11_8);
                    if ((var9_6 += var11_8) <= var8_4.length) continue;
                    var12_10 = new byte[var8_4.length * 2];
                    System.arraycopy(var8_4, 0, var12_10, 0, var8_4.length);
                    var8_4 = var12_10;
                }
            }
            catch (IOException var8_5) {
                LogoError.error(var8_5.getMessage(), var2_2);
                var5_13 = null;
                if (var3_3 == null) return null;
                try {
                    var3_3.close();
                    return null;
                }
                catch (IOException var7_16) {
                    return null;
                }
            }
        }
        catch (Throwable var4_18) {
            var5_14 = null;
            if (var3_3 == null) throw var4_18;
            ** try [egrp 2[TRYBLOCK] [2 : 172->179)] { 
lbl43:
            // 1 sources

            var3_3.close();
            throw var4_18;
lbl45:
            // 1 sources

            catch (IOException var7_17) {
                // empty catch block
            }
            throw var4_18;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 172->179)] { 
lbl50:
        // 1 sources

        var3_3.close();
        return var6_11;
lbl52:
        // 1 sources

        catch (IOException var7_15) {
            // empty catch block
        }
        return var6_11;
    }

    public static void prim_load_verbose(Object object, Context context) {
        PrimFile.load(object, true, context);
    }

    public static void prim_load(Object object, Context context) {
        PrimFile.load(object, false, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void load(Object object, boolean bl, Context context) {
        String string = YoYo.aString(context, object);
        if (!string.endsWith(".yoyo")) {
            string = string + ".yoyo";
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uRL.openStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    PrimFile.readprocs(inputStreamReader, bl, context);
                }
                catch (Exception exception) {
                    context.err.println(exception);
                    exception.printStackTrace(context.err);
                    if (context.log != context.err) {
                        context.log.println(exception);
                        exception.printStackTrace(context.log);
                    }
                    LogoError.error(exception.getMessage(), context);
                    Object var7_12 = null;
                    if (inputStream == null) return;
                    inputStream.close();
                    return;
                }
                Object var7_11 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("file does not exist", context);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogoError.error("file does not exist", context);
            return;
        }
        catch (IOException iOException) {
            LogoError.error("error reading file", context);
        }
    }

    public static void prim_load__from_string_verbose(Object object, Context context) {
        PrimFile.loadFromString(YoYo.aString(context, object), true, context);
    }

    public static void prim_load_from_string(Object object, Context context) {
        PrimFile.loadFromString(YoYo.aString(context, object), false, context);
    }

    public static void loadFromString(String string, boolean bl, Context context) {
        StringReader stringReader = new StringReader(string);
        try {
            try {
                PrimFile.readprocs(stringReader, bl, context);
            }
            catch (Exception exception) {
                context.err.println(exception);
                exception.printStackTrace(context.err);
                if (context.log != context.err) {
                    context.log.println(exception);
                    exception.printStackTrace(context.log);
                }
                LogoError.error(exception.getMessage(), context);
                Object var5_5 = null;
                stringReader.close();
            }
            Object var5_4 = null;
            stringReader.close();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            stringReader.close();
            throw throwable;
        }
    }

    static void readprocs(java.io.Reader reader, boolean bl, Context context) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        YoYoObject yoYoObject = context.ufunenv;
        Object[] objectArray = context.ilist;
        int n = context.ilistposptr;
        try {
            try {
                context.ufunenv = context.getGlobalObj();
                while (true) {
                    Object[] objectArray2;
                    Symbol[] symbolArray;
                    String string;
                    String string2;
                    if ((string2 = PrimFile.readtitle(context, bufferedReader)) == null) {
                        Object var10_15 = null;
                        context.ufunenv = yoYoObject;
                        context.ilist = objectArray;
                        context.ilistposptr = n;
                        return;
                    }
                    int n2 = (string2 = string2.substring(3).trim()).indexOf(" ");
                    if (n2 == -1) {
                        string = string2;
                        symbolArray = new Symbol[]{};
                    } else {
                        string = string2.substring(0, n2);
                        objectArray2 = Reader.read(string2.substring(n2 + 1));
                        symbolArray = new Symbol[objectArray2.length];
                        System.arraycopy(objectArray2, 0, symbolArray, 0, objectArray2.length);
                    }
                    objectArray2 = Reader.read(PrimFile.readbody(bufferedReader));
                    Symbol[] symbolArray2 = PrimFile.readlocals(symbolArray, new Symbol[0], objectArray2, 0);
                    Symbol symbol = Symbol.lookup(string);
                    context.ufunenv.defineValue(symbol, new Ufun(symbol, symbolArray, symbolArray2, objectArray2, context.ufunenv));
                    if (!bl) continue;
                    context.out.println(string + " defined.");
                }
            }
            catch (IOException iOException) {
                Object var10_16 = null;
                context.ufunenv = yoYoObject;
                context.ilist = objectArray;
                context.ilistposptr = n;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            context.ufunenv = yoYoObject;
            context.ilist = objectArray;
            context.ilistposptr = n;
            throw throwable;
        }
    }

    static String readtitle(Context context, BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = PrimFile.readaline(bufferedReader)) != null) {
            if (string.startsWith("to ", 0)) {
                return string;
            }
            if (string.startsWith("create-object ", 0)) {
                PrimFile.createObject(string.substring(14).trim(), context);
                continue;
            }
            if (string.startsWith("in-object ", 0)) {
                PrimFile.switchObject(string.substring(10).trim(), context);
                continue;
            }
            if (!string.startsWith("instance-var ", 0)) continue;
            PrimFile.createInstanceVar(string.substring(13).trim(), context);
        }
        return null;
    }

    static void createObject(String string, Context context) {
        Object[] objectArray = Reader.read(string);
        context.ilist = objectArray;
        context.ilistposptr = 0;
        Object object = context.ilistNext();
        if (object instanceof Symbol) {
            Object object2 = YoYo.evalOneFromHere(context);
            if (object2 instanceof YoYoObject) {
                YoYoObject yoYoObject = new YoYoObject((YoYoObject)object2);
                context.getGlobalObj().defineValue((Symbol)object, yoYoObject);
                context.ufunenv = yoYoObject;
                return;
            }
            LogoError.error("parent of " + object + " is not an object", context);
        } else {
            LogoError.error("create-object needs an object name", context);
        }
    }

    static void switchObject(String string, Context context) {
        Object[] objectArray = Reader.read(string);
        Object object = YoYo.evalOne(objectArray, context);
        if (object instanceof YoYoObject) {
            context.ufunenv = (YoYoObject)object;
        } else {
            LogoError.error("in-object needs an object", context);
        }
    }

    static void createInstanceVar(String string, Context context) {
        Object[] objectArray = Reader.read(string);
        context.ilist = objectArray;
        context.ilistposptr = 0;
        Object object = context.ilistNext();
        if (object instanceof Symbol) {
            Object object2 = YoYo.evalOneFromHere(context);
            context.ufunenv.defineValue((Symbol)object, object2);
            return;
        }
        LogoError.error("instance-var needs a variable name");
    }

    static String readbody(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2;
        while ((string2 = PrimFile.readaline(bufferedReader)) != null && !string2.startsWith("end", 0)) {
            string = string + string2 + "\r\n";
        }
        return string;
    }

    static String readaline(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        return string;
    }

    static Symbol[] readlocals(Symbol[] symbolArray, Symbol[] symbolArray2, Object[] objectArray, int n) {
        try {
            int n2 = n;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof Symbol) {
                    Symbol symbol = (Symbol)objectArray[n2];
                    if (!PrimFile.readlocals_Symbol(symbol, symbolArray, symbolArray2, objectArray, n2)) {
                        Object[] objectArray2;
                        if (symbol == set) {
                            if (n2 + 1 < objectArray.length) {
                                if (objectArray[n2 + 1] instanceof Symbol) {
                                    objectArray2 = (Object[])objectArray[++n2];
                                    PrimFile.readlocals_Symbol((Symbol)objectArray2, symbolArray, symbolArray2, objectArray, n2);
                                } else if (objectArray[n2 + 1] instanceof CompoundSymbol) {
                                    objectArray2 = (CompoundSymbol)objectArray[++n2];
                                    symbolArray2 = PrimFile.readlocals_CompoundSymbol((CompoundSymbol)objectArray2, symbolArray, symbolArray2);
                                }
                            }
                        } else if (symbol == letsym) {
                            if (n2 + 1 < objectArray.length && objectArray[n2 + 1] instanceof Object[]) {
                                objectArray2 = (Object[])objectArray[++n2];
                                symbolArray2 = PrimFile.readlocals_Let(objectArray2, symbolArray, symbolArray2);
                            }
                        } else if (symbol == dolist || symbol == dotimes) {
                            if (n2 + 1 < objectArray.length && objectArray[n2 + 1] instanceof Object[]) {
                                objectArray2 = (Object[])objectArray[++n2];
                                symbolArray2 = PrimFile.readlocals_InnerLet(objectArray2, symbolArray, symbolArray2);
                            }
                        } else if (symbol == lambda && n2 + 2 < objectArray.length && objectArray[n2 + 1] instanceof Object[] && objectArray[n2 + 2] instanceof Object[]) {
                            ++n2;
                        }
                    }
                } else if (objectArray[n2] instanceof CompoundSymbol) {
                    symbolArray2 = PrimFile.readlocals_CompoundSymbol((CompoundSymbol)objectArray[n2], symbolArray, symbolArray2);
                } else if (objectArray[n2] instanceof Object[]) {
                    symbolArray2 = PrimFile.readlocals(symbolArray, symbolArray2, (Object[])objectArray[n2], 0);
                } else if (objectArray[n2] instanceof Ilist) {
                    symbolArray2 = PrimFile.readlocals(symbolArray, symbolArray2, ((Ilist)objectArray[n2]).list, 0);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return symbolArray2;
    }

    static Symbol[] readlocals_Let(Object[] objectArray, Symbol[] symbolArray, Symbol[] symbolArray2) {
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[n];
                    symbolArray2 = PrimFile.readlocals_InnerLet(objectArray2, symbolArray, symbolArray2);
                }
                ++n;
            }
        }
        return symbolArray2;
    }

    static Symbol[] readlocals_InnerLet(Object[] objectArray, Symbol[] symbolArray, Symbol[] symbolArray2) {
        if (objectArray.length > 1 && objectArray[0] instanceof Symbol) {
            Symbol symbol = (Symbol)objectArray[0];
            if (!PrimFile.readlocals_Symbol(symbol, symbolArray, symbolArray2, objectArray, 0)) {
                objectArray[0] = new LocalRef(symbolArray.length + symbolArray2.length, symbol);
                Symbol[] symbolArray3 = new Symbol[symbolArray2.length + 1];
                System.arraycopy(symbolArray2, 0, symbolArray3, 0, symbolArray2.length);
                symbolArray3[symbolArray2.length] = symbol;
                symbolArray2 = symbolArray3;
            }
            symbolArray2 = PrimFile.readlocals(symbolArray, symbolArray2, objectArray, 1);
        }
        return symbolArray2;
    }

    static Symbol[] readlocals_CompoundSymbol(CompoundSymbol compoundSymbol, Symbol[] symbolArray, Symbol[] symbolArray2) {
        if (compoundSymbol.parts.length > 0) {
            Object object = compoundSymbol.parts[0];
            if (object instanceof Symbol) {
                Symbol symbol = (Symbol)object;
                PrimFile.readlocals_Symbol(symbol, symbolArray, symbolArray2, compoundSymbol.parts, 0);
            }
            int n = 0;
            while (n < compoundSymbol.parts.length) {
                Object object2 = compoundSymbol.parts[n];
                if (object2 instanceof Ilist) {
                    symbolArray2 = PrimFile.readlocals(symbolArray, symbolArray2, ((Ilist)object2).list, 0);
                }
                ++n;
            }
        }
        return symbolArray2;
    }

    static boolean readlocals_Symbol(Symbol symbol, Symbol[] symbolArray, Symbol[] symbolArray2, Object[] objectArray, int n) {
        int n2 = PrimFile.position(symbol, symbolArray);
        if (n2 >= 0) {
            objectArray[n] = new LocalRef(n2, symbol);
            return true;
        }
        n2 = PrimFile.position(symbol, symbolArray2);
        if (n2 >= 0) {
            objectArray[n] = new LocalRef(n2 + symbolArray.length, symbol);
            return true;
        }
        return false;
    }

    static int position(Symbol symbol, Symbol[] symbolArray) {
        int n = 0;
        while (n < symbolArray.length) {
            if (symbolArray[n] == symbol) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

