/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import yoyo.Context;
import yoyo.LocalRef;
import yoyo.LogoError;
import yoyo.Primitive;
import yoyo.Symbol;
import yoyo.ThrowReturn;
import yoyo.YoYo;
import yoyo.YoYoMethods;
import yoyo.YoYoObject;

public class PrimControl
implements YoYoMethods {
    public static Symbol symerror = Symbol.lookup("system-error");

    public String[] methodList() {
        String[] stringArray = new String[]{"repeat", "prim_repeat", "stop", "prim_stop", "output", "prim_output", "if", "prim_if", "ifelse", "prim_ifelse", "while", "prim_while", "loop", "prim_loop", "carefully", "prim_carefully", "always", "prim_always", "run", "prim_run", "ask", "prim_ask", "dotimes", "prim_dotimes", "launch", "prim_launch", "thread-self", "prim_thread_self", "throw", "prim_throw", "error", "prim_error", "error-type", "prim_errortype", "system-yield", "prim_yield", "wait", "prim_wait", "case", "prim_case"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static void prim_stop(Context context) {
        context.ufunreturn = Context.novalue;
        context.ilistSkipToEnd();
    }

    public static void prim_output(Object object, Context context) {
        context.ufunreturn = object;
        context.ilistSkipToEnd();
    }

    public static Object prim_error(Context context) {
        if (context.errorobj != null) {
            if (context.errorobj instanceof ThrowReturn) {
                return ((ThrowReturn)context.errorobj).value;
            }
            return context.errorobj.toString();
        }
        return YoYo.symfalse;
    }

    public static Object prim_errortype(Context context) {
        if (context.errorobj != null) {
            if (context.errorobj instanceof ThrowReturn) {
                return ((ThrowReturn)context.errorobj).errortype;
            }
            return symerror;
        }
        return YoYo.symfalse;
    }

    public static void prim_throw(Object object, Object object2, Context context) {
        Symbol symbol = YoYo.aSymbol(context, object);
        if (symbol != symerror) {
            throw new ThrowReturn(symbol, object2);
        }
        LogoError.error(YoYo.aString(context, object2), context);
    }

    public static void prim_repeat(Object object, Object object2, Context context) {
        int n;
        if (object2 instanceof Object[] && (n = ((Number)object).intValue()) > 0) {
            Object[] objectArray = YoYo.aList(context, object2);
            int n2 = 0;
            while (n2 < n) {
                YoYo.evalList(objectArray, context);
                if (context.ufunreturn != null) {
                    return;
                }
                ++n2;
            }
        }
    }

    public static Object prim_if(Object object, Object object2, Context context) {
        Object[] objectArray = YoYo.aList(context, object2);
        if (YoYo.aBoolean(context, object)) {
            Object object3 = YoYo.evalList(objectArray, context);
            return object3;
        }
        return null;
    }

    public static Object prim_ifelse(Object object, Object object2, Object object3, Context context) {
        Object object4;
        int n = context.nargs;
        Object[] objectArray = YoYo.aList(context, object2);
        Object[] objectArray2 = YoYo.aList(context, object3);
        try {
            context.nargs = 1;
            if (YoYo.aBoolean(context, object)) {
                Object object5 = YoYo.evalList(objectArray, context);
                Object var8_9 = null;
                context.nargs = n;
                return object5;
            }
            object4 = YoYo.evalList(objectArray2, context);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            context.nargs = n;
            throw throwable;
        }
        Object var8_10 = null;
        context.nargs = n;
        return object4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_while(Object object, Object object2, Context context) {
        Object var8_9;
        int n;
        block6: {
            Object var8_8;
            block5: {
                Object[] objectArray = YoYo.aList(context, object);
                Object[] objectArray2 = YoYo.aList(context, object2);
                n = context.nargs;
                try {
                    do {
                        context.nargs = 1;
                        Object object3 = YoYo.evalList(objectArray, context);
                        if (context.ufunreturn != null) {
                            Object var8_7 = null;
                            Object var7_10 = null;
                            context.nargs = n;
                            return var8_7;
                        }
                        context.nargs = 0;
                        if (!YoYo.aBoolean(context, object3)) {
                            var8_8 = null;
                            break block5;
                        }
                        YoYo.evalList(objectArray2, context);
                    } while (context.ufunreturn == null);
                    var8_9 = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    context.nargs = n;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            context.nargs = n;
            return var8_8;
        }
        Object var7_12 = null;
        context.nargs = n;
        return var8_9;
    }

    public static Object prim_loop(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        do {
            YoYo.evalList(objectArray, context);
        } while (context.ufunreturn == null);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_carefully(Object object, Object object2, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Object[] objectArray2 = YoYo.aList(context, object2);
        LogoError logoError = context.errorobj;
        try {
            try {
                Object object3 = YoYo.evalList(objectArray, context);
                Object var7_12 = null;
                context.errorobj = logoError;
                return object3;
            }
            catch (LogoError logoError2) {
                context.errorobj = logoError2;
                Object object4 = context.ufunreturn;
                context.ufunreturn = null;
                try {
                    Object object5 = YoYo.evalList(objectArray2, context);
                    Object var12_22 = null;
                    if (context.ufunreturn != null) {
                        Object var8_7 = null;
                        Object var7_13 = null;
                        context.errorobj = logoError;
                        return var8_7;
                    }
                    context.ufunreturn = object4;
                    if (object4 != null) {
                        Object var8_8 = null;
                        Object var7_14 = null;
                        context.errorobj = logoError;
                        return var8_8;
                    }
                    Object object6 = object5;
                    Object var7_15 = null;
                    context.errorobj = logoError;
                    return object6;
                }
                catch (Throwable throwable) {
                    Object var12_23 = null;
                    if (context.ufunreturn != null) {
                        Object var8_10 = null;
                        Object var7_16 = null;
                        context.errorobj = logoError;
                        return var8_10;
                    }
                    context.ufunreturn = object4;
                    if (object4 == null) throw throwable;
                    Object var8_11 = null;
                    Object var7_17 = null;
                    context.errorobj = logoError;
                    return var8_11;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_18 = null;
            context.errorobj = logoError;
            throw throwable;
        }
    }

    public static Object prim_always(Object object, Object object2, Context context) {
        Object object3;
        Object object4;
        Object[] objectArray = YoYo.aList(context, object);
        Object[] objectArray2 = YoYo.aList(context, object2);
        try {
            object4 = YoYo.evalList(objectArray, context);
            Object var6_6 = null;
            object3 = context.ufunreturn;
            context.ufunreturn = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Object object5 = context.ufunreturn;
            context.ufunreturn = null;
            try {
                YoYo.evalList(objectArray2, context);
            }
            finally {
                Object var10_12 = null;
                if (context.ufunreturn != null) {
                    return null;
                }
                context.ufunreturn = object5;
                if (object5 != null) {
                    return null;
                }
            }
            throw throwable;
        }
        try {
            YoYo.evalList(objectArray2, context);
        }
        finally {
            Object var10_10 = null;
            if (context.ufunreturn != null) {
                return null;
            }
            context.ufunreturn = object3;
            if (object3 != null) {
                return null;
            }
        }
        return object4;
    }

    public static Object prim_run(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        int n = context.nargs;
        context.nargs = 1;
        Object object2 = null;
        try {
            object2 = YoYo.evalList(objectArray, context);
        }
        finally {
            Object var6_5 = null;
            context.nargs = n;
        }
        return object2;
    }

    public static Object prim_ask(Object object, Object object2, Context context) {
        Object[] objectArray = YoYo.aList(context, object2);
        YoYoObject yoYoObject = context.objenv;
        context.objenv = YoYo.aYoYoObject(context, object);
        int n = context.nargs;
        context.nargs = 1;
        Object object3 = null;
        try {
            object3 = YoYo.evalList(objectArray, context);
        }
        finally {
            Object var8_7 = null;
            context.nargs = n;
            context.objenv = yoYoObject;
        }
        return object3;
    }

    public static Object prim_launch(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Context context2 = new Context(context);
        new Thread(context2).start();
        context2.runList(objectArray);
        return context2.self;
    }

    public static Object prim_thread_self(Context context) {
        return context.self;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_dotimes(Object object, Object object2, Context context) {
        Object var13_20;
        Object var12_15;
        LocalRef localRef;
        Object object3;
        block17: {
            int n;
            Object[] objectArray = YoYo.aList(context, object);
            Object[] objectArray2 = YoYo.aList(context, object2);
            object3 = null;
            Object[] objectArray3 = context.ilist;
            int n2 = context.ilistposptr;
            try {
                context.ilist = objectArray;
                context.ilistposptr = 0;
                Object object4 = context.ilistNext();
                if (object4 instanceof LocalRef) {
                    localRef = (LocalRef)object4;
                    object3 = context.locals.lookupValue(localRef);
                } else {
                    int n3;
                    Symbol symbol = YoYo.aSymbol(context, object4);
                    if (context.locals.boundp(symbol)) {
                        n3 = context.locals.index(symbol);
                        localRef = new LocalRef(n3, symbol);
                        context.setPrev(localRef);
                        object3 = context.locals.lookupValue(localRef);
                    } else {
                        n3 = context.locals.defineVar(symbol);
                        localRef = new LocalRef(n3, symbol);
                        context.setPrev(localRef);
                        object3 = null;
                    }
                }
                if (context.ufunobj != null && context.locals.names.length > context.ufunobj.arglist.length) {
                    context.ufunobj.arglist = context.locals.names;
                }
                n = YoYo.aInteger(context, YoYo.evalOneFromHere(context));
            }
            finally {
                var12_15 = null;
                context.ilist = objectArray3;
                context.ilistposptr = n2;
            }
            try {
                Object var13_19;
                block18: {
                    int n4 = 1;
                    do {
                        if (n4 > n) {
                            var13_20 = null;
                            break block17;
                        }
                        context.locals.setValue(localRef, (Object)new Integer(n4++));
                        YoYo.evalList(objectArray2, context);
                    } while (context.ufunreturn == null);
                    var13_19 = null;
                    var12_15 = null;
                    if (object3 == null) break block18;
                    context.locals.setValue(localRef, object3);
                    return var13_19;
                }
                context.locals.undefineVar(localRef);
                return var13_19;
            }
            catch (Throwable throwable) {
                var12_15 = null;
                if (object3 != null) {
                    context.locals.setValue(localRef, object3);
                    throw throwable;
                }
                context.locals.undefineVar(localRef);
                throw throwable;
            }
        }
        var12_15 = null;
        if (object3 != null) {
            context.locals.setValue(localRef, object3);
            return var13_20;
        }
        context.locals.undefineVar(localRef);
        return var13_20;
    }

    public static void prim_yield(Context context) {
        Thread.currentThread();
        Thread.yield();
    }

    public static void prim_wait(Object object, Context context) {
        int n = (int)(1000.0 * YoYo.aDouble(context, object));
        try {
            while (n >= 0) {
                YoYo.pollStop(context);
                Thread.currentThread();
                Thread.sleep(10L);
                n -= 10;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object prim_case(Object object, Object object2, Context context) {
        Object object3;
        Object[] objectArray = YoYo.aList(context, object2);
        Object[] objectArray2 = context.ilist;
        int n = context.ilistposptr;
        try {
            context.ilist = objectArray;
            context.ilistposptr = 0;
            while (context.ilistPeek() != null) {
                Object object4 = YoYo.evalOneFromHere(context);
                if (context.ufunreturn != null) {
                    Object var8_8 = null;
                    Object var7_10 = null;
                    context.ilist = objectArray2;
                    context.ilistposptr = n;
                    if (context.ufunreturn == null) return var8_8;
                    context.ilistSkipToEnd();
                    return var8_8;
                }
                if (context.ilistPeek() == null) {
                    LogoError.error("not enough inputs to case", context);
                }
                Object object5 = context.ilistNext();
                if (YoYo.equal(object, object4) != YoYo.symtrue && object4 != YoYo.symtrue) continue;
                object3 = YoYo.evalList(YoYo.aList(context, object5), context);
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            if (context.ufunreturn == null) throw throwable;
            context.ilistSkipToEnd();
            throw throwable;
        }
        {
            Object var7_11 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            if (context.ufunreturn == null) return object3;
            context.ilistSkipToEnd();
            return object3;
        }
        Object var7_12 = null;
        context.ilist = objectArray2;
        context.ilistposptr = n;
        if (context.ufunreturn == null) return null;
        context.ilistSkipToEnd();
        return null;
    }
}

