/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import yoyo.Context;
import yoyo.Function;
import yoyo.JCommandCenter;
import yoyo.Symbol;
import yoyo.UberContext;
import yoyo.YoYo;

public class JToplevel
extends JFrame
implements ClipboardOwner,
ActionListener,
ItemListener {
    static String[] sizes = new String[]{"6", "8", "9", "10", "11", "12", "14", "16", "18", "24", "36", "48", "72"};
    public static String bootpath;
    public static String bootfile;
    static Clipboard clip;
    public static UberContext ub;
    public static URL base;
    Context c;
    JCommandCenter cc;
    JScrollPane jsp;
    JCheckBoxMenuItem currentfont;
    JCheckBoxMenuItem currentsize;
    boolean firstone;
    public int commandMask = YoYo.macintoshp ? 4 : 2;

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        JToplevel.readArgs(stringArray);
        JToplevel jToplevel = new JToplevel("YoYo", true);
    }

    public static void readArgs(String[] stringArray) {
        if (stringArray.length > 1) {
            bootpath = stringArray[0].trim();
            if (bootpath.equals("")) {
                bootpath = null;
            }
            if ((bootfile = stringArray[1].trim()).equals("")) {
                bootfile = null;
            }
        } else if (stringArray.length > 0 && (bootfile = stringArray[0].trim()).equals("")) {
            bootfile = null;
        }
    }

    void appInit() {
        try {
            base = new URL("file", "", System.getProperty(YoYo.pcp ? "user.home" : "user.dir") + "/");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        ub = new UberContext(base);
    }

    public void windowInit() {
        this.createComponents();
        this.addComponentsToLayout();
        this.addListeners();
        this.setupMenus();
        this.cc.requestFocus();
        this.sendWelcome();
    }

    public void createComponents() {
        this.cc = new JCommandCenter();
        this.cc.c = this.c = new Context(null, base, this.cc.getOut(), this.cc, new UberContext(base));
        this.jsp = new JScrollPane(this.cc, 22, 31);
    }

    public void addComponentsToLayout() {
        this.getContentPane().add(this.jsp);
        ((Component)this).setSize(400, 250);
        this.show();
    }

    public void addListeners() {
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ JToplevel this$0;

            public final void windowClosing(WindowEvent windowEvent) {
                this.this$0.c.die();
                windowEvent.getWindow().dispose();
            }
            {
                this.this$0 = jToplevel;
                this.constructor$0(jToplevel);
            }

            private final void constructor$0(JToplevel jToplevel) {
            }
        });
        this.cc.addKeyListener(new KeyAdapter(this){
            private final /* synthetic */ JToplevel this$0;

            public final void keyPressed(KeyEvent keyEvent) {
                JCommandCenter jCommandCenter = (JCommandCenter)keyEvent.getComponent();
                char c = keyEvent.getKeyChar();
                if (jCommandCenter.c.runningnowp) {
                    jCommandCenter.c.stop();
                    keyEvent.consume();
                    return;
                }
                if (!(c != '\n' && c != '\r' || keyEvent.isShiftDown())) {
                    jCommandCenter.handlecr();
                    keyEvent.consume();
                }
                if (c == '\t') {
                    jCommandCenter.c.out.print("   ");
                    jCommandCenter.c.out.flush();
                    keyEvent.consume();
                }
            }

            public final void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\n' || c == '\r') {
                    if (!keyEvent.isShiftDown()) {
                        keyEvent.consume();
                    }
                } else if (c == '\t') {
                    keyEvent.consume();
                }
            }
            {
                this.this$0 = jToplevel;
                this.constructor$0(jToplevel);
            }

            private final void constructor$0(JToplevel jToplevel) {
            }
        });
    }

    public void sendWelcome() {
        this.c.out.println("Welcome to YoYo!");
    }

    public void loadBootFile() {
        if (this.firstone && bootfile != null) {
            this.cc.runLine("load \"file:" + JToplevel.quote(bootfile) + "\"");
            this.c.waitUntilDone();
            if (bootpath != null) {
                this.cc.runLine("cd \"file:" + JToplevel.quote(bootpath) + "\"");
                this.c.waitUntilDone();
            }
            this.runStartup();
        }
    }

    public void runStartup() {
        Object object = null;
        object = this.c.getGlobalObj().lookupValue(Symbol.lookup("startup"));
        if (object != null && object instanceof Function) {
            this.cc.runLine("startup");
        }
    }

    void setupMenus() {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Font");
        JMenu jMenu4 = new JMenu("Size");
        JMenuItem jMenuItem = new JMenuItem("New", 78);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open...", 79);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open URL...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("New Listener");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close Listener", 87);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Undo", 90);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("cut-to-clipboard");
        jMenuItem.setLabel("Cut");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, this.commandMask));
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("copy-to-clipboard");
        jMenuItem.setLabel("Copy");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, this.commandMask));
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("paste-from-clipboard");
        jMenuItem.setLabel("Paste");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, this.commandMask));
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem("select-all");
        jMenuItem.setLabel("Select All");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, this.commandMask));
        jMenu2.add(jMenuItem);
        jMenuBar.add(jMenu2);
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("Monospaced")) {
                this.currentfont = jCheckBoxMenuItem = new JCheckBoxMenuItem(stringArray[n], true);
            } else {
                jCheckBoxMenuItem = new JCheckBoxMenuItem(stringArray[n], false);
            }
            jCheckBoxMenuItem.addItemListener(this);
            jCheckBoxMenuItem.setFont(new Font(stringArray[n], 0, 11));
            jMenu3.add(jCheckBoxMenuItem);
            ++n;
        }
        n = 0;
        while (n < sizes.length) {
            if (sizes[n].equals("12")) {
                this.currentsize = jCheckBoxMenuItem = new JCheckBoxMenuItem(sizes[n], true);
            } else {
                jCheckBoxMenuItem = new JCheckBoxMenuItem(sizes[n], false);
            }
            jCheckBoxMenuItem.addItemListener(this);
            jMenu4.add(jCheckBoxMenuItem);
            ++n;
        }
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getLabel();
        if (string.equals("New Listener")) {
            new JToplevel("YoYo", false);
            return;
        }
        if (string.equals("Close Listener")) {
            this.c.die();
            this.dispose();
        }
        if (string.equals("Quit")) {
            System.exit(0);
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getSource();
        String string = jCheckBoxMenuItem.getLabel();
        if (!jCheckBoxMenuItem.isSelected()) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (this.currentsize == jCheckBoxMenuItem) {
                return;
            }
            Font font = this.cc.getFont();
            this.cc.setFont(new Font(font.getName(), font.getStyle(), n));
            this.currentsize.setSelected(false);
            this.currentsize = jCheckBoxMenuItem;
            return;
        }
        catch (Exception exception) {
            if (this.currentfont == jCheckBoxMenuItem) {
                return;
            }
            Font font = this.cc.getFont();
            this.cc.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.currentfont.setSelected(false);
            this.currentfont = jCheckBoxMenuItem;
            return;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    JToplevel(String string, boolean bl) {
        super(string);
        this.firstone = bl;
        if (bl) {
            this.appInit();
        }
        this.windowInit();
        String string2 = this.c.toString();
        if (!bl) {
            this.setTitle(string2.substring(1, string2.length() - 1));
        }
        if (bl && bootfile != null) {
            this.cc.runLine("load \"" + bootfile + "\"");
        }
    }

    static {
        clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        base = null;
    }
}

