/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.Reader;
import yoyo.Ufun;
import yoyo.YoYo;
import yoyo.YoYoCaller;

public class JCommandCenter
extends JTextPane
implements YoYoCaller {
    protected static Font LISTENER_FONT = new Font("Monospaced", 0, 12);
    public Context c;
    public Ufun formatInput;
    String bullet = "\u00b7";
    Position bulletPosition;
    PrintWriter out;
    PrintWriter err;
    Style boldon;
    SimpleAttributeSet boldoff;
    protected Keymap km;

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            try {
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    styledDocument.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    this.setCharacterAttributes(this.boldon, false);
                    styledDocument.insertString(n, string, this.getInputAttributes());
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        }
    }

    public void handlecr() {
        Element element = this.getStyledDocument().getParagraphElement(this.getCaretPosition());
        int n = element.getStartOffset();
        int n2 = element.getEndOffset() - 1;
        try {
            String string = this.getStyledDocument().getText(n, n2 - n);
            Caret caret = this.getCaret();
            int n3 = caret.getDot();
            int n4 = caret.getMark();
            if (n3 != n4) {
                this.replaceSelection("\n");
                return;
            }
            if (!string.trim().equals("")) {
                this.bulletPosition = this.getStyledDocument().createPosition(n2 - 1);
                this.getStyledDocument().insertString(n2, this.bullet, this.boldoff);
                if (n2 == this.getStyledDocument().getLength() - 1) {
                    this.replaceSelection("\n");
                } else {
                    this.setCaretPosition(n2 + 2);
                }
                this.runLine(string);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void runLine(String string) {
        if (this.formatInput == null) {
            this.c.runList(Reader.read(string));
        } else {
            Object[] objectArray = Reader.read("");
            Object object = null;
            Object[] objectArray2 = new Object[]{string};
            int n = this.c.nargs;
            Object[] objectArray3 = this.c.ilist;
            int n2 = this.c.ilistposptr;
            try {
                this.c.ilist = objectArray;
                this.c.ilistposptr = 0;
                this.c.nargs = 1;
                object = YoYo.evalFunction(this.formatInput.name, this.formatInput, this.c.getGlobalObj(), objectArray2, this.c);
            }
            finally {
                Object var9_8 = null;
                this.c.nargs = n;
                this.c.ilist = objectArray3;
                this.c.ilistposptr = n2;
            }
            if (object instanceof String) {
                this.c.runList(Reader.read((String)object));
            } else if (object instanceof Object[]) {
                this.c.runList((Object[])object);
            } else {
                LogoError.error("The output from listener-function: " + YoYo.printToString(object) + "," + " is not a string");
            }
        }
    }

    public void done(Context context) {
        if (this.bulletPosition != null) {
            try {
                Position position = this.getStyledDocument().createPosition(this.getCaretPosition());
                int n = this.bulletPosition.getOffset() + 1;
                try {
                    this.getStyledDocument().remove(n, 1);
                }
                catch (BadLocationException badLocationException) {
                    this.getStyledDocument().remove(n, 0);
                }
                Caret caret = this.getCaret();
                int n2 = caret.getDot();
                int n3 = caret.getMark();
                if (n2 == n3) {
                    this.setCaretPosition(position.getOffset());
                } else {
                    caret.setDot(n3 - 1);
                    caret.moveDot(n2 - 1);
                }
                this.bulletPosition = null;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void setFormatInput(Ufun ufun) {
        this.formatInput = ufun;
    }

    public PrintWriter getOut() {
        if (this.out == null) {
            this.out = new PrintWriter((Writer)new CommandCenterWriter(), true);
        }
        return this.out;
    }

    public PrintWriter getErr() {
        if (this.err == null) {
            this.err = new PrintWriter((Writer)new CommandCenterWriter(), true);
        }
        return this.err;
    }

    public void flush() {
        this.getOut().flush();
    }

    public JCommandCenter() {
        super(new DefaultStyledDocument());
        this.setCaretPosition(0);
        this.setMargin(new Insets(5, 5, 5, 5));
        LISTENER_FONT = Font.getFont("yoyo.listener.font", LISTENER_FONT);
        this.setFont(LISTENER_FONT);
        this.boldoff = new SimpleAttributeSet();
        StyleConstants.setBold(this.boldoff, false);
        this.boldon = this.addStyle("normal bold", StyleContext.getDefaultStyleContext().getStyle("default"));
        StyleConstants.setBold(this.boldon, true);
        this.km = JTextComponent.addKeymap("Command Center", this.getKeymap());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        TextAction textAction = new TextAction(this, "Enter"){
            private final /* synthetic */ JCommandCenter this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.handlecr();
            }
            {
                this.this$0 = jCommandCenter;
                this.constructor$0(jCommandCenter, string);
            }

            private final void constructor$0(JCommandCenter jCommandCenter, String string) {
            }
        };
        this.km.addActionForKeyStroke(keyStroke, textAction);
        this.setKeymap(this.km);
    }

    private class CommandCenterWriter
    extends Writer {
        StringBuffer buf = new StringBuffer(1024);
        StringBuffer flushingBuf;

        public void close() throws IOException {
            this.flush();
        }

        public void flush() throws IOException {
            if (this.buf.length() == 0) {
                return;
            }
            this.flushingBuf = this.buf;
            this.buf = new StringBuffer(this.buf.capacity());
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ CommandCenterWriter this$0;
                private final /* synthetic */ JCommandCenter this$1;

                public final void run() {
                    try {
                        int n = this.this$1.getStyledDocument().getLength();
                        if (this.this$1.bulletPosition != null) {
                            n = this.this$1.bulletPosition.getOffset() + 3;
                        }
                        this.this$1.getStyledDocument().insertString(n, this.this$0.flushingBuf.toString(), this.this$1.boldoff);
                        this.this$1.setCaretPosition(n);
                        this.this$1.moveCaretPosition(n + this.this$0.flushingBuf.length());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                {
                    this.this$0 = commandCenterWriter;
                    this.this$1 = CommandCenterWriter.access$0(this.this$0);
                    this.constructor$0(commandCenterWriter);
                }

                private final void constructor$0(CommandCenterWriter commandCenterWriter) {
                }
            });
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.buf.append(cArray, n, n2);
            }
        }

        static /* synthetic */ JCommandCenter access$0(CommandCenterWriter commandCenterWriter) {
            return commandCenterWriter.JCommandCenter.this;
        }

        CommandCenterWriter() {
        }
    }
}

