/*
 * Decompiled with CFR 0.152.
 */
package template.general;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import template.BaseFunc;
import template.ButtonInfo;
import template.Util;
import template.arguments.BaseArg;
import template.arguments.BreedArg;
import template.arguments.ChoiceArg;
import template.arguments.ColorArg;
import template.arguments.SliderArg;

public class Function
extends BaseFunc {
    static String sliderWord = "<slider>";
    static String breedWord = "<breed>";
    static String colorWord = "<color>";
    static String choiceWord = "<choice>";
    static String buttonWord = "<button>";
    static String bodyStart = "<body>";
    static String bodyEnd = "</body>";
    static String descStart = "<description>";
    static String descEnd = "</description>";
    static String switches = "<switches>";
    static String obsFuncSW = "observer";
    static String noWander = "notinwander";
    static String predefined = "predefined";
    static String tVars = "<turtlevars>";
    static String gVars = "<globalvars>";
    static String pVars = "<patchvars>";
    static String ifString = "if";
    static String elseString = "else";
    static String endifString = "endif";
    String[] body;
    String[] turtleVars;
    String[] globalVars;
    String[] patchVars;
    String desc = "This function has no description";
    Collection sliderList = new ArrayList();
    Collection breedList = new ArrayList();
    Collection colorList = new ArrayList();
    Collection choiceList = new ArrayList();
    Collection buttonList = new ArrayList();
    ButtonInfo[] buttons;

    public String getBody() {
        String string = "";
        boolean bl = true;
        BoolStack boolStack = new BoolStack(8);
        boolStack.push(true);
        int n = 0;
        while (n < this.body.length) {
            if (this.body[n].startsWith(ifString)) {
                int n2;
                try {
                    n2 = new Integer(this.body[++n]);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = new Integer(this.body[++n]);
                }
                if (!this.choiceArgs[n2 - 1].isDefaultSelected()) {
                    n = this.matchElse(n);
                    boolStack.push(false);
                } else {
                    boolStack.push(true);
                }
            } else if (this.body[n].startsWith(elseString)) {
                if (boolStack.isEmpty()) {
                    System.err.println("No " + ifString + " for this " + elseString + ": " + this.body[n]);
                    return null;
                }
                if (boolStack.peek()) {
                    n = this.matchEndIf(n);
                }
            } else if (this.body[n].startsWith(endifString)) {
                if (boolStack.isEmpty()) {
                    System.err.println("No " + ifString + " for this " + endifString + ": " + this.body[n]);
                    return null;
                }
                boolStack.pop();
            } else {
                if (!string.trim().equals("")) {
                    string = string + "\n";
                }
                string = string + this.body[n];
            }
            ++n;
        }
        return this.replaceVariables(string);
    }

    public String describe() {
        return this.desc;
    }

    public void add(BaseArg baseArg) {
        if (baseArg instanceof SliderArg) {
            this.sliderList.add(baseArg);
        } else if (baseArg instanceof BreedArg) {
            this.breedList.add(baseArg);
        } else if (baseArg instanceof ColorArg) {
            this.colorList.add(baseArg);
        } else if (baseArg instanceof ChoiceArg) {
            this.choiceList.add(baseArg);
        }
        super.add(baseArg);
    }

    public String[] getVariables(int n) {
        if (n == 0) {
            return this.turtleVars;
        }
        if (n == 1) {
            return this.globalVars;
        }
        if (n == 2) {
            return this.patchVars;
        }
        return null;
    }

    public ButtonInfo[] getButtonInfo() {
        return this.buttons;
    }

    public boolean loadArgs(String string) {
        String[] stringArray = Util.split(string, "\n");
        ChoiceArg choiceArg = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            BaseArg baseArg = this.loadArg(stringArray[n2]);
            Component component = Box.createVerticalStrut(0);
            if (baseArg != null) {
                if (this.getComponentCount() > 0 && n == 0) {
                    this.add(component);
                }
                this.add(baseArg);
            }
            if (n == 2 && choiceArg != null) {
                choiceArg.setPanels(baseArg, null);
                --n;
            } else if (n == 1 && choiceArg != null) {
                choiceArg.setPanels(choiceArg.getDefaultPanel(), baseArg);
                --n;
            } else if (baseArg instanceof ChoiceArg) {
                choiceArg = (ChoiceArg)baseArg;
                n = 2;
            }
            ++n2;
        }
        return true;
    }

    public void loadSwitches(String string) {
        if ((string = Util.isolateChunk(string, switches, "\n")) == null) {
            return;
        }
        if (string.indexOf(obsFuncSW) != -1) {
            this.obsFuncP = true;
        }
        if (string.indexOf(noWander) != -1) {
            this.inWanderP = false;
        }
        if (string.indexOf(predefined) != -1) {
            this.predefinedP = true;
        }
    }

    public void loadVariables(String string) {
        Iterator iterator;
        String string2 = Util.isolateChunk(string, tVars, "\n");
        String string3 = Util.isolateChunk(string, gVars, "\n");
        String string4 = Util.isolateChunk(string, pVars, "\n");
        ArrayList arrayList = new ArrayList();
        if (string2 != null) {
            arrayList.clear();
            iterator = Util.parse(string2).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.turtleVars = (String[])arrayList.toArray(new String[0]);
        }
        if (string3 != null) {
            arrayList.clear();
            iterator = Util.parse(string3).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.globalVars = (String[])arrayList.toArray(new String[0]);
        }
        if (string4 != null) {
            arrayList.clear();
            iterator = Util.parse(string4).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.patchVars = (String[])arrayList.toArray(new String[0]);
        }
    }

    public void loadButtons(String string) {
        String[] stringArray = Util.split(string, "\n");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(buttonWord)) {
                this.buttonList.add(this.loadButton(stringArray[n]));
            }
            ++n;
        }
    }

    public void loadName(String string) {
        String string2 = string.substring(0, string.indexOf("\n"));
        string2 = Util.unquote(string2);
        this.funcName.setText(string2);
    }

    public BaseArg loadArg(String string) {
        try {
            String string2 = string.toLowerCase();
            if (string2.startsWith(sliderWord)) {
                return this.loadSlider(string);
            }
            if (string2.startsWith(breedWord)) {
                return this.loadBreed(string);
            }
            if (string2.startsWith(colorWord)) {
                return this.loadColor(string);
            }
            if (string2.startsWith(choiceWord)) {
                return this.loadChoice(string);
            }
            return null;
        }
        catch (Exception exception) {
            System.err.println("Bad argument definition: " + string);
            return null;
        }
    }

    public BaseArg loadChoice(String string) throws Exception {
        Iterator iterator = Util.parse(string).iterator();
        String string2 = (String)iterator.next();
        if (string2.equals(choiceWord)) {
            string2 = (String)iterator.next();
        }
        String string3 = string2;
        String string4 = (String)iterator.next();
        String string5 = (String)iterator.next();
        return new ChoiceArg(string3, string4, string5);
    }

    public BaseArg loadSlider(String string) throws Exception {
        Iterator iterator = Util.parse(string).iterator();
        String string2 = (String)iterator.next();
        if (string2.equals(sliderWord)) {
            string2 = (String)iterator.next();
        }
        String string3 = (String)iterator.next();
        int n = new Integer((String)iterator.next());
        int n2 = new Integer((String)iterator.next());
        int n3 = new Integer((String)iterator.next());
        return new SliderArg(string2, string3, n, n2, n3);
    }

    public BaseArg loadBreed(String string) throws Exception {
        Iterator iterator = Util.parse(string).iterator();
        String string2 = (String)iterator.next();
        if (string2.equals(breedWord)) {
            string2 = (String)iterator.next();
        }
        String string3 = (String)iterator.next();
        return new BreedArg(string2, string3);
    }

    public BaseArg loadColor(String string) throws Exception {
        Iterator iterator = Util.parse(string).iterator();
        String string2 = (String)iterator.next();
        if (string2.equals(colorWord)) {
            string2 = (String)iterator.next();
        }
        String string3 = (String)iterator.next();
        String string4 = "";
        if (iterator.hasNext()) {
            string4 = (String)iterator.next();
        }
        return new ColorArg(string2, string3, string4);
    }

    public ButtonInfo loadButton(String string) {
        Iterator iterator = Util.parse(string).iterator();
        String string2 = (String)iterator.next();
        if (string2.equals(buttonWord)) {
            string2 = (String)iterator.next();
        }
        boolean bl = new Boolean((String)iterator.next());
        boolean bl2 = new Boolean((String)iterator.next());
        if (iterator.hasNext()) {
            return new ButtonInfo(bl, (String)iterator.next(), string2, bl2, true);
        }
        return new ButtonInfo(bl, string2, bl2);
    }

    public void finalizeArrays() {
        this.sliderArgs = (SliderArg[])this.sliderList.toArray(new SliderArg[0]);
        this.colorArgs = (ColorArg[])this.colorList.toArray(new ColorArg[0]);
        this.breedArgs = (BreedArg[])this.breedList.toArray(new BreedArg[0]);
        this.choiceArgs = (ChoiceArg[])this.choiceList.toArray(new ChoiceArg[0]);
        this.buttons = (ButtonInfo[])this.buttonList.toArray(new ButtonInfo[0]);
    }

    public static String[] tokenize(String string) {
        return (String[])Util.parse(string).toArray(new String[0]);
    }

    public String replaceVariables(String string) {
        int n;
        if (this.sliderArgs != null) {
            n = 0;
            while (n < this.sliderArgs.length) {
                if (this.sliderArgs[n].isVisible() && this.sliderArgs[n].isEnabled()) {
                    string = Util.replace(string, this.sliderArgs[n].getVariable(), this.sliderArgs[n].toString());
                }
                ++n;
            }
        }
        if (this.breedArgs != null) {
            n = 0;
            while (n < this.breedArgs.length) {
                if (this.breedArgs[n].isVisible() && this.breedArgs[n].isEnabled()) {
                    string = Util.replace(string, this.breedArgs[n].getVariable(), this.breedArgs[n].toString());
                }
                ++n;
            }
        }
        if (this.colorArgs != null) {
            n = 0;
            while (n < this.colorArgs.length) {
                if (this.colorArgs[n].isVisible() && this.colorArgs[n].isEnabled()) {
                    string = Util.replace(string, this.colorArgs[n].getVariable(), this.colorArgs[n].toString());
                }
                ++n;
            }
        }
        return string;
    }

    public int matchElse(int n) {
        int n2 = 0;
        int n3 = n + 1;
        while (n3 < this.body.length) {
            if (this.body[n3].startsWith(ifString)) {
                ++n2;
            } else if (this.body[n3].startsWith(elseString)) {
                if (n2 == 0) {
                    break;
                }
            } else if (this.body[n3].startsWith(endifString)) {
                --n2;
            }
            ++n3;
        }
        return n3;
    }

    public int matchEndIf(int n) {
        int n2 = 0;
        int n3 = n + 1;
        while (n3 < this.body.length) {
            if (this.body[n3].startsWith(ifString)) {
                ++n2;
            } else if (!this.body[n3].startsWith(elseString) && this.body[n3].startsWith(endifString)) {
                if (n2 <= 0) break;
                --n2;
            }
            ++n3;
        }
        return n3;
    }

    static /* synthetic */ Collection access$0(Function function) {
        return function.breeds;
    }

    public Function(String string, Collection collection) {
        this.breeds = collection;
        this.loadName(string);
        this.body = Function.tokenize(Util.isolateChunk(string, bodyStart, bodyEnd));
        this.desc = Util.unquote(Util.isolateChunk(string, descStart, descEnd));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.funcName);
        this.loadArgs(string);
        this.loadSwitches(string);
        this.loadVariables(string);
        this.loadButtons(string);
        this.finalizeArrays();
    }

    class BoolStack {
        boolean[] array;
        int pos = -1;

        public boolean push(boolean bl) {
            if (this.pos >= this.array.length) {
                return false;
            }
            this.array[++this.pos] = bl;
            return true;
        }

        public boolean pop() {
            if (this.pos == -1) {
                return false;
            }
            boolean bl = this.array[this.pos];
            --this.pos;
            return bl;
        }

        public boolean peek() {
            if (!this.isEmpty()) {
                return this.array[this.pos];
            }
            return false;
        }

        public boolean isEmpty() {
            return this.pos == -1;
        }

        public BoolStack(int n) {
            this.array = new boolean[n];
        }
    }
}

