/*
 * Decompiled with CFR 0.152.
 */
package template;

import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.awt.CardLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import starlogo.Interface;
import template.BaseFunc;
import template.BreedProps;
import template.ButtonInfo;
import template.Preview;
import template.SliderInfo;
import template.Template;
import template.Util;

public class BreedFuncs
extends JPanel {
    public static String breedFuncsWord = "Breed";
    String breed;
    Set pages = new TreeSet();
    protected BreedProps properties;
    CardLayout layout = new CardLayout();
    String lastFunction;
    JPanel lowerPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    Preview preview = new Preview();
    protected Template t;
    BaseFunc currentFunction;
    JScrollPane scrollPane = new JScrollPane();

    public void setup() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(this.lowerPanel);
        this.mainPanel.add(Box.createVerticalGlue());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.lowerPanel.setLayout(new BoxLayout(this.lowerPanel, 0));
        this.lowerPanel.add(this.scrollPane);
        this.scrollPane.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.mainPanel);
        this.add(this.preview);
        this.properties = new BreedProps(this.breed, this);
        this.addFunctions();
        this.properties.setPossibleFuncs(this.getAllFuncs());
        this.addPredefinedFuncs();
        this.properties.enable();
    }

    public void addFunctions() {
    }

    public void addPredefinedFuncs() {
        BaseFunc[] baseFuncArray = this.getAllFuncs();
        int n = 0;
        while (n < baseFuncArray.length) {
            if (!baseFuncArray[n].isObsFunc() && baseFuncArray[n].isPredefined()) {
                this.properties.addFunc(baseFuncArray[n]);
            }
            ++n;
        }
    }

    public void add(BaseFunc baseFunc) {
        this.pages.add(baseFunc);
    }

    public void remove(BaseFunc baseFunc) {
        this.pages.remove(baseFunc);
        this.properties.remove(baseFunc);
    }

    public void removeAll() {
        this.pages.clear();
        this.properties.removeAll();
    }

    public void restart() {
        this.removeAll();
    }

    public void show(BaseFunc baseFunc) {
        baseFunc.add(Box.createVerticalGlue());
        this.scrollPane.setViewportView(baseFunc);
        this.currentFunction = baseFunc;
        this.updatePreview();
        this.lowerPanel.validate();
        this.lowerPanel.revalidate();
        this.lowerPanel.repaint();
    }

    public void updatePreview() {
        this.updatePreview(null);
    }

    public void updatePreview(Point point) {
        if (point == null || !this.preview.getBounds().contains(point)) {
            this.preview.preview(this.currentFunction, this);
        }
    }

    public String getBreed() {
        return this.breed;
    }

    public void setBreed(String string) {
        this.breed = string;
    }

    public String toString() {
        return this.getBreed();
    }

    public BaseFunc getFunction(String string) {
        Iterator iterator = this.pages.iterator();
        while (iterator.hasNext()) {
            BaseFunc baseFunc = (BaseFunc)iterator.next();
            if (!baseFunc.getName().equals(string)) continue;
            return baseFunc;
        }
        return null;
    }

    public void updateFuncBreeds() {
        Iterator iterator = this.pages.iterator();
        while (iterator.hasNext()) {
            ((BaseFunc)iterator.next()).updateBreeds();
        }
    }

    public BreedProps getProps() {
        return this.properties;
    }

    public String writeFunction(BaseFunc baseFunc) {
        String string = "";
        String string2 = "-";
        if (baseFunc == null) {
            return null;
        }
        string = this.breed.startsWith("<") ? "to " + baseFunc.getCommand() + "\n" : "to " + baseFunc.getCommand() + string2 + this.breed + "\n";
        return string + baseFunc.getBody() + "\n";
    }

    public String writeFunctions(boolean bl) {
        return this.writeFunctions(null, bl);
    }

    public String writeFunctions(String string, boolean bl) {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        String string2 = "";
        if (baseFuncArray == null) {
            return string2;
        }
        int n = 0;
        while (n < baseFuncArray.length) {
            if (bl == baseFuncArray[n].isObsFunc()) {
                string2 = string2 + this.writeFunction(baseFuncArray[n]) + "\n";
            }
            ++n;
        }
        return string2;
    }

    public String writeSliders() {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        String string = "";
        if (baseFuncArray == null) {
            return string;
        }
        int n = 0;
        while (n < baseFuncArray.length) {
            string = string + baseFuncArray[n].writeSliders();
            ++n;
        }
        return string;
    }

    public void makeSliders() {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        if (baseFuncArray == null) {
            return;
        }
        Interface interface_ = this.t.app.iface;
        int n = 0;
        while (n < baseFuncArray.length) {
            SliderInfo[] sliderInfoArray = baseFuncArray[n].getSliderInfo();
            if (sliderInfoArray != null) {
                int n2 = 0;
                while (n2 < sliderInfoArray.length) {
                    System.out.println("writing slider " + n2);
                    sliderInfoArray[n2].makeSlider(interface_);
                    ++SliderInfo.sliders;
                    SliderInfo.y += 30;
                    ButtonInfo.y += 30;
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void makeButtons() {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        if (baseFuncArray == null) {
            return;
        }
        Interface interface_ = this.t.app.iface;
        int n = 0;
        while (n < baseFuncArray.length) {
            ButtonInfo[] buttonInfoArray = baseFuncArray[n].getButtonInfo();
            if (buttonInfoArray != null) {
                int n2 = 0;
                while (n2 < buttonInfoArray.length) {
                    System.out.println("writing button " + n2);
                    buttonInfoArray[n2].makeButton(interface_);
                    ++ButtonInfo.buttons;
                    SliderInfo.y += 40;
                    ButtonInfo.y += 40;
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String writeButtons() {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        String string = "";
        if (baseFuncArray == null) {
            return string;
        }
        Interface interface_ = this.t.app.iface;
        int n = 0;
        while (n < baseFuncArray.length) {
            string = string + baseFuncArray[n].writeButtons();
            ++n;
        }
        return string;
    }

    public String writeVariables(String string, int n) {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        String string2 = new String(string);
        if (baseFuncArray == null) {
            return string2;
        }
        int n2 = 0;
        while (n2 < baseFuncArray.length) {
            String[] stringArray = baseFuncArray[n2].getVariables(n);
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string2.indexOf(stringArray[n3]) == -1) {
                        string2 = string2 + stringArray[n3] + " ";
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return string2;
    }

    public String[] getAllFuncNames() {
        BaseFunc[] baseFuncArray = this.getAllFuncs();
        String[] stringArray = new String[baseFuncArray.length];
        int n = 0;
        while (n < baseFuncArray.length) {
            stringArray[n] = baseFuncArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public BaseFunc[] getDefinedFuncs() {
        return this.properties.getDefinedFuncs();
    }

    public BaseFunc[] getAllFuncs() {
        return (BaseFunc[])this.pages.toArray(new BaseFunc[0]);
    }

    public String save() {
        String string = breedFuncsWord + " " + this.getBreed() + "\n";
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        if (baseFuncArray == null) {
            return string;
        }
        int n = 0;
        while (n < baseFuncArray.length) {
            string = string + baseFuncArray[n].save();
            ++n;
        }
        return string;
    }

    public boolean load(String string) {
        return this.load(string, false);
    }

    public boolean load(String string, boolean bl) {
        if (bl) {
            this.removeAll();
            this.addFunctions();
        }
        String[] stringArray = Util.split(string, BaseFunc.functionWord + " ");
        boolean bl2 = true;
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string2;
            BaseFunc baseFunc;
            stringArray[n] = stringArray[n].trim();
            if (!stringArray[n].equals("") && (baseFunc = this.getFunction(string2 = stringArray[n].substring(0, n2 = stringArray[n].indexOf("\n")))) != null) {
                boolean bl3 = bl2 = bl2 && baseFunc.load(stringArray[n]);
                if (bl2) {
                    this.properties.addFunc(baseFunc);
                }
            }
            ++n;
        }
        return bl2;
    }

    public BreedFuncs(String string, Template template) {
        this.breed = string;
        this.t = template;
    }
}

