/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import starlogo.BlueGrid;
import starlogo.Interface;
import starlogo.Widget;
import yoyo.YoYo;

public class WidgetDrag
extends Widget {
    public static final int CORNER_WIDTH = 8;
    public static int xHandle = 0;
    public static int yHandle = 0;
    public int MIN_WIDTH = 30;
    public int MIN_HEIGHT = 30;
    protected boolean selected = false;
    Rectangle oldPosition = new Rectangle();

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    protected void drawCorners(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(-8, -8, 8, 8);
        graphics.fillRect(this.position.width, -8, 8, 8);
        graphics.fillRect(this.position.width, this.position.height, 8, 8);
        graphics.fillRect(-8, this.position.height, 8, 8);
        graphics.translate(-this.position.x, -this.position.y);
    }

    public void checkBounds(Rectangle rectangle) {
        if (this.position.x < rectangle.x) {
            this.position.x = rectangle.x;
        }
        if (this.position.y < rectangle.y) {
            this.position.y = rectangle.y;
        }
        if (this.position.x + this.position.width > rectangle.x + rectangle.width) {
            this.position.width = rectangle.x + rectangle.width - this.position.x;
        }
        if (this.position.y + this.position.height > rectangle.y + rectangle.height) {
            this.position.height = rectangle.y + rectangle.height - this.position.y;
        }
    }

    public void resize(Point point, int n) {
        this.parent.addHandlesToClipRect(this);
        int n2 = point.x;
        int n3 = point.y;
        switch (n) {
            case 1: {
                if (this.position.width - n2 + this.position.x < this.MIN_WIDTH) {
                    n2 = -this.MIN_WIDTH + this.position.x + this.position.width;
                }
                if (this.position.height - n3 + this.position.y < this.MIN_HEIGHT) {
                    n3 = -this.MIN_HEIGHT + this.position.y + this.position.height;
                }
                this.position.width -= n2 - this.position.x;
                this.position.x = n2;
                this.position.height -= n3 - this.position.y;
                this.position.y = n3;
                break;
            }
            case 3: {
                if (this.position.width - n2 + this.position.x < this.MIN_WIDTH) {
                    n2 = -this.MIN_WIDTH + this.position.x + this.position.width;
                }
                if (n3 - this.position.y < this.MIN_HEIGHT) {
                    n3 = this.MIN_HEIGHT + this.position.y;
                }
                this.position.width -= n2 - this.position.x;
                this.position.x = n2;
                this.position.height += n3 - this.position.y - this.position.height;
                break;
            }
            case 4: {
                if (n2 - this.position.x < this.MIN_WIDTH) {
                    n2 = this.MIN_WIDTH + this.position.x;
                }
                if (n3 - this.position.y < this.MIN_HEIGHT) {
                    n3 = this.MIN_HEIGHT + this.position.y;
                }
                this.position.width += n2 - this.position.x - this.position.width;
                this.position.height += n3 - this.position.y - this.position.height;
                break;
            }
            case 2: {
                if (n2 - this.position.x < this.MIN_WIDTH) {
                    n2 = this.MIN_WIDTH + this.position.x;
                }
                if (this.position.height - n3 + this.position.y < this.MIN_HEIGHT) {
                    n3 = -this.MIN_HEIGHT + this.position.y + this.position.height;
                }
                this.position.width += n2 - this.position.x - this.position.width;
                this.position.height -= n3 - this.position.y;
                this.position.y = n3;
                break;
            }
            case 8: {
                if (n2 - this.position.x < this.MIN_WIDTH) {
                    n2 = this.MIN_WIDTH + this.position.x;
                }
                this.position.width += n2 - this.position.x - this.position.width;
                break;
            }
            case 7: {
                if (this.position.width - n2 + this.position.x < this.MIN_WIDTH) {
                    n2 = -this.MIN_WIDTH + this.position.x + this.position.width;
                }
                this.position.width -= n2 - this.position.x;
                this.position.x = n2;
                break;
            }
            case 5: {
                if (this.position.height - n3 + this.position.y < this.MIN_HEIGHT) {
                    n3 = -this.MIN_HEIGHT + this.position.y + this.position.height;
                }
                this.position.height -= n3 - this.position.y;
                this.position.y = n3;
                break;
            }
            case 6: {
                if (n3 - this.position.y < this.MIN_HEIGHT) {
                    n3 = this.MIN_HEIGHT + this.position.y;
                }
                this.position.height += n3 - this.position.y - this.position.height;
                break;
            }
        }
        this.parent.addHandlesToClipRect(this);
    }

    void moveBy(Point point) {
        this.position.translate(point.x, point.y);
    }

    public boolean resizable() {
        return true;
    }

    public boolean draggable(MouseEvent mouseEvent) {
        return YoYo.applet == null;
    }

    public int resizeWhichCorner(Point point) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.position.x - 8, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 1;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 2;
        }
        rectangle.setBounds(this.position.x - 8, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 3;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 4;
        }
        return 0;
    }

    public boolean intersects(Rectangle rectangle) {
        if (this.selected) {
            Rectangle rectangle2 = new Rectangle(this.position);
            rectangle2.grow(8, 8);
            return rectangle2.intersects(rectangle);
        }
        return super.intersects(rectangle);
    }

    public boolean cornerContains(Point point) {
        return this.resizeWhichCorner(point) != 0;
    }

    public boolean contains(int n, int n2) {
        return super.contains(n, n2);
    }

    public int getToolbarButton() {
        return 0;
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        return null;
    }

    public static String editionString(int n) {
        if (n == 1) {
            return "";
        }
        return " " + n;
    }

    public void snapToGrid() {
        this.parent.addToClipRect(this.position);
        int n = this.position.x;
        int n2 = this.position.y;
        int n3 = n % BlueGrid.gridunit;
        int n4 = (n2 - this.parent.toolbarheight()) % BlueGrid.gridunit;
        if (n3 != 0) {
            this.position.x -= n3;
        }
        if (n4 != 0) {
            this.position.y -= n4;
        }
        this.parent.addToClipRect(this.position);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.parent.trashwidget().pressed()) {
            this.parent.trashwidget().execute();
        }
        if (this.parent.snapToGrid()) {
            this.snapToGrid();
        }
        this.parent.maybeReleasePatchCanvas();
    }

    public WidgetDrag(Interface interface_, Image image) {
        super(interface_, image);
    }

    public WidgetDrag(Interface interface_) {
        super(interface_);
    }

    public WidgetDrag() {
    }

    protected WidgetDrag(WidgetDrag widgetDrag) {
        this.selected = widgetDrag.selected;
        this.oldPosition = widgetDrag.oldPosition;
        this.mouseDown = widgetDrag.mouseDown;
    }
}

