/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import starlogo.ButtonWidget;
import starlogo.Interface;
import starlogo.MonitorWidget;
import starlogo.SliderWidget;
import starlogo.TextWidget;
import starlogo.WidgetLite;

public abstract class Widget
extends WidgetLite {
    public static int trackerID = 0;
    public Interface parent;
    protected boolean mouseDown = false;

    public void execute() {
        this.execute(null);
    }

    public void execute(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            this.mouseClicked(mouseEvent);
        }
    }

    void moveToFront() {
        this.parent.moveToFront(this);
        this.parent.repaint(this.position);
    }

    void mouseDoubleClicked(MouseEvent mouseEvent) {
        if (this.isSelected()) {
            this.edit();
            this.parent.deselect(this);
        }
    }

    public boolean isSelected() {
        return false;
    }

    public void delete() {
        this.removeToolTip();
    }

    public void edit() {
        this.parent.deselect(this);
        this.parent.addHandlesToClipRect(this);
        this.parent.getToolbar().setButtonDown(1);
    }

    public boolean resizable() {
        return false;
    }

    public boolean draggable(MouseEvent mouseEvent) {
        return false;
    }

    public int resizeWhichCorner(Point point) {
        return 0;
    }

    public void resize(Point point, int n) {
    }

    public void endResize(MouseEvent mouseEvent, int n) {
    }

    public static boolean editableWidget(Widget widget) {
        return widget instanceof ButtonWidget || widget instanceof TextWidget || widget instanceof SliderWidget || widget instanceof MonitorWidget;
    }

    public void displayToolTip(Point point) {
        Object object = this.toolTipLock;
        synchronized (object) {
            if (this.toolTip != null && !this.showingToolTip && this.parent != null) {
                if (this.parent.sl() != null && this.parent.sl().runningnowp) {
                    this.toolTip.setPosition(this.position, this.parent.getPatchCanvas().position);
                } else {
                    this.toolTip.setPosition(this.position);
                }
                this.parent.setTooltipWidget(this.toolTip);
                this.showingToolTip = true;
                this.parent.repaint(this.toolTip.position);
            }
        }
    }

    public void dropToolTip() {
        if (this.toolTip != null && this.showingToolTip && this.parent != null) {
            this.showingToolTip = false;
            this.parent.setTooltipWidget(null);
            this.parent.repaint(this.toolTip.position);
        }
    }

    public Widget(Interface interface_, Image image) {
        super(interface_, image);
        this.parent = interface_;
        this.image = image;
        this.position = new Rectangle(0, 0, image == null ? 0 : image.getWidth(this), image == null ? 0 : image.getHeight(this));
    }

    public Widget(Interface interface_) {
        super(interface_);
        this.parent = interface_;
    }

    public Widget() {
        this.position = new Rectangle(0, 0, 10, 10);
    }
}

