/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import starlogo.MonitorWidget;
import starlogo.SliderWidget;
import starlogo.StarLogo;
import starlogo.StarLogoError;
import yoyo.Base64;
import yoyo.Ilist;
import yoyo.Symbol;

public class Utilities {
    public static String[] stringTable = new String[1];
    public static Hashtable stringHash = new Hashtable(1);
    public static int stringptr = 0;
    public static Symbol[] symbolTable = new Symbol[1];
    public static Hashtable symbolHash = new Hashtable(1);
    public static int symbolptr = 0;
    public static Double[] doubleTable = new Double[1];
    public static Hashtable doubleHash = new Hashtable(1);
    public static int doubleptr = 0;
    public static Object[][] listTable = new Object[1][];
    public static Hashtable listHash = new Hashtable(1);
    public static int[][] savedListTable = new int[1][];
    public static int listptr = 0;
    public static final int INTTYPE = 1;
    public static final int DOUBLETYPE = 2;
    public static final int SYMBOLTYPE = 3;
    public static final int STRINGTYPE = 4;
    public static final int LISTTYPE = 5;

    public static void clearTable() {
        stringTable = new String[1];
        stringHash.clear();
        stringptr = 0;
        symbolTable = new Symbol[1];
        symbolHash.clear();
        symbolptr = 0;
        doubleTable = new Double[1];
        doubleHash.clear();
        doubleptr = 0;
        listTable = new Object[1][];
        listHash.clear();
        savedListTable = new int[1][];
        listptr = 0;
    }

    public static Object[] sortTable(Hashtable hashtable) {
        Object[] objectArray = new Object[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectArray[((Integer)hashtable.get(k)).intValue()] = k;
        }
        return objectArray;
    }

    public static void dumpStringTable(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(stringptr);
        Object[] objectArray = Utilities.sortTable(stringHash);
        int n = 0;
        while (n < stringptr) {
            String string = (String)objectArray[n];
            dataOutputStream.writeUTF(string);
            ++n;
        }
    }

    public static void dumpSymbolTable(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(symbolptr);
        Object[] objectArray = Utilities.sortTable(symbolHash);
        int n = 0;
        while (n < symbolptr) {
            Symbol symbol = (Symbol)objectArray[n];
            dataOutputStream.writeUTF(symbol.name);
            ++n;
        }
    }

    public static void dumpDoubleTable(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(doubleptr);
        Object[] objectArray = Utilities.sortTable(doubleHash);
        int n = 0;
        while (n < doubleptr) {
            Double d = (Double)objectArray[n];
            dataOutputStream.writeDouble(d);
            ++n;
        }
    }

    public static void dumpListTable(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(listptr);
        int n = 0;
        while (n < listptr) {
            int[] nArray = savedListTable[n];
            dataOutputStream.writeInt(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                dataOutputStream.writeInt(nArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public static void loadStringTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        stringTable = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Utilities.stringTable[n2] = dataInputStream.readUTF();
            ++n2;
        }
        stringptr = n;
    }

    public static void loadSymbolTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        symbolTable = new Symbol[n];
        int n2 = 0;
        while (n2 < n) {
            Utilities.symbolTable[n2] = Symbol.lookup(dataInputStream.readUTF());
            ++n2;
        }
        symbolptr = n;
    }

    public static void loadDoubleTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        doubleTable = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            double d = dataInputStream.readDouble();
            Utilities.doubleTable[n2] = new Double(d);
            ++n2;
        }
        doubleptr = n;
    }

    public static void loadListTable(DataInputStream dataInputStream) throws IOException {
        int n;
        Object[] objectArray;
        int n2 = dataInputStream.readInt();
        listTable = new Object[n2][];
        savedListTable = new int[n2][];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInputStream.readInt();
            objectArray = new Object[n4];
            Utilities.listTable[n3] = objectArray;
            int[] nArray = new int[n4];
            Utilities.savedListTable[n3] = nArray;
            n = 0;
            while (n < n4) {
                nArray[n] = dataInputStream.readInt();
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            Object[] objectArray2 = listTable[n3];
            objectArray = savedListTable[n3];
            int n5 = objectArray2.length;
            n = 0;
            while (n < n5) {
                objectArray2[n] = Utilities.lookupInTable((int)objectArray[n]);
                ++n;
            }
            ++n3;
        }
        listptr = n2;
    }

    public static int addIntoTable(String string) {
        Object var1_1 = null;
        Object v = stringHash.get(string);
        var1_1 = v;
        if (v != null) {
            return 0x4000000 | (Integer)var1_1;
        }
        stringHash.put(string, new Integer(stringptr));
        return 0x4000000 | stringptr++;
    }

    public static int addIntoTable(Symbol symbol) {
        Object var1_1 = null;
        Object v = symbolHash.get(symbol);
        var1_1 = v;
        if (v != null) {
            return 0x3000000 | (Integer)var1_1;
        }
        symbolHash.put(symbol, new Integer(symbolptr));
        return 0x3000000 | symbolptr++;
    }

    public static int addIntoTable(Double d) {
        Object var1_1 = null;
        Object v = doubleHash.get(d);
        var1_1 = v;
        if (v != null) {
            return 0x2000000 | (Integer)var1_1;
        }
        doubleHash.put(d, new Integer(doubleptr));
        return 0x2000000 | doubleptr++;
    }

    public static int addIntoTable(int n) {
        if ((n >>> 24 & 0xFF) != 0) {
            return Utilities.addIntoTable(new Double(n));
        }
        return 0x1000000 | n;
    }

    public static int addIntoTable(Integer n) {
        int n2 = n;
        if ((n2 >>> 24 & 0xFF) != 0) {
            return Utilities.addIntoTable(new Double(n2));
        }
        return 0x1000000 | n2;
    }

    public static int addIntoTable(SliderWidget sliderWidget) {
        return Utilities.addIntoTable(sliderWidget.id);
    }

    public static int addIntoTable(MonitorWidget monitorWidget) {
        return Utilities.addIntoTable(monitorWidget.id);
    }

    public static int addIntoTable(Object[] objectArray, StarLogo starLogo) {
        Object object;
        Object var2_2 = null;
        Object v = listHash.get(objectArray);
        var2_2 = v;
        if (v != null) {
            return 0x5000000 | (Integer)var2_2;
        }
        if (listptr >= savedListTable.length) {
            object = new int[savedListTable.length * 2][];
            System.arraycopy(savedListTable, 0, object, 0, savedListTable.length);
            savedListTable = object;
        }
        listHash.put(objectArray, new Integer(listptr));
        object = new int[objectArray.length];
        int n = listptr++;
        Utilities.savedListTable[n] = (int[])object;
        int n2 = 0;
        while (n2 < objectArray.length) {
            object[n2] = (int[])Utilities.addIntoTable(objectArray[n2], starLogo);
            ++n2;
        }
        return 0x5000000 | n;
    }

    public static int addIntoTable(Object object, StarLogo starLogo) {
        if (object instanceof String) {
            return Utilities.addIntoTable((String)object);
        }
        if (object instanceof Symbol) {
            return Utilities.addIntoTable((Symbol)object);
        }
        if (object instanceof Double) {
            return Utilities.addIntoTable((Double)object);
        }
        if (object instanceof Integer) {
            return Utilities.addIntoTable((Integer)object);
        }
        if (object instanceof Object[]) {
            return Utilities.addIntoTable((Object[])object, starLogo);
        }
        if (object instanceof SliderWidget) {
            return Utilities.addIntoTable((SliderWidget)object);
        }
        if (object instanceof MonitorWidget) {
            return Utilities.addIntoTable((MonitorWidget)object);
        }
        if (object instanceof Ilist) {
            return Utilities.addIntoTable(((Ilist)object).list, starLogo);
        }
        StarLogoError.error(starLogo.app, "Can't save object of type " + object.getClass(), true);
        return 0;
    }

    public static Object lookupInTable(int n) {
        int n2 = n >>> 24 & 0xFF;
        switch (n2) {
            case 4: {
                return stringTable[n & 0xFFFFFF];
            }
            case 3: {
                return symbolTable[n & 0xFFFFFF];
            }
            case 2: {
                return doubleTable[n & 0xFFFFFF];
            }
            case 5: {
                return listTable[n & 0xFFFFFF];
            }
            case 1: {
                return new Integer(n & 0xFFFFFF);
            }
        }
        return null;
    }

    public static int writeIntoByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
        return 4;
    }

    public static int writeIntoByteArray(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        Utilities.writeIntoByteArray((int)(l >>> 32), byArray, n);
        Utilities.writeIntoByteArray((int)(l & 0xFFFFFFFFL), byArray, n + 4);
        double d2 = Utilities.readDoubleFromByteArray(byArray, n);
        return 8;
    }

    public static int writeIntoByteArray(boolean bl, byte[] byArray, int n) {
        byArray[n] = bl ? (byte)1 : 0;
        return 1;
    }

    public static int readIntFromByteArray(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    public static double readDoubleFromByteArray(byte[] byArray, int n) {
        long l = ((long)Utilities.readIntFromByteArray(byArray, n) << 32) + ((long)Utilities.readIntFromByteArray(byArray, n + 4) & 0xFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }

    public static boolean readBooleanFromByteArray(byte[] byArray, int n) {
        byte by = byArray[n];
        return by != 0;
    }

    public static int getEntrySize(byte[] byArray) {
        int n = byArray.length - 4;
        return Utilities.readIntFromByteArray(byArray, n);
    }

    public static void setEntrySize(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write((byte)(n >> 24 & 0xFF));
        byteArrayOutputStream.write((byte)(n >> 16 & 0xFF));
        byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
        byteArrayOutputStream.write((byte)(n & 0xFF));
    }

    public static byte[] gzipByteArray(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.finish();
        ((FilterOutputStream)gZIPOutputStream).flush();
        Utilities.setEntrySize(byteArrayOutputStream, byArray.length);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzipByteArray(byte[] byArray) throws IOException {
        int n = Utilities.getEntrySize(byArray);
        try {
            int n2;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = new byte[n];
            int n3 = 0;
            while ((n2 = gZIPInputStream.read(byArray2, n3, n - n3)) >= 0 && (n3 += n2) < n) {
            }
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String printable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                stringBuffer.append("\\\"");
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String saveIlist(int[] nArray) throws IOException {
        byte[] byArray = new byte[nArray.length * 4];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            Utilities.writeIntoByteArray(nArray[n2], byArray, n);
            n += 4;
            ++n2;
        }
        byte[] byArray2 = Utilities.gzipByteArray(byArray);
        return Base64.encode(byArray2);
    }

    public static int[] restoreIlist(String string, int n) throws IOException {
        byte[] byArray = Utilities.gunzipByteArray(Base64.decode(string.getBytes()));
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = Utilities.readIntFromByteArray(byArray, n2);
            n2 += 4;
            ++n3;
        }
        return nArray;
    }

    public static String saveOlist(Object[] objectArray, StarLogo starLogo) throws IOException {
        byte[] byArray = new byte[objectArray.length * 4];
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = Utilities.addIntoTable(objectArray[n2], starLogo);
            Utilities.writeIntoByteArray(n3, byArray, n);
            n += 4;
            ++n2;
        }
        byte[] byArray2 = Utilities.gzipByteArray(byArray);
        return Base64.encode(byArray2);
    }

    public static Object[] restoreOlist(String string, int n) throws IOException {
        byte[] byArray = Utilities.gunzipByteArray(Base64.decode(string.getBytes()));
        Object[] objectArray = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4 = Utilities.readIntFromByteArray(byArray, n2);
            n2 += 4;
            objectArray[n3] = Utilities.lookupInTable(n4);
            ++n3;
        }
        return objectArray;
    }
}

