/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import starlogo.Application;
import starlogo.Colors;
import starlogo.IntHashtable;
import starlogo.StarLogoError;
import starlogo.Turtle;
import starlogo.Utilities;
import yoyo.Base64;
import yoyo.PrimFile;
import yoyo.YoYo;

public class TurtleShapes {
    public static final int MAXSHAPES = 64;
    public static final int ON = -1;
    public static final int OFF = 0;
    public static final int SMALL = 8;
    public static final int MEDIUM = 16;
    public static final int LARGE = 32;
    static TurtleShapes[] shapes = new TurtleShapes[64];
    static int numShapes = 0;
    static ShapeClipboard clipboard = null;
    String name;
    int id;
    boolean rotatep;
    double[][] colors8x8 = new double[16][];
    int[][] masks8x8 = new int[16][];
    double[][] colors16x16 = new double[16][];
    int[][] masks16x16 = new int[16][];
    double[][] colors32x32 = new double[16][];
    int[][] masks32x32 = new int[16][];
    IntHashtable shapeImages = new IntHashtable(100);
    private static /* synthetic */ Class class$Lstarlogo$TurtleShapes;

    void reRotateShapes() {
        if (this.rotatep) {
            int n = 1;
            while (n < 16) {
                if (this.colors8x8[n] == null || this.colors8x8[n] == this.colors8x8[0]) {
                    this.colors8x8[n] = new double[64];
                }
                if (this.masks8x8[n] == null || this.masks8x8[n] == this.masks8x8[0]) {
                    this.masks8x8[n] = new int[128];
                }
                TurtleShapes.rotate(n, this.colors8x8[0], this.masks8x8[0], this.colors8x8[n], this.masks8x8[n]);
                if (this.colors16x16[n] == null || this.colors16x16[n] == this.colors16x16[0]) {
                    this.colors16x16[n] = new double[256];
                }
                if (this.masks16x16[n] == null || this.masks16x16[n] == this.masks16x16[0]) {
                    this.masks16x16[n] = new int[512];
                }
                TurtleShapes.rotate(n, this.colors16x16[0], this.masks16x16[0], this.colors16x16[n], this.masks16x16[n]);
                if (this.colors32x32[n] == null || this.colors32x32[n] == this.colors32x32[0]) {
                    this.colors32x32[n] = new double[1024];
                }
                if (this.masks32x32[n] == null || this.masks32x32[n] == this.masks32x32[0]) {
                    this.masks32x32[n] = new int[2048];
                }
                TurtleShapes.rotate(n, this.colors32x32[0], this.masks32x32[0], this.colors32x32[n], this.masks32x32[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < 16) {
                this.colors8x8[n] = this.colors8x8[0];
                this.masks8x8[n] = this.masks8x8[0];
                this.colors16x16[n] = this.colors16x16[0];
                this.masks16x16[n] = this.masks16x16[0];
                this.colors32x32[n] = this.colors32x32[0];
                this.masks32x32[n] = this.masks32x32[0];
                ++n;
            }
        }
    }

    double[][] getColorsForSize(int n) {
        switch (n) {
            case 8: {
                return this.colors8x8;
            }
            case 16: {
                return this.colors16x16;
            }
            case 32: {
                return this.colors32x32;
            }
        }
        return null;
    }

    int[][] getMasksForSize(int n) {
        switch (n) {
            case 8: {
                return this.masks8x8;
            }
            case 16: {
                return this.masks16x16;
            }
            case 32: {
                return this.masks32x32;
            }
        }
        return null;
    }

    void setColorsForSize(double[] dArray, int n) {
        switch (n) {
            case 8: {
                this.colors8x8[0] = dArray;
                break;
            }
            case 16: {
                this.colors16x16[0] = dArray;
                break;
            }
            case 32: {
                this.colors32x32[0] = dArray;
                break;
            }
        }
    }

    void setMasksForSize(int[] nArray, int n) {
        switch (n) {
            case 8: {
                this.masks8x8[0] = nArray;
                break;
            }
            case 16: {
                this.masks16x16[0] = nArray;
                break;
            }
            case 32: {
                this.masks32x32[0] = nArray;
                break;
            }
        }
    }

    Image getShapeAsImage(Turtle turtle, int n) {
        double[][] dArray = this.getColorsForSize(n);
        int[][] nArray = this.getMasksForSize(n);
        int n2 = dArray[0].length;
        int[] nArray2 = new int[n2 * 16];
        int n3 = 0;
        int n4 = (int)(turtle.color * 32.0);
        int n5 = Colors.colorarrayints[n4];
        int n6 = 0;
        while (n6 < 16) {
            int n7 = n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = 0;
                while (n9 < n) {
                    int n10 = Colors.colorarrayints[(int)(dArray[n6][n9 + n8 * n] * 32.0)];
                    nArray2[n7 + n9] = nArray[n6][(n9 + n8 * n) * 2] == -1 ? n5 : (nArray[n6][(n9 + n8 * n) * 2 + 1] == -1 ? 0 : n10);
                    ++n9;
                }
                n7 += n * 16;
                ++n8;
            }
            n3 += n;
            ++n6;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n * 16, n, Colors.tcm, nArray2, 0, n * 16));
    }

    static void clearHash() {
        if (shapes == null) {
            return;
        }
        int n = 0;
        while (n < shapes.length) {
            if (shapes[n] != null && TurtleShapes.shapes[n].shapeImages != null) {
                TurtleShapes.shapes[n].shapeImages.clear();
            }
            ++n;
        }
    }

    static int shapeHash(int n, int n2) {
        n2 = ((n2 >> 3) - 1 & 3) << 16;
        return n2 | (n &= 0x1FFF);
    }

    static Image getShapeAsImage(Turtle turtle, int n, Application application) {
        TurtleShapes turtleShapes = TurtleShapes.getShape(turtle.shape);
        int n2 = (int)((turtle.heading + 11.25) / 22.5 % 16.0);
        int n3 = (int)(turtle.color * 32.0);
        int n4 = TurtleShapes.shapeHash(n3, n);
        Image image = (Image)turtleShapes.shapeImages.get(n4);
        if (image != null) {
            return image;
        }
        image = turtleShapes.getShapeAsImage(turtle, n);
        turtleShapes.shapeImages.put(n4, (Object)image);
        return image;
    }

    /*
     * Unable to fully structure code
     */
    static void loadDefaultShapes(Application var0) {
        block3: {
            try {
                var1_1 = (TurtleShapes.class$Lstarlogo$TurtleShapes != null ? TurtleShapes.class$Lstarlogo$TurtleShapes : (TurtleShapes.class$Lstarlogo$TurtleShapes = TurtleShapes.class$("starlogo.TurtleShapes"))).getResource("default-shapes.sls");
                var2_3 = (String)PrimFile.prim_urltostring(var1_1, var0.sl.c);
                TurtleShapes.loadShapes(var2_3, true, var0);
                break block3;
            }
            catch (Exception var1_2) {
                var0.err.println("Default shapes didn't load properly.");
                var1_2.printStackTrace(var0.err);
                TurtleShapes.setShapeToSquareShape(1, var0);
                TurtleShapes.setShapeToTurtleShape(0, var0);
                TurtleShapes.setShapeToPersonShape(2, var0);
                var2_4 = 3;
                ** while (var2_4 < 64)
            }
lbl-1000:
            // 1 sources

            {
                TurtleShapes.setShapeToBlankShape(var2_4, var0);
                TurtleShapes.shapes[var2_4].name = "shape-" + var2_4;
                ++var2_4;
                continue;
            }
lbl19:
            // 1 sources

            TurtleShapes.numShapes = 64;
        }
    }

    static void setName(String string, int n) {
        if (string == null) {
            string = "";
        }
        if (shapes[n] != null) {
            TurtleShapes.shapes[n].name = string;
        }
    }

    static boolean conflictingShapeName(String string, int n) {
        int n2 = 0;
        while (n2 < 64) {
            if (n2 != n && shapes[n2] != null && string.equalsIgnoreCase(TurtleShapes.shapes[n2].name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static String[] getShapeNames() {
        String[] stringArray = new String[64];
        int n = 0;
        while (n < 64) {
            stringArray[n] = shapes[n] != null ? TurtleShapes.shapes[n].name : "";
            ++n;
        }
        return stringArray;
    }

    static int calculateNumShapes() {
        int n = 0;
        int n2 = 0;
        while (n2 < shapes.length) {
            if (shapes[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    static TurtleShapes getShape(int n) {
        if (n < 0 || n >= 64) {
            return null;
        }
        return shapes[n];
    }

    static double[] copyColors(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    static int[] copyMasks(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    TurtleShapes copy() {
        double[] dArray = TurtleShapes.copyColors(this.colors8x8[0]);
        int[] nArray = TurtleShapes.copyMasks(this.masks8x8[0]);
        double[] dArray2 = TurtleShapes.copyColors(this.colors16x16[0]);
        int[] nArray2 = TurtleShapes.copyMasks(this.masks16x16[0]);
        double[] dArray3 = TurtleShapes.copyColors(this.colors32x32[0]);
        int[] nArray3 = TurtleShapes.copyMasks(this.masks32x32[0]);
        return new TurtleShapes(this.name, -1, dArray, nArray, dArray2, nArray2, dArray3, nArray3, this.rotatep);
    }

    static void cutShape(int n, Application application) {
        clipboard = new ShapeClipboard(n, true);
        TurtleShapes.setShapeToBlankShape(n, application);
    }

    static void copyShape(int n, Application application) {
        clipboard = new ShapeClipboard(n, false);
    }

    static void pasteShape(int n) {
        if (clipboard == null) {
            return;
        }
        TurtleShapes.shapes[n] = TurtleShapes.clipboard.shape.copy();
        if (!TurtleShapes.clipboard.cutp) {
            String string;
            int n2 = 2;
            TurtleShapes.shapes[n].name = string = TurtleShapes.shapes[n].name + "-copy";
            while (TurtleShapes.conflictingShapeName(TurtleShapes.shapes[n].name, n)) {
                TurtleShapes.shapes[n].name = string + "-" + n2++;
            }
        }
        TurtleShapes.shapes[n].id = n;
    }

    static void setShapeToBlankShape(int n, Application application) {
        int[] nArray = TurtleShapes.createBlankMasks(8);
        double[] dArray = TurtleShapes.createBlankColors(8);
        int[] nArray2 = TurtleShapes.createBlankMasks(16);
        double[] dArray2 = TurtleShapes.createBlankColors(16);
        int[] nArray3 = TurtleShapes.createBlankMasks(32);
        double[] dArray3 = TurtleShapes.createBlankColors(32);
        String string = "unknown";
        TurtleShapes.shapes[n] = new TurtleShapes(string, n, dArray, nArray, dArray2, nArray2, dArray3, nArray3, false);
    }

    static void setShapeToSquareShape(int n, Application application) {
        int[] nArray = new int[128];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = -1;
            nArray[n2 + 1] = 0;
            n2 += 2;
        }
        double[] dArray = TurtleShapes.createBlankColors(8);
        double[] dArray2 = new double[256];
        int[] nArray2 = new int[512];
        TurtleShapes.resize(dArray, nArray, 16, dArray2, nArray2, application);
        double[] dArray3 = new double[1024];
        int[] nArray3 = new int[2048];
        TurtleShapes.resize(dArray, nArray, 32, dArray3, nArray3, application);
        String string = YoYo.language == 0 ? "square-shape" : "forma-de-cuadrado";
        TurtleShapes.shapes[n] = new TurtleShapes(string, n, dArray, nArray, dArray2, nArray2, dArray3, nArray3, false);
    }

    static void setShapeToTurtleShape(int n, Application application) {
        double[] dArray = new double[256];
        int[] nArray = new int[512];
        TurtleShapes.makeTurtleCase(dArray, nArray);
        double[] dArray2 = new double[64];
        int[] nArray2 = new int[128];
        TurtleShapes.resize(dArray, nArray, 8, dArray2, nArray2, application);
        double[] dArray3 = new double[1024];
        int[] nArray3 = new int[2048];
        TurtleShapes.resize(dArray, nArray, 32, dArray3, nArray3, application);
        String string = YoYo.language == 0 ? "turtle-shape" : "forma-de-tortuga";
        TurtleShapes.shapes[n] = new TurtleShapes(string, n, dArray2, nArray2, dArray, nArray, dArray3, nArray3, true);
    }

    static void setShapeToPersonShape(int n, Application application) {
        double[] dArray = new double[256];
        int[] nArray = new int[512];
        TurtleShapes.makePersonCase(dArray, nArray);
        double[] dArray2 = new double[64];
        int[] nArray2 = new int[128];
        TurtleShapes.resize(dArray, nArray, 8, dArray2, nArray2, application);
        double[] dArray3 = new double[1024];
        int[] nArray3 = new int[2048];
        TurtleShapes.resize(dArray, nArray, 32, dArray3, nArray3, application);
        String string = YoYo.language == 0 ? "person-shape" : "forma-de-figura";
        TurtleShapes.shapes[n] = new TurtleShapes(string, n, dArray2, nArray2, dArray, nArray, dArray3, nArray3, true);
    }

    static double[] createBlankColors(int n) {
        double[] dArray = new double[n * n];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = 0.0;
            n2 += 3;
        }
        return dArray;
    }

    static int[] createBlankMasks(int n) {
        int[] nArray = new int[2 * n * n];
        int n2 = 1;
        while (n2 < nArray.length) {
            nArray[n2] = -1;
            n2 += 2;
        }
        nArray[n * n - n - 2] = -1;
        nArray[n * n - n - 1] = 0;
        nArray[n * n - n] = -1;
        nArray[n * n - n + 1] = 0;
        nArray[n * n + n - 2] = -1;
        nArray[n * n + n - 1] = 0;
        nArray[n * n + n] = -1;
        nArray[n * n + n + 1] = 0;
        return nArray;
    }

    static void makeTurtleCase(double[] dArray, int[] nArray) {
        int n = 0;
        while (n < 256) {
            switch (n) {
                case 23: 
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 75: 
                case 76: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 227: 
                case 228: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 235: 
                case 236: {
                    nArray[2 * n] = -1;
                    nArray[2 * n + 1] = 0;
                    break;
                }
                default: {
                    nArray[2 * n] = 0;
                    nArray[2 * n + 1] = -1;
                }
            }
            ++n;
        }
    }

    static void makePersonCase(double[] dArray, int[] nArray) {
        int n = 0;
        while (n < 256) {
            switch (n) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 32: 
                case 33: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 196: 
                case 197: 
                case 202: 
                case 203: 
                case 212: 
                case 213: 
                case 218: 
                case 219: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 250: 
                case 251: 
                case 252: 
                case 253: {
                    nArray[2 * n] = -1;
                    nArray[2 * n + 1] = 0;
                    break;
                }
                default: {
                    nArray[2 * n] = 0;
                    nArray[2 * n + 1] = -1;
                }
            }
            ++n;
        }
    }

    static int convert(double d, boolean bl, int n) {
        int n2 = (int)Math.round(d);
        if (n == 8) {
            n2 = bl ? Math.round(n2 + 22) : Math.round(n2);
        }
        if (n == 16) {
            n2 = bl ? Math.round(n2 + 22) : Math.round(n2);
        }
        if (n == 32) {
            n2 = bl ? Math.round(1 * (n2 + 22)) : Math.round(1 * n2);
        }
        return n2;
    }

    static void rotate(int n, double[] dArray, int[] nArray, double[] dArray2, int[] nArray2) {
        int n2 = (int)Math.sqrt(dArray.length);
        if (n <= 0 || n >= 16) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        if (n == 0) {
            return;
        }
        if (n == 4) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = n2 * n3 + n4;
                    int n6 = n2 * n4 + (n2 - n3 - 1);
                    dArray2[n6] = dArray[n5];
                    nArray2[2 * n6] = nArray[2 * n5];
                    nArray2[2 * n6 + 1] = nArray[2 * n5 + 1];
                    ++n4;
                }
                ++n3;
            }
            return;
        }
        if (n == 8) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = n2 * (n7 + 1) - (n8 + 1);
                    int n10 = n2 * (n2 - n7 - 1) + n8;
                    dArray2[n10] = dArray[n9];
                    nArray2[2 * n10] = nArray[2 * n9];
                    nArray2[2 * n10 + 1] = nArray[2 * n9 + 1];
                    ++n8;
                }
                ++n7;
            }
            return;
        }
        if (n == 12) {
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n2) {
                    int n13 = n2 * n11 + n12;
                    int n14 = n2 * (n2 - n12 - 1) + n11;
                    dArray2[n14] = dArray[n13];
                    nArray2[2 * n14] = nArray[2 * n13];
                    nArray2[2 * n14 + 1] = nArray[2 * n13 + 1];
                    ++n12;
                }
                ++n11;
            }
            return;
        }
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[3];
        int[] nArray3 = new int[8];
        double[] dArray5 = new double[4];
        double d = Math.sin(-0.3927 * (double)n);
        double d2 = Math.cos(-0.3927 * (double)n);
        int n15 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n16 = 1 - n2;
        while (n16 <= n2 - 1) {
            int n17 = 1 - n2;
            while (n17 <= n2 - 1) {
                int n18;
                d4 = ((double)n17 * d2 - (double)n16 * d) / 2.0;
                d3 = ((double)n16 * d2 + (double)n17 * d) / 2.0;
                double d5 = d4 - (double)((int)d4) + (double)(d4 < 0.0 ? 1 : 0);
                double d6 = d3 - (double)((int)d3) + (double)(d3 < 0.0 ? 1 : 0);
                d5 -= 0.5;
                d6 -= 0.5;
                d4 = (int)d4 - (d4 < 0.0 ? 1 : 0) + n2 / 2;
                d3 = (int)d3 - (d3 < 0.0 ? 1 : 0) + n2 / 2;
                if (d5 < 0.0) {
                    d4 -= 1.0;
                    d5 = -d5;
                } else {
                    d5 = 1.0 - d5;
                }
                if (d6 < 0.0) {
                    d3 -= 1.0;
                    d6 = -d6;
                } else {
                    d6 = 1.0 - d6;
                }
                int n19 = (d3 < 0.0 ? 1 : 0) + (d3 >= (double)(n2 - 1) ? 2 : 0) + (d4 < 0.0 ? 4 : 0) + (d4 >= (double)(n2 - 1) ? 8 : 0);
                if (d3 < -1.0 || d3 >= (double)n2 || d4 < -1.0 || d4 >= (double)n2) {
                    n18 = 0;
                    while (n18 < 4) {
                        nArray3[2 * n18] = 0;
                        nArray3[2 * n18 + 1] = -1;
                        dArray5[n18] = 0.0;
                        ++n18;
                    }
                } else {
                    n18 = 0;
                    while (n18 < 2) {
                        int n20 = (n19 & 5) != 0 ? (n18 == 1 ? -1 : 0) : (nArray3[n18] = nArray[((int)d4 + n2 * (int)d3) * 2 + n18]);
                        int n21 = (n19 & 9) != 0 ? (n18 == 1 ? -1 : 0) : (nArray3[2 + n18] = nArray[((int)d4 + 1 + n2 * (int)d3) * 2 + n18]);
                        int n22 = (n19 & 6) != 0 ? (n18 == 1 ? -1 : 0) : (nArray3[4 + n18] = nArray[((int)d4 + n2 * ((int)d3 + 1)) * 2 + n18]);
                        nArray3[6 + n18] = (n19 & 0xA) != 0 ? (n18 == 1 ? -1 : 0) : nArray[((int)d4 + 1 + n2 * ((int)d3 + 1)) * 2 + n18];
                        ++n18;
                    }
                    dArray5[0] = (n19 & 5) != 0 || nArray3[0] == -1 || nArray3[1] == -1 ? 0.0 : dArray[(int)d4 + n2 * (int)d3];
                    dArray5[1] = (n19 & 9) != 0 || nArray3[2] == -1 || nArray3[3] == -1 ? 0.0 : dArray[(int)d4 + 1 + n2 * (int)d3];
                    dArray5[2] = (n19 & 6) != 0 || nArray3[4] == -1 || nArray3[5] == -1 ? 0.0 : dArray[(int)d4 + n2 * ((int)d3 + 1)];
                    dArray5[3] = (n19 & 0xA) != 0 || nArray3[6] == -1 || nArray3[7] == -1 ? 0.0 : dArray[(int)d4 + 1 + n2 * ((int)d3 + 1)];
                }
                n18 = 0;
                while (n18 < 2) {
                    dArray3[n18] = d5 * d6 * (double)nArray3[n18] + (1.0 - d5) * d6 * (double)nArray3[2 + n18] + d5 * (1.0 - d6) * (double)nArray3[4 + n18] + (1.0 - d5) * (1.0 - d6) * (double)nArray3[6 + n18];
                    ++n18;
                }
                if (dArray3[0] <= dArray3[1] && dArray3[0] <= -1.0 - dArray3[0] - dArray3[1]) {
                    nArray2[n15 * 2] = -1;
                    nArray2[n15 * 2 + 1] = 0;
                    dArray2[n15] = 0.0;
                } else if (dArray3[1] < dArray3[0] && dArray3[1] <= -1.0 - dArray3[0] - dArray3[1]) {
                    nArray2[n15 * 2] = 0;
                    nArray2[n15 * 2 + 1] = -1;
                    dArray2[n15] = 0.0;
                } else {
                    nArray2[n15 * 2] = 0;
                    nArray2[n15 * 2 + 1] = 0;
                    n18 = 0;
                    while (n18 < 3) {
                        dArray4[n18] = d5 * d6 * (double)(Colors.colorarrayints[(int)(dArray5[0] * 32.0)] >> 8 * n18 & 0xFF);
                        int n23 = n18;
                        dArray4[n23] = dArray4[n23] + (1.0 - d5) * d6 * (double)(Colors.colorarrayints[(int)(dArray5[1] * 32.0)] >> 8 * n18 & 0xFF);
                        int n24 = n18;
                        dArray4[n24] = dArray4[n24] + d5 * (1.0 - d6) * (double)(Colors.colorarrayints[(int)(dArray5[2] * 32.0)] >> 8 * n18 & 0xFF);
                        int n25 = n18;
                        dArray4[n25] = dArray4[n25] + (1.0 - d5) * (1.0 - d6) * (double)(Colors.colorarrayints[(int)(dArray5[3] * 32.0)] >> 8 * n18 & 0xFF);
                        int n26 = n18++;
                        dArray4[n26] = dArray4[n26] / (1.0 + dArray3[0] + dArray3[1]);
                    }
                    dArray2[n15] = Colors.mapColorToStarLogoColor(((int)(dArray4[2] + 0.5) << 16) + ((int)(dArray4[1] + 0.5) << 8) + (int)(dArray4[0] + 0.5));
                }
                n17 += 2;
                ++n15;
            }
            n16 += 2;
        }
    }

    static void flipX(double[] dArray, int[] nArray, double[] dArray2, int[] nArray2) {
        int n = (int)Math.sqrt(dArray.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 + n2 * n;
                int n5 = n3 + (n - n2 - 1) * n;
                dArray2[n5] = dArray[n4];
                nArray2[2 * n5] = nArray[2 * n4];
                nArray2[2 * n5 + 1] = nArray[2 * n4 + 1];
                ++n3;
            }
            ++n2;
        }
    }

    static void flipY(double[] dArray, int[] nArray, double[] dArray2, int[] nArray2) {
        int n = (int)Math.sqrt(dArray.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 + n2 * n;
                int n5 = n - n3 - 1 + n2 * n;
                dArray2[n5] = dArray[n4];
                nArray2[2 * n5] = nArray[2 * n4];
                nArray2[2 * n5 + 1] = nArray[2 * n4 + 1];
                ++n3;
            }
            ++n2;
        }
    }

    static void resize(double[] dArray, int[] nArray, int n, double[] dArray2, int[] nArray2, Application application) {
        int n2 = (int)Math.sqrt(dArray.length);
        int n3 = 0;
        if (n > n2) {
            int n4 = n / n2;
            int n5 = 0;
            while (n5 < dArray.length) {
                int n6 = n5 / n2;
                int n7 = n5 % n2;
                int n8 = 0;
                while (n8 < n4) {
                    int n9 = 0;
                    while (n9 < n4) {
                        n3 = (n8 + n6 * n4) * n + (n7 * n4 + n9);
                        dArray2[n3] = dArray[n5];
                        nArray2[2 * n3] = nArray[2 * n5];
                        nArray2[2 * n3 + 1] = nArray[2 * n5 + 1];
                        ++n9;
                    }
                    ++n8;
                }
                ++n5;
            }
        } else {
            int n10 = n2 / n;
            int n11 = 0;
            int n12 = 0;
            while (n12 < dArray.length) {
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                double d = 480.0;
                int n16 = 0;
                while (n16 < n10) {
                    int n17 = 0;
                    while (n17 < n10) {
                        block19: {
                            int n18;
                            block18: {
                                n3 = n12 + n16 * n2 + n17;
                                try {
                                    n18 = nArray[2 * n3];
                                    if (n18 == 0) break block18;
                                    ++n13;
                                    break block19;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    application.err.println(nArray.length + " " + 2 * n3);
                                }
                            }
                            n18 = nArray[2 * n3 + 1];
                            if (n18 != 0) {
                                ++n14;
                            } else {
                                double d2 = dArray[n3];
                                if (d2 != 0.0) {
                                    ++n15;
                                    d = d2;
                                } else {
                                    dArray2[n16 * n10 + n17] = d2;
                                }
                            }
                        }
                        ++n17;
                    }
                    ++n16;
                }
                if (n13 >= n10 * n10 / 4) {
                    nArray2[2 * n11] = -1;
                    nArray2[2 * n11 + 1] = 0;
                    dArray2[n11] = 0.0;
                } else if (n15 >= n14) {
                    nArray2[2 * n11] = 0;
                    nArray2[2 * n11 + 1] = 0;
                    dArray2[n11] = d;
                } else {
                    nArray2[2 * n11] = 0;
                    nArray2[2 * n11 + 1] = -1;
                    dArray2[n11] = 0.0;
                }
                ++n11;
                if ((n12 += n10) % n2 != 0) continue;
                n12 += n2 * (n10 - 1);
            }
        }
    }

    public void saveShape(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeBoolean(this.rotatep);
        dataOutputStream.writeInt(3);
        dataOutputStream.writeInt(8);
        double[] dArray = this.colors8x8[0];
        dataOutputStream.writeInt(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            dataOutputStream.writeDouble(dArray[n]);
            ++n;
        }
        int[] nArray = this.masks8x8[0];
        dataOutputStream.writeInt(nArray.length);
        int n2 = 0;
        while (n2 < nArray.length) {
            dataOutputStream.writeInt(nArray[n2]);
            ++n2;
        }
        dataOutputStream.writeInt(16);
        dArray = this.colors16x16[0];
        dataOutputStream.writeInt(dArray.length);
        n2 = 0;
        while (n2 < dArray.length) {
            dataOutputStream.writeDouble(dArray[n2]);
            ++n2;
        }
        nArray = this.masks16x16[0];
        dataOutputStream.writeInt(nArray.length);
        n2 = 0;
        while (n2 < nArray.length) {
            dataOutputStream.writeInt(nArray[n2]);
            ++n2;
        }
        dataOutputStream.writeInt(32);
        dArray = this.colors32x32[0];
        dataOutputStream.writeInt(dArray.length);
        n2 = 0;
        while (n2 < dArray.length) {
            dataOutputStream.writeDouble(dArray[n2]);
            ++n2;
        }
        nArray = this.masks32x32[0];
        dataOutputStream.writeInt(nArray.length);
        n2 = 0;
        while (n2 < nArray.length) {
            dataOutputStream.writeInt(nArray[n2]);
            ++n2;
        }
    }

    public static TurtleShapes restoreShape(DataInputStream dataInputStream, double d, Application application) throws IOException {
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            application.err.println("restore shape failed");
            return null;
        }
        int n = dataInputStream.readInt();
        boolean bl = false;
        if (d == 2.0) {
            bl = dataInputStream.readInt() != 0;
        } else if (d == 3.0) {
            bl = dataInputStream.readBoolean();
        }
        if (d == 2.0) {
            double[] dArray = new double[dataInputStream.readInt()];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = dataInputStream.readDouble();
                ++n2;
            }
            int[] nArray = new int[dataInputStream.readInt()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = dataInputStream.readInt();
                ++n3;
            }
            n3 = (int)Math.sqrt(dArray.length);
            switch (n3) {
                case 8: {
                    return new TurtleShapes(string, n, dArray, nArray, null, null, null, null, bl);
                }
                case 16: {
                    return new TurtleShapes(string, n, null, null, dArray, nArray, null, null, bl);
                }
                case 32: {
                    return new TurtleShapes(string, n, null, null, null, null, dArray, nArray, bl);
                }
            }
            return null;
        }
        if (d == 3.0) {
            int n4 = dataInputStream.readInt();
            double[][] dArray = new double[n4][];
            int[][] nArray = new int[n4][];
            int n5 = 0;
            while (n5 < n4) {
                int n6 = dataInputStream.readInt();
                double[] dArray2 = new double[dataInputStream.readInt()];
                int n7 = 0;
                while (n7 < dArray2.length) {
                    dArray2[n7] = dataInputStream.readDouble();
                    ++n7;
                }
                int[] nArray2 = new int[dataInputStream.readInt()];
                int n8 = 0;
                while (n8 < nArray2.length) {
                    nArray2[n8] = dataInputStream.readInt();
                    ++n8;
                }
                switch (n6) {
                    case 8: {
                        dArray[0] = dArray2;
                        nArray[0] = nArray2;
                        break;
                    }
                    case 16: {
                        dArray[1] = dArray2;
                        nArray[1] = nArray2;
                        break;
                    }
                    case 32: {
                        dArray[2] = dArray2;
                        nArray[2] = nArray2;
                        break;
                    }
                }
                ++n5;
            }
            return new TurtleShapes(string, n, dArray[0], nArray[0], dArray[1], nArray[1], dArray[2], nArray[2], bl);
        }
        return null;
    }

    static String saveShapes() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            TurtleShapes.saveShapes(dataOutputStream);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = Utilities.gzipByteArray(byArray);
            String string = Base64.encode(byArray2);
            return "`turtle shapes`\r\n" + string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return "`turtle shapes`\r\n";
    }

    static String saveShapes(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            TurtleShapes.saveShapes(dataOutputStream, n);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = Utilities.gzipByteArray(byArray);
            String string = Base64.encode(byArray2);
            return "`turtle shapes`\r\n" + string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return "`turtle shapes`\r\n";
    }

    static void saveShapes(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("`turtle shapes`");
        dataOutputStream.writeDouble(3.0);
        int n = TurtleShapes.calculateNumShapes();
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < shapes.length) {
            if (shapes[n2] != null) {
                dataOutputStream.writeInt(n2);
                shapes[n2].saveShape(dataOutputStream);
            }
            ++n2;
        }
    }

    static void saveShapes(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeUTF("`turtle shapes`");
        dataOutputStream.writeDouble(3.0);
        if (shapes[n] != null) {
            int n2 = 1;
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n);
            shapes[n].saveShape(dataOutputStream);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    static boolean loadShapes(String string, boolean bl, Application application) {
        String string2 = "`turtle shapes`";
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = string.indexOf("`", n + string2.length());
            if (n2 == -1) {
                n2 = string.length();
            }
            String string3 = string.substring(n + string2.length(), n2).trim() + "\r\n";
            try {
                byte[] byArray = Utilities.gunzipByteArray(Base64.decode(string3.getBytes()));
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    TurtleShapes.restoreShapes(dataInputStream, -1, bl, application);
                    if (application.shapeChooser != null) {
                        application.shapeChooser.refresh();
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    streamCorruptedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    static boolean loadShapes(String string, int n, boolean bl, Application application) {
        String string2 = "`turtle shapes`";
        int n2 = string.indexOf(string2);
        if (n2 >= 0) {
            int n3 = string.indexOf("`", n2 + string2.length());
            if (n3 == -1) {
                n3 = string.length();
            }
            String string3 = string.substring(n2 + string2.length(), n3).trim() + "\r\n";
            try {
                byte[] byArray = Utilities.gunzipByteArray(Base64.decode(string3.getBytes()));
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    TurtleShapes.restoreShapes(dataInputStream, n, bl, application);
                    if (application.shapeChooser != null) {
                        application.shapeChooser.refresh();
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    streamCorruptedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    static void restoreShapes(DataInputStream dataInputStream, int n, boolean bl, Application application) throws IOException {
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return;
        }
        if (!string.equals("`turtle shapes`")) {
            return;
        }
        double d = dataInputStream.readDouble();
        if (d == 2.0) {
            TurtleShapes turtleShapes;
            TurtleShapes turtleShapes2;
            int n2;
            if (bl) {
                shapes = new TurtleShapes[64];
            }
            int n3 = dataInputStream.readInt();
            int n4 = 0;
            while (n4 < n3) {
                n2 = dataInputStream.readInt();
                TurtleShapes.shapes[n < 0 ? n2 : n] = TurtleShapes.restoreShape(dataInputStream, d, application);
                ++n4;
            }
            n3 = dataInputStream.readInt();
            n4 = 0;
            while (n4 < n3) {
                n2 = dataInputStream.readInt();
                turtleShapes2 = TurtleShapes.restoreShape(dataInputStream, d, application);
                turtleShapes = shapes[n < 0 ? n2 : n];
                if (turtleShapes == null) {
                    TurtleShapes.shapes[n < 0 ? n2 : n] = turtleShapes2;
                } else {
                    turtleShapes.colors16x16 = turtleShapes2.colors16x16;
                    turtleShapes.masks16x16 = turtleShapes2.masks16x16;
                }
                ++n4;
            }
            n3 = dataInputStream.readInt();
            n4 = 0;
            while (n4 < n3) {
                n2 = dataInputStream.readInt();
                turtleShapes2 = TurtleShapes.restoreShape(dataInputStream, d, application);
                turtleShapes = shapes[n < 0 ? n2 : n];
                if (shapes == null) {
                    TurtleShapes.shapes[n < 0 ? n2 : n] = turtleShapes2;
                } else {
                    turtleShapes.colors32x32 = turtleShapes2.colors32x32;
                    turtleShapes.masks32x32 = turtleShapes2.masks32x32;
                }
                ++n4;
            }
        } else {
            if (d > 3.0 || d < 3.0) {
                StarLogoError.error(application, "Error loading project file: Failed to read turtle shapes. Data version is unknown: " + d, false);
                return;
            }
            if (bl) {
                shapes = new TurtleShapes[64];
            }
            int n5 = dataInputStream.readInt();
            int n6 = 0;
            while (n6 < n5) {
                int n7 = dataInputStream.readInt();
                TurtleShapes.shapes[n < 0 ? n7 : n] = TurtleShapes.restoreShape(dataInputStream, d, application);
                ++n6;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    TurtleShapes(String string, int n, double[] dArray, int[] nArray, double[] dArray2, int[] nArray2, double[] dArray3, int[] nArray3, boolean bl) {
        this.name = string;
        this.id = n;
        this.rotatep = bl;
        this.colors8x8[0] = dArray;
        this.colors16x16[0] = dArray2;
        this.colors32x32[0] = dArray3;
        this.masks8x8[0] = nArray;
        this.masks16x16[0] = nArray2;
        this.masks32x32[0] = nArray3;
        this.reRotateShapes();
    }

    static {
        try {
            new Thread(new Runnable(){

                public final void run() {
                    Thread thread = Thread.currentThread();
                    while (true) {
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        TurtleShapes.clearHash();
                    }
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            }).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class ShapeClipboard {
        TurtleShapes shape;
        boolean cutp;

        ShapeClipboard(int n, boolean bl) {
            this.shape = TurtleShapes.getShape(n).copy();
            this.cutp = bl;
        }
    }
}

