/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import javax.swing.UIManager;
import starlogo.Interface;
import starlogo.StarLogo;
import starlogo.ToolTipWidget;
import starlogo.Widget;
import yoyo.YoYo;

public class ToolbarWidget
extends Widget {
    public static final int NONE = 0;
    public static final int POINTER = 1;
    public static final int BUTTON = 2;
    public static final int SLIDER = 3;
    public static final int MONITOR = 4;
    public static final int TEXT = 5;
    public static final int LINE = 6;
    public static final int LEGEND = 7;
    public static int NUM = 7;
    static int buttonWidth = 31;
    static int buttonHeight = 31;
    static Image toolbarHorizImagePush;
    static Image toolbarHorizImage;
    static Image toolbarVertImagePush;
    static Image toolbarVertImage;
    static ToolTipWidget pointerToolTip;
    static ToolTipWidget buttonToolTip;
    static ToolTipWidget sliderToolTip;
    static ToolTipWidget monitorToolTip;
    static ToolTipWidget textToolTip;
    static ToolTipWidget plotToolTip;
    static ToolTipWidget legendToolTip;
    public int buttonDown;
    public int rowDown;
    public int columnDown;
    public StarLogo sl;
    int oldButtonDown;
    int firstButtonDown;
    boolean horizontalp;
    private static /* synthetic */ Class class$Lstarlogo$ToolbarWidget;

    public boolean paintActivep() {
        return this.buttonDown == 0;
    }

    public void setButtonDown(int n) {
        this.drawButtonDown(n);
        if (this.oldButtonDown == 0 && this.buttonDown != 0) {
            this.parent.painttool().drawButtonDown(0);
        }
    }

    public void drawButtonDown(int n) {
        this.oldButtonDown = this.buttonDown;
        this.buttonDown = n;
        this.buttonToRowColumn(n);
        if (this.oldButtonDown == this.buttonDown) {
            return;
        }
        this.parent.addToClipRect(this.position);
    }

    public void buttonToRowColumn(int n) {
        if (this.horizontalp) {
            this.rowDown = 0;
            this.columnDown = n - 1;
        } else {
            n = n == 9 ? 8 : (n == 8 ? 7 : --n);
            this.rowDown = n % 4;
            this.columnDown = n % 2;
        }
    }

    public int pointToButton(int n, int n2) {
        int n3 = 0;
        if (this.horizontalp) {
            this.columnDown = (int)Math.ceil(NUM * (n - this.position.x) / this.image.getWidth(this.parent));
            this.rowDown = 0;
            n3 = this.columnDown + 1;
        } else {
            this.columnDown = (int)Math.ceil(2 * (n - this.position.x) / this.image.getWidth(this.parent));
            this.rowDown = (int)Math.ceil(4 * (n2 - this.position.y) / this.image.getHeight(this.parent));
            n3 = 1 + (this.rowDown * 2 + this.columnDown);
            if (n3 == 7) {
                n3 = 8;
            } else if (n3 == 8) {
                n3 = 9;
            }
        }
        return n3;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.position.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
            return;
        }
        this.oldButtonDown = this.buttonDown;
        this.buttonDown = this.pointToButton(mouseEvent.getX(), mouseEvent.getY());
        if (this.oldButtonDown == this.buttonDown) {
            return;
        }
        if (this.oldButtonDown == 0) {
            this.parent.painttool().drawButtonDown(0);
        }
        this.parent.addToClipRect(this.position);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        if (YoYo.macosxp) {
            graphics.setColor(UIManager.getColor("window"));
        } else {
            graphics.setColor(SystemColor.control);
        }
        graphics.fillRect(0, 0, this.position.width, this.position.height);
        graphics.drawImage(this.image, 0, 0, null);
        if (this.buttonDown != 0) {
            Shape shape = graphics.getClip();
            graphics.clipRect(buttonWidth * this.columnDown, buttonHeight * this.rowDown, buttonWidth, buttonHeight);
            graphics.drawImage(this.horizontalp ? toolbarHorizImagePush : toolbarVertImagePush, 0, 0, null);
            graphics.setClip(shape);
        }
        graphics.translate(-this.position.x, -this.position.y);
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        toolbarHorizImagePush = toolkit.getImage((class$Lstarlogo$ToolbarWidget != null ? class$Lstarlogo$ToolbarWidget : (class$Lstarlogo$ToolbarWidget = ToolbarWidget.class$("starlogo.ToolbarWidget"))).getResource(string + "toolbar-horiz-down1.gif"));
        toolbarHorizImage = toolkit.getImage((class$Lstarlogo$ToolbarWidget != null ? class$Lstarlogo$ToolbarWidget : (class$Lstarlogo$ToolbarWidget = ToolbarWidget.class$("starlogo.ToolbarWidget"))).getResource(string + "toolbar-horiz-up1.gif"));
        toolbarVertImagePush = toolkit.getImage((class$Lstarlogo$ToolbarWidget != null ? class$Lstarlogo$ToolbarWidget : (class$Lstarlogo$ToolbarWidget = ToolbarWidget.class$("starlogo.ToolbarWidget"))).getResource(string + "toolbar-vertical-down.gif"));
        toolbarVertImage = toolkit.getImage((class$Lstarlogo$ToolbarWidget != null ? class$Lstarlogo$ToolbarWidget : (class$Lstarlogo$ToolbarWidget = ToolbarWidget.class$("starlogo.ToolbarWidget"))).getResource(string + "toolbar-vertical-up.gif"));
        mediaTracker.addImage(toolbarHorizImagePush, Widget.trackerID++);
        mediaTracker.addImage(toolbarHorizImage, Widget.trackerID++);
        mediaTracker.addImage(toolbarVertImagePush, Widget.trackerID++);
        mediaTracker.addImage(toolbarVertImage, Widget.trackerID++);
    }

    public void displayToolTip(Point point) {
        int n = 1 + point.x / buttonWidth;
        switch (n) {
            case 1: {
                this.setToolTip(pointerToolTip);
                break;
            }
            case 2: {
                this.setToolTip(buttonToolTip);
                break;
            }
            case 3: {
                this.setToolTip(sliderToolTip);
                break;
            }
            case 4: {
                this.setToolTip(monitorToolTip);
                break;
            }
            case 5: {
                this.setToolTip(textToolTip);
                break;
            }
            case 6: {
                this.setToolTip(plotToolTip);
                break;
            }
            default: {
                this.setToolTip(legendToolTip);
                break;
            }
        }
        super.displayToolTip(point);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ToolbarWidget(Interface interface_) {
        this(interface_, true);
    }

    ToolbarWidget(Interface interface_, boolean bl) {
        super(interface_, bl ? toolbarHorizImage : toolbarVertImage);
        this.sl = interface_.sl();
        this.oldButtonDown = 1;
        this.buttonDown = 1;
        this.rowDown = 0;
        this.columnDown = 0;
        this.horizontalp = bl;
        pointerToolTip = new ToolTipWidget(interface_, "Select a widget.");
        buttonToolTip = new ToolTipWidget(interface_, "Create or edit a button.");
        sliderToolTip = new ToolTipWidget(interface_, "Create or edit a slider.");
        monitorToolTip = new ToolTipWidget(interface_, "Create or edit a monitor.");
        textToolTip = new ToolTipWidget(interface_, "Add text to the window.");
        plotToolTip = new ToolTipWidget(interface_, "Create or edit a plot.");
        legendToolTip = new ToolTipWidget(interface_, "Create or edit a legend.");
    }
}

