/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import starlogo.Interface;
import starlogo.Utilities;
import starlogo.Widget;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class ToolTipWidget
extends Widget {
    private static Font TOOLTIP_WIDGET_FONT;
    private static Color DEFAULT_COLOR;
    private static int TOP_BUFFER;
    private static int BOTTOM_BUFFER;
    private Font font;
    private FontMetrics fm;
    private int textWidth;
    private int textHeight;
    private int textDescent;
    private int maxWidth;
    private int minWidth;
    private String words;
    private String words2;
    private int totallinenums;
    private boolean fixed = false;
    private Color backgroundColor;

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(this.backgroundColor);
        graphics.fillRoundRect(this.position.x, this.position.y, this.position.width - 1, this.position.height - 1, 12, 12);
        graphics.setColor(Color.gray);
        graphics.drawRoundRect(this.position.x, this.position.y, this.position.width - 1, this.position.height - 1, 12, 12);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        graphics.translate(this.position.x, this.position.y);
        StringBuffer stringBuffer = new StringBuffer(this.words.length());
        if (this.totallinenums == 1) {
            graphics.drawString(this.words, (this.position.width - this.textWidth) / 2, this.position.height / 2 + this.textHeight / 2 - this.textDescent);
        } else {
            int n = 1;
            stringBuffer = new StringBuffer(this.words.length());
            int n2 = 0;
            while (n2 < this.words.length()) {
                char c = this.words.charAt(n2);
                if (c == '\n') {
                    graphics.drawString(stringBuffer.toString(), (this.position.width - this.textWidth) / 2, (++n - 1) * (this.position.height / (this.totallinenums + 1)) + this.textHeight / 2 - this.textDescent);
                    int n3 = stringBuffer.toString().length();
                    stringBuffer = new StringBuffer(this.words.length() - n3);
                } else {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            graphics.drawString(stringBuffer.toString(), (this.position.width - this.textWidth) / 2, (++n - 1) * (this.position.height / (this.totallinenums + 1)) + this.textHeight / 2 - this.textDescent);
        }
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void updateMinSize() {
        StringBuffer stringBuffer = new StringBuffer(this.words.length());
        int n = 1;
        int n2 = 1;
        String string = "";
        int n3 = 0;
        while (n3 < this.words.length()) {
            char c = this.words.charAt(n3);
            if (c == '\n') {
                ++n;
                int n4 = this.fm.stringWidth(stringBuffer.toString());
                if (n4 > n2) {
                    n2 = n4;
                    string = stringBuffer.toString();
                }
                stringBuffer = new StringBuffer(this.words.length() - stringBuffer.toString().length());
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (this.fm.stringWidth(stringBuffer.toString()) > n2) {
            n2 = this.fm.stringWidth(stringBuffer.toString());
            string = stringBuffer.toString();
        }
        this.totallinenums = n;
        this.position.height = this.textHeight * this.totallinenums + 4;
        this.textWidth = this.totallinenums == 1 ? this.fm.stringWidth(this.getText()) : this.fm.stringWidth(string);
        n3 = 12 + this.textWidth;
        if (n3 < 24) {
            n3 = 24;
        }
        this.position.width = n3;
    }

    public void fixPosition(Point point) {
        if (point != null) {
            this.position.setLocation(point);
            this.fixed = true;
        }
    }

    public void fixPosition(int n, int n2) {
        this.position.setLocation(n, n2);
        this.fixed = true;
    }

    public void releasePosition() {
        this.fixed = false;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setPosition(Rectangle rectangle) {
        if (!this.fixed) {
            Point point = rectangle.getLocation();
            int n = Math.max(-2, point.x + this.position.width - this.parent.getSize().width);
            if (point.y - (this.position.height + 2) < TOP_BUFFER) {
                point.translate(-n, rectangle.height + 2);
            } else {
                point.translate(-n, -(this.position.height + 2));
            }
            if (point.x < 0) {
                point.setLocation(0, point.y);
            }
            if (point.y + this.position.height > this.parent.getSize().height) {
                point.setLocation(point.x, TOP_BUFFER);
            }
            this.position.setLocation(point);
        }
    }

    public void setPosition(Rectangle rectangle, Rectangle rectangle2) {
        if (!this.fixed) {
            this.setPosition(rectangle);
            if (this.position.intersects(rectangle2)) {
                if (rectangle.x < rectangle2.x && this.position.x + this.position.width - rectangle2.x < this.position.x) {
                    this.position.x -= this.position.x + this.position.width - rectangle2.x + 1;
                    return;
                }
                if (rectangle.y < rectangle2.y && TOP_BUFFER + this.position.height < rectangle2.y) {
                    if (this.position.width + rectangle.x + rectangle.width < this.parent.getSize().width) {
                        this.position.x = rectangle.x + rectangle.width + 1;
                        this.position.y = rectangle2.y - this.position.height - 1;
                        return;
                    }
                    if (this.position.width < rectangle.x) {
                        this.position.x = rectangle.x - this.position.width - 1;
                        this.position.y = rectangle2.y - this.position.height - 1;
                        return;
                    }
                }
                if (rectangle.y > rectangle2.y + rectangle2.height && BOTTOM_BUFFER + this.position.height < this.parent.getSize().height - rectangle2.y - rectangle2.height) {
                    if (this.position.width + rectangle.x + rectangle.width < this.parent.getSize().width) {
                        this.position.x = rectangle.x + rectangle.width + 1;
                        this.position.y = rectangle2.y + rectangle2.height + 1;
                        return;
                    }
                    if (this.position.width < rectangle.x) {
                        this.position.x = rectangle.x - this.position.width - 1;
                        this.position.y = rectangle2.y + rectangle2.height + 1;
                        return;
                    }
                }
            }
        }
    }

    public String getText() {
        return this.words2;
    }

    public String toString() {
        return "Tool Tip " + this.words;
    }

    public static boolean empty(String string) {
        boolean bl = true;
        bl = string == null || string.trim().length() == 0;
        return bl;
    }

    public String getSaveString() {
        return "toolTip-text \"" + Utilities.printable(this.words) + "\"\r\n";
    }

    public ToolTipWidget(Interface interface_, String string) {
        this.words2 = string;
        this.words = string.trim();
        this.position = new Rectangle();
        this.position.height = 4;
        this.parent = interface_;
        this.font = WidgetLite.WIDGET_FONT;
        this.backgroundColor = DEFAULT_COLOR;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
    }

    static {
        TOP_BUFFER = 50;
        BOTTOM_BUFFER = 30;
        try {
            TOOLTIP_WIDGET_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                TOOLTIP_WIDGET_FONT = Font.getFont("starlogo.text-widget.font", TOOLTIP_WIDGET_FONT);
            }
            try {
                DEFAULT_COLOR = new Color(255, 255, 96);
            }
            catch (Error error) {
                DEFAULT_COLOR = new Color(255, 255, 96);
            }
            catch (Exception exception) {
                DEFAULT_COLOR = new Color(255, 255, 96);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

