/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import starlogo.Application;
import starlogo.Interface;
import starlogo.SLProc;
import starlogo.SmartRectangle;
import starlogo.StarLogo;
import starlogo.TextWidgetDialog;
import starlogo.Utilities;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class TextWidget
extends WidgetDrag
implements Observer {
    public static int TEXTWIDGET_HEIGHT = 15;
    public static int idCount = 1;
    static Font TEXT_WIDGET_FONT;
    boolean drawBorder = false;
    public int id;
    public Font font;
    public FontMetrics fm;
    StarLogo sl;
    Application app;
    int textWidth;
    int textHeight;
    int textDescent;
    int maxWidth;
    int minWidth;
    public String words;
    public int totallinenums;

    public static TextWidget load(Vector vector, Interface interface_, StarLogo starLogo) {
        Object object;
        Object object2;
        int n = 0;
        String string = "";
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        int n5 = 20;
        int n6 = 1;
        int n7 = 0;
        int n8 = 1;
        while (n < vector.size()) {
            String string2;
            object2 = vector.elementAt(n).toString();
            if (((String)object2).equals("top-left")) {
                object = vector.elementAt(n + 1).toString();
                string2 = vector.elementAt(n + 2).toString();
                n2 = Integer.parseInt((String)object);
                n3 = Integer.parseInt(string2);
                n += 3;
                continue;
            }
            if (((String)object2).equals("width-height")) {
                object = vector.elementAt(n + 1).toString();
                string2 = vector.elementAt(n + 2).toString();
                n4 = Integer.parseInt((String)object);
                n5 = Integer.parseInt(string2);
                n += 3;
                continue;
            }
            if (((String)object2).equals("textwidth")) {
                object = vector.elementAt(n + 1).toString();
                n7 = Integer.parseInt((String)object);
                n += 2;
                continue;
            }
            if (((String)object2).equals("linenums")) {
                object = vector.elementAt(n + 1).toString();
                n8 = Integer.parseInt((String)object);
                n += 2;
                continue;
            }
            if (((String)object2).equals("words")) {
                string = vector.elementAt(n + 1).toString();
                n += 2;
                continue;
            }
            if (((String)object2).equals("drawBorder")) {
                object = vector.elementAt(n + 1).toString();
                bl = Boolean.valueOf((String)object);
                n += 2;
                continue;
            }
            if (((String)object2).equals("textwidget-number")) {
                object = vector.elementAt(n + 1).toString();
                n6 = Integer.parseInt((String)object);
                n += 2;
                continue;
            }
            n += 2;
        }
        object2 = interface_.getBoundaries();
        object = new Rectangle(n3 + ((Rectangle)object2).x, n2 + ((Rectangle)object2).y, n4, n5);
        if (n6 >= idCount) {
            idCount = n6 + 1;
        }
        return new TextWidget(string, n6, n7, n8, (Rectangle)object, bl, interface_, starLogo);
    }

    public String getSaveString(boolean bl) {
        Rectangle rectangle = this.parent.getBoundaries();
        String string = "SLTextWidget\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "textwidth " + this.textWidth + "\r\n" + "linenums " + this.totallinenums + "\r\n" + "words \"" + Utilities.printable(this.words) + "\"\r\n" + "drawBorder " + this.drawBorder + "\r\n" + "textwidget-number " + this.id + "\r\n\r\n";
        return string;
    }

    public static void createNew(Interface interface_) {
        TextWidgetDialog textWidgetDialog = Application.createTextWidgetDialog(interface_.frame(), "New Text Label");
        if (YoYo.language == 1) {
            textWidgetDialog = Application.createTextWidgetDialog(interface_.frame(), "Texto Nuevo");
        }
        textWidgetDialog.show();
        if (textWidgetDialog.pressedOK()) {
            TextWidget textWidget = new TextWidget(interface_, interface_.sl());
            textWidgetDialog.getValues(textWidget);
            textWidget.updateMinSize();
            interface_.addWidget(textWidget);
            interface_.app().project.markChanged();
        }
        textWidgetDialog.dispose();
    }

    public void edit() {
        TextWidgetDialog textWidgetDialog = Application.createTextWidgetDialog(this.parent.frame(), "Edit Text Label", this);
        textWidgetDialog.show();
        if (textWidgetDialog.pressedOK()) {
            this.words = "";
            this.parent.addHandlesToClipRect(this);
            this.update(this.position);
            this.updateMinSize();
            textWidgetDialog.getValues(this);
            this.updateMinSize();
            this.update(this.position);
            this.app.project.markChanged();
        }
        textWidgetDialog.dispose();
        super.edit();
    }

    public void delete() {
        this.parent.textwidgets().removeElement(this);
        super.delete();
    }

    public void paintText(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.darkGray);
        graphics.setFont(this.font);
        StringBuffer stringBuffer = new StringBuffer(this.words.length());
        if (this.totallinenums == 1) {
            graphics.drawString(this.words, (this.position.width - this.textWidth) / 2, this.position.height / 2 + this.textHeight / 2 - this.textDescent);
        } else {
            int n = 1;
            stringBuffer = new StringBuffer(this.words.length());
            int n2 = 0;
            while (n2 < this.words.length()) {
                char c = this.words.charAt(n2);
                if (c == '\n') {
                    graphics.drawString(stringBuffer.toString(), (this.position.width - this.textWidth) / 2, (++n - 1) * (this.position.height / (this.totallinenums + 1)) + this.textHeight / 2 - this.textDescent);
                    int n3 = stringBuffer.toString().length();
                    stringBuffer = new StringBuffer(this.words.length() - n3);
                } else {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            graphics.drawString(stringBuffer.toString(), (this.position.width - this.textWidth) / 2, (++n - 1) * (this.position.height / (this.totallinenums + 1)) + this.textHeight / 2 - this.textDescent);
        }
    }

    public void paint(Graphics graphics) {
        Shape shape = graphics.getClip();
        graphics.translate(this.position.x, this.position.y);
        this.position.height = TEXTWIDGET_HEIGHT * this.totallinenums + 10;
        graphics.setColor(Color.lightGray);
        if (this.drawBorder) {
            graphics.drawRect(0, 0, this.position.width - 1, this.position.height - 1);
        }
        graphics.setClip(1, 1, this.position.width - 1, this.position.height - 1);
        this.paintText(graphics);
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setClip(shape);
    }

    public void updateMinSize() {
        StringBuffer stringBuffer = new StringBuffer(this.words.length());
        int n = 1;
        int n2 = 1;
        String string = "";
        int n3 = 0;
        while (n3 < this.words.length()) {
            char c = this.words.charAt(n3);
            if (c == '\n') {
                ++n;
                int n4 = this.fm.stringWidth(stringBuffer.toString());
                if (n4 > n2) {
                    n2 = n4;
                    string = stringBuffer.toString();
                }
                stringBuffer = new StringBuffer(this.words.length() - stringBuffer.toString().length());
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (this.fm.stringWidth(stringBuffer.toString()) > n2) {
            n2 = this.fm.stringWidth(stringBuffer.toString());
            string = stringBuffer.toString();
        }
        this.totallinenums = n;
        this.position.height = TEXTWIDGET_HEIGHT * this.totallinenums + 10;
        if (this.totallinenums > 1 && this.parent.outline() != null && this.parent.outline().height < this.position.height) {
            this.parent.outline().height = this.position.height;
        }
        this.textWidth = this.totallinenums == 1 ? this.fm.stringWidth(this.getText()) : this.fm.stringWidth(string);
        n3 = 4 + this.textWidth;
        if (n3 < 40) {
            n3 = 40;
        }
        this.position.width = n3;
        if (this.parent.outline() != null) {
            if (this.parent.outline().x + n3 > this.parent.getSize().width) {
                this.parent.outline().width = this.parent.outline().width + this.parent.outline().x - this.parent.getSize().width + n3;
                this.parent.outline().x = this.parent.getSize().width - n3;
            }
            if (this.parent.outline().width < n3) {
                this.parent.outline().width = n3;
            }
        }
        this.MIN_WIDTH = 4 + this.textWidth;
    }

    public String getText() {
        return this.words;
    }

    public String twSavePrintable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                stringBuffer.append("\\\"");
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void handleMouseClick(MouseEvent mouseEvent) {
        if (this.parent.getToolbar().buttonDown == 5 && YoYo.applet == null) {
            this.edit();
        }
    }

    public int getToolbarButton() {
        return 5;
    }

    public String toString() {
        return "TextWidget id: " + this.id + " words: " + this.words;
    }

    public void update(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SLProc) {
            this.update();
        }
    }

    public void update() {
    }

    public static boolean isBlank(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ' || cArray[n] == '\n' || cArray[n] == '\t') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isBlank(String string) {
        return TextWidget.isBlank(string.toCharArray());
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        return new TextWidget(this.words, ++idCount, this.textWidth, this.totallinenums, rectangle, this.drawBorder, this.parent, this.sl);
    }

    public TextWidget(String string, int n, int n2, int n3, Rectangle rectangle, boolean bl, Interface interface_, StarLogo starLogo) {
        this.position = new Rectangle(rectangle);
        this.position.height = TEXTWIDGET_HEIGHT + 10;
        this.id = n;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = TEXT_WIDGET_FONT;
        this.drawBorder = bl;
        this.words = string;
        this.totallinenums = n3;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.textWidth = n2;
        this.updateMinSize();
    }

    public TextWidget(Interface interface_, StarLogo starLogo) {
        Dimension dimension = interface_.getSize();
        SmartRectangle smartRectangle = interface_.outline();
        if (smartRectangle.height < TEXTWIDGET_HEIGHT + 10) {
            smartRectangle.height = TEXTWIDGET_HEIGHT + 10;
        }
        this.position = new Rectangle(smartRectangle);
        this.position.height = TEXTWIDGET_HEIGHT + 10;
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
    }

    static {
        try {
            TEXT_WIDGET_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                TEXT_WIDGET_FONT = Font.getFont("starlogo.text-widget.font", TEXT_WIDGET_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

