/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.util.Random;
import starlogo.Application;
import starlogo.Patch;
import starlogo.RandomSPEnumerator;
import starlogo.SPEnumeration;
import starlogo.SPEnumerator;
import starlogo.StackProcess;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.VM;

public class StackProcessList {
    public static int seed = (int)System.currentTimeMillis();
    public static Random rand = new Random(seed);
    StackProcess firstProcess;
    StackProcess lastProcess;
    public boolean randomschedp = false;
    public boolean changeschedp = false;
    int count = 0;
    Application app;
    SPEnumerator spe;
    SPEnumerator spe2;

    public String getScheduler() {
        return this.randomschedp ? "random" : "fixed";
    }

    public void create(VM vM) {
        vM.firstProcess = null;
        vM.lastProcess = null;
        vM.count = 0;
    }

    public void deletePatches() {
    }

    public void deleteTurtles() {
    }

    public void deleteObserver() {
    }

    int size() {
        return this.count;
    }

    public void add(StackProcess stackProcess) {
        this.addProcess(stackProcess);
        if (this.count == 1) {
            this.app.runMonitors();
        }
    }

    public void addMonitor(StackProcess stackProcess) {
        if (StarLogo.DEBUG) {
            this.app.log.println("SPL add monitor " + stackProcess + " to entity: " + stackProcess.entity);
        }
        this.addProcess(stackProcess);
    }

    public void addLineWidget(StackProcess stackProcess) {
        if (StarLogo.DEBUG) {
            this.app.log.println("SPL add line widget " + stackProcess + " to entity: " + stackProcess.entity);
        }
        this.addProcess(stackProcess);
    }

    public void addProcess(StackProcess stackProcess) {
        boolean bl;
        boolean bl2 = bl = this.count == 0;
        if (this.firstProcess == null) {
            this.firstProcess = stackProcess;
            this.lastProcess = stackProcess;
            stackProcess.prevInList = null;
            stackProcess.nextInList = null;
        } else {
            stackProcess.prevInList = null;
            stackProcess.nextInList = this.firstProcess;
            this.firstProcess.prevInList = stackProcess;
            this.firstProcess = stackProcess;
        }
        ++this.count;
        stackProcess.originalentity.addSP(stackProcess);
        if (bl && !this.app.sl.locked) {
            Object object = this.app.sl.runningp;
            synchronized (object) {
                this.app.sl.runningp.notify();
            }
        }
    }

    public void printList() {
        System.out.println("printing stackprocess list forwards");
        StackProcess stackProcess = this.firstProcess;
        while (stackProcess != null) {
            System.out.print(stackProcess + ", ");
            stackProcess = stackProcess.nextInList;
        }
        System.out.println();
        System.out.println("printing stackprocess list backwards");
        stackProcess = this.lastProcess;
        while (stackProcess != null) {
            System.out.print(stackProcess + ", ");
            stackProcess = stackProcess.prevInList;
        }
        System.out.println();
    }

    public void remove(StackProcess stackProcess) {
        this.removeVMProcess(stackProcess);
        if (this.count == this.app.numMonitors()) {
            this.app.stopMonitors();
        }
    }

    public void removeMonitor(StackProcess stackProcess) {
        if (StarLogo.DEBUG) {
            this.app.log.println("SPL remove monitor " + stackProcess + " from entity: " + stackProcess.entity);
        }
        this.removeVMProcess(stackProcess);
    }

    public void removeLineWidget(StackProcess stackProcess) {
        if (StarLogo.DEBUG) {
            this.app.log.println("SPL remove line widget " + stackProcess + " from entity: " + stackProcess.entity);
        }
        this.removeVMProcess(stackProcess);
    }

    public void removeVMProcess(StackProcess stackProcess) {
        if (!stackProcess.donep) {
            stackProcess.originalentity.removeSP(stackProcess);
            this.removeProcess(stackProcess);
        }
    }

    public void removeProcess(StackProcess stackProcess) {
        if (stackProcess.prevInList != null) {
            stackProcess.prevInList.nextInList = stackProcess.nextInList;
        } else if (stackProcess.nextInList == null) {
            this.firstProcess = null;
            this.lastProcess = null;
        } else {
            this.firstProcess = stackProcess.nextInList;
        }
        if (stackProcess.nextInList != null) {
            stackProcess.nextInList.prevInList = stackProcess.prevInList;
        } else if (stackProcess.prevInList == null) {
            this.firstProcess = null;
            this.lastProcess = null;
        } else {
            this.lastProcess = stackProcess.prevInList;
        }
        --this.count;
        stackProcess.done();
    }

    public void remove(VM vM) {
        SPEnumeration sPEnumeration = vM.spList();
        while (sPEnumeration.hasMoreElements()) {
            StackProcess stackProcess = sPEnumeration.nextElement();
            this.removeProcess(stackProcess);
            stackProcess.unwindStack(vM);
        }
        vM.removeAllSPs();
        if (this.count == this.app.numMonitors()) {
            this.app.stopMonitors();
        }
    }

    public void removeAllSPs() {
        this.removeTurtleSPs();
        this.removePatchSPs();
        this.removeObserverSPs();
        this.app.stopMonitors();
        this.lastProcess = null;
        this.firstProcess = null;
        this.count = 0;
    }

    public void removeTurtleSPs() {
        Turtle turtle = this.app.sl.firstturtle;
        while (turtle != null) {
            this.remove(turtle);
            turtle = turtle.next;
        }
    }

    public void removePatchSPs() {
        int n = 1;
        while (n < this.app.sl.height + 1) {
            int n2 = n * this.app.sl.widthp2;
            int n3 = 1;
            while (n3 < this.app.sl.width + 1) {
                Patch patch = this.app.sl.patches[n2 + n3];
                this.remove(patch);
                ++n3;
            }
            ++n;
        }
    }

    public void removeObserverSPs() {
        this.remove(this.app.sl.observer);
    }

    void stop(StackProcessParent stackProcessParent) {
        SPEnumeration sPEnumeration = this.elements();
        while (sPEnumeration.hasMoreElements()) {
            StackProcess stackProcess = sPEnumeration.nextElement();
            if (!stackProcessParent.contains(stackProcess)) continue;
            this.remove(stackProcess);
        }
    }

    public void permute() {
        StackProcess[] stackProcessArray = new StackProcess[this.count];
        int n = 0;
        Object object = this.firstProcess;
        while (object != null) {
            stackProcessArray[n] = object;
            object = ((StackProcess)object).nextInList;
            ++n;
        }
        object = new int[this.count];
        n = 0;
        while (n < this.count) {
            object[n] = n;
            ++n;
        }
        n = 0;
        while (n < this.count) {
            int n2 = (int)Math.floor(rand.nextDouble() * (double)this.count);
            Object object2 = object[n];
            object[n] = object[n2];
            object[n2] = object2;
            ++n;
        }
        this.firstProcess = stackProcessArray[object[0]];
        this.firstProcess.prevInList = null;
        StackProcess stackProcess = this.firstProcess;
        n = 1;
        while (n < this.count) {
            StackProcess stackProcess2;
            stackProcess.nextInList = stackProcess2 = stackProcessArray[object[n]];
            stackProcess2.prevInList = stackProcess;
            stackProcess = stackProcess2;
            ++n;
        }
        this.lastProcess = stackProcessArray[object[this.count - 1]];
        this.lastProcess.nextInList = null;
    }

    SPEnumeration elements() {
        if (this.changeschedp) {
            this.spe2 = this.randomschedp ? new RandomSPEnumerator(this) : new SPEnumerator(this);
            this.changeschedp = false;
        } else {
            this.spe2.reset();
        }
        this.spe = this.spe2;
        return this.spe;
    }

    public StackProcessList(Application application) {
        this.app = application;
        this.spe2 = this.randomschedp ? new RandomSPEnumerator(this) : new SPEnumerator(this);
    }
}

