/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import starlogo.Application;
import starlogo.StarLogoFrame;
import yoyo.YoYo;

public class ProgressBar
extends Dialog
implements Runnable,
StarLogoFrame {
    int total;
    int remaining;
    Insets insets;
    Dimension size;
    Application app;
    private final Color progressbar_foreground = new Color(0x4A4A4A);
    private final Color progressbar_background = new Color(12432895);

    public void run() {
        this.show();
        ((Component)this).setVisible(false);
    }

    public void update(int n) {
        while (!this.isVisible()) {
            Thread.currentThread();
            Thread.yield();
        }
        this.remaining = n;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        if (n <= 0) {
            ((Component)this).setVisible(false);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.insets == null) {
            this.insets = this.getInsets();
        }
        if (this.size == null) {
            this.size = this.getSize();
        }
        graphics.draw3DRect(this.insets.left, this.insets.top, this.size.width, this.size.height, false);
        graphics.setColor(this.progressbar_background);
        graphics.fillRect(this.insets.left + 1, this.insets.top + 1, this.size.width - 1, this.size.height - 1);
        graphics.setColor(this.progressbar_foreground);
        graphics.fillRect(this.insets.left + 1, this.insets.top + 1, this.size.width * (this.total - this.remaining) / this.total, this.size.height - this.insets.top - this.insets.bottom);
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    public ProgressBar(Application application, String string, int n) {
        super((Frame)((Object)application.activeFrame), string, true);
        this.app = application;
        this.total = n;
        this.remaining = 0;
        this.addNotify();
        if (YoYo.macintoshp) {
            ((Component)this).setSize(290, 12);
        } else {
            ((Component)this).setSize(300, 50);
        }
        this.insets = this.getInsets();
        this.size = this.getSize();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = dimension.width;
        int n3 = this.size.width;
        ((Component)this).setLocation((n2 - n3) / 2, 60);
        new Thread(this).start();
    }
}

