/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import starlogo.Interface;
import starlogo.StarLogo;
import starlogo.Widget;

public class Painttool
extends Widget {
    public static final int NONE = 0;
    public static final int PEN = 1;
    public static final int ERASER = 2;
    public static final int LINE = 3;
    public static final int EYEDROPPER = 4;
    public static final int REC = 5;
    public static final int FILLREC = 6;
    public static final int OVAL = 7;
    public static final int FILLOVAL = 8;
    public static final int POLY = 9;
    public static final int FILLSHAPE = 10;
    static final int buttonWidth = 24;
    static final int buttonHeight = 24;
    private static final Font patchfont = new Font("Dialog", 0, 12);
    public static Image paintHorizImage;
    public static Image paintHorizImagePush;
    public static Image paintVertImage;
    public static Image paintVertImagePush;
    private StarLogo sl;
    private FontMetrics patchfm;
    public int buttonDown;
    public int rowDown;
    public int columnDown;
    public int oldButtonDown = 0;
    private int offset = 0;
    public boolean horizontalp;
    private static /* synthetic */ Class class$Lstarlogo$Painttool;

    public void setButtonDown(int n) {
        this.drawButtonDown(n);
        if (this.oldButtonDown == 0 && this.buttonDown != 0) {
            this.parent.getToolbar().drawButtonDown(0);
        }
    }

    public void drawButtonDown(int n) {
        this.oldButtonDown = this.buttonDown;
        this.buttonDown = n;
        this.buttonToRowColumn(n);
        if (this.oldButtonDown == this.buttonDown) {
            return;
        }
        this.parent.addToClipRect(this.position);
    }

    public void buttonToRowColumn(int n) {
        if (this.horizontalp) {
            this.rowDown = --n % 2;
            this.columnDown = n % 5;
        } else {
            this.rowDown = --n % 5;
            this.columnDown = n % 2;
        }
    }

    public int pointToButton(int n, int n2) {
        int n3 = 0;
        if (this.horizontalp) {
            this.columnDown = (int)Math.ceil(5 * (n - this.position.x) / this.image.getWidth(this.parent));
            this.rowDown = (int)Math.ceil(2 * (n2 - this.position.y) / this.image.getHeight(this.parent));
            n3 = this.columnDown * 2 + this.rowDown + 1;
        } else {
            this.columnDown = (int)Math.ceil(2 * (n - this.position.x) / this.image.getWidth(this.parent));
            this.rowDown = (int)Math.ceil(5 * (n2 - this.position.y) / this.image.getHeight(this.parent));
            n3 = this.rowDown * 2 + this.columnDown + 1;
        }
        return n3;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.position.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
            return;
        }
        this.oldButtonDown = this.buttonDown;
        this.buttonDown = this.pointToButton(mouseEvent.getX(), mouseEvent.getY());
        if (this.oldButtonDown == this.buttonDown) {
            return;
        }
        this.parent.addToClipRect(this.position);
        if (this.oldButtonDown == 0) {
            this.parent.getToolbar().drawButtonDown(0);
        }
        if (!this.parent.getToolbar().paintActivep() || this.parent.painttool().buttonDown != 9) {
            this.sl.patchcanvas.clearPoly(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        graphics.drawImage(this.image, 0, 0, null);
        if (this.buttonDown != 0) {
            Shape shape = graphics.getClip();
            graphics.clipRect(24 * this.columnDown, 24 * this.rowDown, 24, 24);
            graphics.drawImage(this.horizontalp ? paintHorizImagePush : paintVertImagePush, 0, 0, null);
            graphics.setClip(shape);
        }
        graphics.translate(-this.position.x, -this.position.y);
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        paintHorizImagePush = toolkit.getImage((class$Lstarlogo$Painttool != null ? class$Lstarlogo$Painttool : (class$Lstarlogo$Painttool = Painttool.class$("starlogo.Painttool"))).getResource(string + "paint-toolbar-press.gif"));
        paintHorizImage = toolkit.getImage((class$Lstarlogo$Painttool != null ? class$Lstarlogo$Painttool : (class$Lstarlogo$Painttool = Painttool.class$("starlogo.Painttool"))).getResource(string + "paint-toolbar2.gif"));
        paintVertImagePush = toolkit.getImage((class$Lstarlogo$Painttool != null ? class$Lstarlogo$Painttool : (class$Lstarlogo$Painttool = Painttool.class$("starlogo.Painttool"))).getResource(string + "paint-toolbar-vertical-down.gif"));
        paintVertImage = toolkit.getImage((class$Lstarlogo$Painttool != null ? class$Lstarlogo$Painttool : (class$Lstarlogo$Painttool = Painttool.class$("starlogo.Painttool"))).getResource(string + "paint-toolbar-vertical-up.gif"));
        mediaTracker.addImage(paintHorizImagePush, Widget.trackerID++);
        mediaTracker.addImage(paintHorizImage, Widget.trackerID++);
        mediaTracker.addImage(paintVertImagePush, Widget.trackerID++);
        mediaTracker.addImage(paintVertImage, Widget.trackerID++);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Painttool(Interface interface_) {
        this(interface_, true);
    }

    public Painttool(Interface interface_, boolean bl) {
        super(interface_, bl ? paintHorizImage : paintVertImage);
        this.sl = interface_.sl();
        this.patchfm = interface_.getToolkit().getFontMetrics(patchfont);
        this.horizontalp = bl;
        this.buttonDown = 0;
        this.rowDown = 0;
        this.columnDown = 0;
    }
}

