/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import starlogo.Colors;
import starlogo.Interface;
import starlogo.StarLogo;
import starlogo.Widget;

public class PaintSelect
extends Widget {
    public static final int PATCH = 0;
    public static final int TURTLE = 1;
    static final int buttonWidth = 24;
    static final int buttonHeight = 24;
    static int turtlewidth = 16;
    static int turtleheight = 17;
    static Image turtleImage;
    static Image newTurtleImage;
    static int colorTransparent;
    static int colorBlack;
    private Interface iface;
    private StarLogo sl;
    public int buttonDown = 0;
    public int oldButtonDown = 0;
    int[] turtlepixels = new int[turtlewidth * turtleheight];
    MemoryImageSource source;
    int[] imagepixels = new int[turtlewidth * turtleheight];
    boolean horizontalp;
    private static /* synthetic */ Class class$Lstarlogo$ToolbarWidget;

    public void makeTurtlePixels() {
        PixelGrabber pixelGrabber = new PixelGrabber(turtleImage, 0, turtleheight, turtlewidth, turtleheight, this.turtlepixels, 0, turtlewidth);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int n = 0;
        while (n < turtlewidth * turtleheight) {
            if (this.turtlepixels[n] != colorBlack) {
                this.imagepixels[n] = this.turtlepixels[n];
            }
            ++n;
        }
        this.source = new MemoryImageSource(turtlewidth, turtleheight, this.imagepixels, 0, turtlewidth);
        this.source.setAnimated(true);
        newTurtleImage = this.iface.getToolkit().createImage(this.source);
    }

    void updateTurtleColor(Color color) {
        int n = color.getRGB();
        int n2 = 0;
        while (n2 < turtlewidth * turtleheight) {
            if (this.turtlepixels[n2] == colorBlack) {
                this.imagepixels[n2] = n;
            }
            ++n2;
        }
        this.source.newPixels(0, 0, turtlewidth, turtleheight);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.position.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
            return;
        }
        this.oldButtonDown = this.buttonDown;
        double d = this.horizontalp ? (mouseEvent.getY() - this.position.y) / 24 : (mouseEvent.getX() - this.position.x) / 24;
        this.buttonDown = (int)Math.floor(d);
        if (this.oldButtonDown == this.buttonDown) {
            return;
        }
        this.parent.addToClipRect(this.position);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        Color color = graphics.getColor();
        if (this.horizontalp) {
            if (this.buttonDown == 0) {
                int n = this.iface.colortool().curcolor;
                graphics.setColor(Colors.colorarray[n * 32]);
                graphics.fillRect(4, 4, 16, 16);
                graphics.setColor(Colors.colorarray[1440]);
                graphics.drawRect(3, 3, 17, 17);
                Shape shape = graphics.getClip();
                graphics.clipRect(4, 27, 16, 17);
                graphics.drawImage(turtleImage, 4, 27, this.iface);
                graphics.setClip(shape);
            } else {
                graphics.setColor(Colors.colorarray[0]);
                graphics.fillRect(4, 4, 16, 16);
                graphics.drawImage(newTurtleImage, 4, 27, this.iface);
            }
        } else if (this.buttonDown == 0) {
            int n = this.iface.colortool().curcolor;
            graphics.setColor(Colors.colorarray[n * 32]);
            graphics.fillRect(4, 4, 16, 16);
            graphics.setColor(Colors.colorarray[1440]);
            graphics.drawRect(3, 3, 17, 17);
            Shape shape = graphics.getClip();
            graphics.clipRect(27, 4, 16, 17);
            graphics.drawImage(turtleImage, 27, 4, this.iface);
            graphics.setClip(shape);
        } else {
            graphics.setColor(Colors.colorarray[0]);
            graphics.fillRect(4, 4, 16, 16);
            graphics.drawImage(newTurtleImage, 27, 4, this.iface);
        }
        graphics.setColor(color);
        graphics.translate(-this.position.x, -this.position.y);
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        URL uRL = (class$Lstarlogo$ToolbarWidget != null ? class$Lstarlogo$ToolbarWidget : (class$Lstarlogo$ToolbarWidget = PaintSelect.class$("starlogo.ToolbarWidget"))).getResource(string + "turtle.gif");
        if (uRL == null) {
            throw new MalformedURLException();
        }
        turtleImage = toolkit.getImage(uRL);
        mediaTracker.addImage(turtleImage, Widget.trackerID++);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PaintSelect(Interface interface_) {
        this(interface_, true);
    }

    public PaintSelect(Interface interface_, boolean bl) {
        super(interface_);
        this.horizontalp = bl;
        this.iface = interface_;
        int n = bl ? 24 : 48;
        int n2 = bl ? 48 : 24;
        this.position = new Rectangle(0, 0, n, n2);
        this.sl = interface_.sl();
        this.makeTurtlePixels();
        this.updateTurtleColor(Colors.colorarray[interface_.colortool().curcolor * 32]);
    }

    static {
        colorTransparent = 0xC0C0C0;
        colorBlack = -16777216;
    }
}

