/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import starlogo.Colors;
import starlogo.NShapeEditor;
import starlogo.NShapePaintSelect;

public class NShapeColorTool
extends Panel
implements MouseListener,
MouseMotionListener {
    static int cellHeight1 = 15;
    static int cellHeight2 = 21;
    static int cellWidth = 24;
    NShapePaintSelect paintselect;
    public int colorDown = 0;
    public int shadeDown = 5;
    public int curcolor = 5;
    NShapeEditor parent;

    public void paintComponent(Graphics graphics) {
        int n;
        Color color = graphics.getColor();
        int n2 = 0;
        while (n2 < 14) {
            n = n2 * 10 + this.shadeDown;
            graphics.setColor(Colors.colorarray[n * 32]);
            graphics.fillRect(0, n2 * cellHeight1, cellWidth, cellHeight1);
            ++n2;
        }
        Color color2 = Colors.colorarray[this.curcolor * 32];
        n = 255 - color2.getBlue();
        int n3 = 255 - color2.getGreen();
        int n4 = 255 - color2.getRed();
        Color color3 = new Color(n4, n3, n);
        graphics.setColor(color3);
        graphics.drawRect(0, this.colorDown * cellHeight1, cellWidth - 1, cellHeight1 - 1);
        int n5 = 0;
        while (n5 < 10) {
            int n6 = this.colorDown * 10 + n5;
            graphics.setColor(Colors.colorarray[n6 * 32]);
            graphics.fillRect(cellWidth, n5 * cellHeight2, cellWidth, cellHeight2);
            ++n5;
        }
        graphics.setColor(color3);
        graphics.drawRect(cellWidth, this.shadeDown * cellHeight2, cellWidth - 1, cellHeight2 - 1);
        graphics.setColor(color);
    }

    public void pointToButton(int n, int n2) {
        int n3 = (int)Math.floor(n / cellWidth);
        if (n3 == 0) {
            int n4 = (int)Math.floor(n2 / cellHeight1);
            this.setColor(n4, this.shadeDown);
        } else {
            int n5 = (int)Math.floor(n2 / cellHeight2);
            this.setColor(this.colorDown, n5);
        }
    }

    public void setColor(int n) {
        if (n < 0 || n > 139) {
            return;
        }
        this.setColor(n / 10, n % 10);
    }

    public void setColor(int n, int n2) {
        this.paintselect.deselect();
        if (n == this.colorDown && n2 == this.shadeDown) {
            return;
        }
        this.colorDown = n;
        this.shadeDown = n2;
        this.curcolor = this.colorDown * 10 + this.shadeDown;
        this.repaint();
    }

    public Color getColor() {
        return Colors.colorarray[this.curcolor * 32];
    }

    public int getColorInt() {
        return Colors.colorarrayints[this.curcolor * 32];
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.pointToButton(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public NShapeColorTool(NShapeEditor nShapeEditor) {
        this.parent = nShapeEditor;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

